/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.datagen.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AddTableLootExtendedLootModifier
extends LootModifier {
    public static final MapCodec<AddTableLootExtendedLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IGlobalLootModifier.LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(glm -> glm.conditions), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("table").forGetter(AddTableLootExtendedLootModifier::table), (App)Codec.STRING.listOf().fieldOf("tables_to_apply").forGetter(AddTableLootExtendedLootModifier::tablesToApply), (App)Codec.BOOL.optionalFieldOf("blacklist", (Object)false).forGetter(AddTableLootExtendedLootModifier::blacklist)).apply((Applicative)instance, AddTableLootExtendedLootModifier::new));
    private final ResourceKey<LootTable> table;
    private final List<String> tablesToApply;
    private final boolean blacklist;
    private final HashSet<ResourceKey<LootTable>> resolvedTables = new HashSet();
    private boolean hasResolvedTables = false;

    public AddTableLootExtendedLootModifier(LootItemCondition[] conditionsIn, ResourceKey<LootTable> table, List<String> lootTables, boolean blacklist) {
        super(conditionsIn);
        this.table = table;
        this.tablesToApply = lootTables;
        this.blacklist = blacklist;
    }

    public ResourceKey<LootTable> table() {
        return this.table;
    }

    public List<String> tablesToApply() {
        return this.tablesToApply;
    }

    public boolean blacklist() {
        return this.blacklist;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext context) {
        ResourceKey queriedKey;
        boolean shouldApply;
        if (!this.hasResolvedTables) {
            for (String table : this.tablesToApply) {
                ResourceLocation parsedTable = ResourceLocation.tryParse((String)table);
                if (parsedTable != null) {
                    this.resolvedTables.add((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)parsedTable));
                    continue;
                }
                context.getLevel().getServer().reloadableRegistries().get().registryOrThrow(Registries.LOOT_TABLE).registryKeySet().forEach(key -> {
                    String path = key.location().toString();
                    if (path.matches(table) && !path.equals(this.table.location().toString())) {
                        this.resolvedTables.add((ResourceKey<LootTable>)key);
                    }
                });
            }
            this.hasResolvedTables = true;
        }
        if ((shouldApply = this.resolvedTables.contains(queriedKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)context.getQueriedLootTableId()))) == this.blacklist) {
            return generatedLoot;
        }
        context.getResolver().get(Registries.LOOT_TABLE, this.table).ifPresent(extraTable -> ((LootTable)extraTable.value()).getRandomItemsRaw(context, LootTable.createStackSplitter((ServerLevel)context.getLevel(), arg_0 -> ((ObjectArrayList)generatedLoot).add(arg_0))));
        return generatedLoot;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

