/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.DietEntry;
import by.dragonsurvivalteam.dragonsurvival.common.items.armor.DarkDragonArmorItem;
import by.dragonsurvivalteam.dragonsurvival.common.items.armor.LightDragonArmorItem;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.data_maps.DietEntryProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSBlockTags;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.BuiltInDragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DSItemTags
extends ItemTagsProvider {
    @Translation(comments={"Light Armor"})
    public static final TagKey<Item> LIGHT_ARMOR = DSItemTags.key("light_armor");
    @Translation(comments={"Dark Armor"})
    public static final TagKey<Item> DARK_ARMOR = DSItemTags.key("dark_armor");
    @Translation(comments={"Dragon Claw Weapons"})
    public static final TagKey<Item> CLAW_WEAPONS = DSItemTags.key("claw_weapons");
    @Translation(comments={"Light Source"})
    public static final TagKey<Item> LIGHT_SOURCE = DSItemTags.key("light_source");
    @Translation(comments={"Activates Dragon Beacon"})
    public static final TagKey<Item> ACTIVATES_DRAGON_BEACON = DSItemTags.key("activates_dragon_beacon");
    @Translation(comments={"Uncommon Armor (Texture)"})
    public static final TagKey<Item> UNCOMMON_ARMOR = DSItemTags.key("uncommon_armor");
    @Translation(comments={"Rare Armor (Texture)"})
    public static final TagKey<Item> RARE_ARMOR = DSItemTags.key("rare_armor");
    @Translation(comments={"Epic Armor (Texture)"})
    public static final TagKey<Item> EPIC_ARMOR = DSItemTags.key("epic_armor");
    @Translation(comments={"Dragon Altars"})
    public static final TagKey<Item> DRAGON_ALTARS = DSItemTags.key("dragon_altars");
    @Translation(comments={"Dragon Treasures"})
    public static final TagKey<Item> DRAGON_TREASURES = DSItemTags.key("dragon_treasures");
    @Translation(comments={"Wooden Dragon Doors"})
    public static final TagKey<Item> WOODEN_DRAGON_DOORS = DSItemTags.key("wooden_dragon_doors");
    @Translation(comments={"Small Wooden Dragon Doors"})
    public static final TagKey<Item> SMALL_WOODEN_DRAGON_DOORS = DSItemTags.key("small_wooden_dragon_doors");
    @Translation(comments={"Charred Food"})
    public static final TagKey<Item> CHARRED_FOOD = DSItemTags.key("charred_food");
    @Translation(comments={"Cold Items"})
    public static final TagKey<Item> COLD_ITEMS = DSItemTags.key("cold_items");
    @Translation(comments={"Primordial Anchor Fuel"})
    public static final TagKey<Item> PRIMORDIAL_ANCHOR_FUEL = DSItemTags.key("primordial_anchor_fuel");

    public DSItemTags(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, @Nullable ExistingFileHelper helper) {
        super(output, provider, blockTags, "dragonsurvival", helper);
    }

    protected void addTags(@NotNull HolderLookup.Provider provider) {
        this.addToVanillaTags();
        this.tagDragonSpeciesFood(provider);
        DSItems.REGISTRY.getEntries().forEach(holder -> {
            Item item = (Item)holder.value();
            if (item instanceof LightDragonArmorItem) {
                this.tag(LIGHT_ARMOR).add((Object)item);
            } else if (item instanceof DarkDragonArmorItem) {
                this.tag(DARK_ARMOR).add((Object)item);
            }
        });
        this.tag(CLAW_WEAPONS).addTag(ItemTags.SWORDS).addTag(Tags.Items.MELEE_WEAPON_TOOLS);
        this.tag(LIGHT_SOURCE).addTag(Tags.Items.DUSTS_GLOWSTONE).add((Object)Items.TORCH).add((Object)Items.LANTERN).add((Object)Items.GLOWSTONE);
        this.tag(ACTIVATES_DRAGON_BEACON).add((Object)((Item)DSItems.BEACON_ACTIVATOR.value()));
        this.tag(UNCOMMON_ARMOR);
        this.tag(RARE_ARMOR);
        this.tag(EPIC_ARMOR);
        this.tag(CHARRED_FOOD).add((Object)((Item)DSItems.CHARGED_COAL.value())).add((Object)((Item)DSItems.CHARGED_SOUP.value())).add((Object)((Item)DSItems.CHARRED_MEAT.value())).add((Object)((Item)DSItems.CHARRED_MUSHROOM.value())).add((Object)((Item)DSItems.CHARRED_SEAFOOD.value())).add((Object)((Item)DSItems.CHARRED_VEGETABLE.value()));
        this.tag(COLD_ITEMS).add((Object)Items.SNOWBALL).add((Object)Items.ICE).add((Object)Items.PACKED_ICE).add((Object)Items.SNOW).add((Object)Items.SNOW_BLOCK).add((Object)Items.POWDER_SNOW_BUCKET).addOptional(ResourceLocation.fromNamespaceAndPath((String)"immersive_weathering", (String)"icicle"));
        this.tag(PRIMORDIAL_ANCHOR_FUEL).add((Object)Items.ENDER_PEARL);
        this.tag(DSItemTags.key("enchantable/chest_armor_and_elytra")).addTag(ItemTags.CHEST_ARMOR_ENCHANTABLE).add((Object)Items.ELYTRA);
        this.copy(DSBlockTags.DRAGON_ALTARS, DRAGON_ALTARS);
        this.copy(DSBlockTags.DRAGON_TREASURES, DRAGON_TREASURES);
        this.copy(DSBlockTags.SMALL_WOODEN_DRAGON_DOORS, SMALL_WOODEN_DRAGON_DOORS);
        this.copy(DSBlockTags.WOODEN_DRAGON_DOORS, WOODEN_DRAGON_DOORS);
    }

    private void tagDragonSpeciesFood(@NotNull HolderLookup.Provider provider) {
        provider.lookupOrThrow(DragonSpecies.REGISTRY).listElements().forEach(species -> {
            List<DietEntry> diet;
            TagKey<Item> dragonFood = DSItemTags.key(LangKey.FOOD.apply(species.getKey().location()));
            if (species.key() == BuiltInDragonSpecies.CAVE_DRAGON) {
                diet = DietEntryProvider.caveDiet();
            } else if (species.key() == BuiltInDragonSpecies.FOREST_DRAGON) {
                diet = DietEntryProvider.forestDiet();
            } else if (species.key() == BuiltInDragonSpecies.SEA_DRAGON) {
                diet = DietEntryProvider.seaDiet();
            } else {
                throw new IllegalStateException("Diet tag setup is missing for dragon species [" + species.getRegisteredName() + "]");
            }
            for (DietEntry entry : diet) {
                if (entry.items().startsWith("#")) {
                    this.tag(dragonFood).addOptionalTag(ResourceLocation.parse((String)entry.items().substring(1)));
                    continue;
                }
                this.tag(dragonFood).addOptional(ResourceLocation.parse((String)entry.items()));
            }
        });
    }

    private void addToVanillaTags() {
        DSItems.REGISTRY.getEntries().forEach(holder -> {
            Item item = (Item)holder.value();
            if (item instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)item;
                switch (armor.getEquipmentSlot()) {
                    case HEAD: {
                        this.tag(ItemTags.HEAD_ARMOR).add((Object)item);
                        break;
                    }
                    case CHEST: {
                        this.tag(ItemTags.CHEST_ARMOR).add((Object)item);
                        break;
                    }
                    case FEET: {
                        this.tag(ItemTags.FOOT_ARMOR).add((Object)item);
                        break;
                    }
                    case LEGS: {
                        this.tag(ItemTags.LEG_ARMOR).add((Object)item);
                    }
                }
            } else if (item instanceof SwordItem) {
                this.tag(ItemTags.SWORDS).add((Object)item);
            }
        });
    }

    public static TagKey<Item> key(@NotNull String name) {
        return ItemTags.create((ResourceLocation)DragonSurvival.res(name));
    }

    @NotNull
    public String getName() {
        return "Dragon Survival Item tags";
    }
}

