/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.gui.DisplayType;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.EnderDragonMarkHandler;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.FlightData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.Storage;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public interface ClientEffectProvider {
    public static final ResourceLocation UNKNOWN_ICON = DragonSurvival.res("textures/gui/ability_effect/generic_icons/unknown.png");
    public static final ClientData NONE = new ClientData(DragonSurvival.res("none"), DragonSurvival.MISSING_TEXTURE, (Component)Component.literal((String)"N/A"), (Component)Component.empty());

    public static List<ClientEffectProvider> getProviders(boolean isInventory) {
        boolean isVisible = DisplayType.isVisible(isInventory);
        if (!isVisible && DisplayType.ALWAYS_VISIBLE.isEmpty()) {
            return List.of();
        }
        Player player = DragonSurvival.PROXY.getLocalPlayer();
        if (player == null) {
            return List.of();
        }
        ArrayList<ClientEffectProvider> providers = new ArrayList<ClientEffectProvider>();
        for (Storage<ClientEffectProvider> storage : DSDataAttachments.getStorages((Entity)player, ClientEffectProvider.class)) {
            providers.addAll(storage.all());
        }
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (handler.isDragon()) {
            FlightData flightData = FlightData.getData(player);
            if (flightData.hasFlight && flightData.areWingsSpread) {
                providers.add(FlightData.FLIGHT_EFFECT);
            }
            if (handler.markedByEnderDragon) {
                providers.add(EnderDragonMarkHandler.MARK_EFFECT);
            }
        }
        providers.removeIf(provider -> provider.isHidden() || !isVisible && !DisplayType.ALWAYS_VISIBLE.contains(provider.clientData().id().toString()));
        return providers;
    }

    default public boolean isInfiniteDuration() {
        return this.getDuration() == -1;
    }

    default public boolean isHidden() {
        return false;
    }

    public Component getDescription();

    public ClientData clientData();

    public int getDuration();

    public int currentDuration();

    public record ClientData(ResourceLocation id, ResourceLocation texture, Component name, Component effectSource) {
        public static final Codec<ClientData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ClientData::id), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(ClientData::texture), (App)ComponentSerialization.CODEC.fieldOf("name").forGetter(ClientData::name), (App)ComponentSerialization.CODEC.optionalFieldOf("effect_source", (Object)Component.empty()).forGetter(ClientData::effectSource)).apply((Applicative)instance, ClientData::new));

        public static ClientData from(ResourceLocation id, ServerPlayer dragon, DragonAbilityInstance ability, Optional<ResourceLocation> customIcon) {
            ResourceLocation icon = customIcon.orElse(ability.getIcon().withPrefix("textures/gui/sprites/").withSuffix(".png"));
            return new ClientData(id, icon, (Component)Component.translatable((String)Translation.Type.ABILITY.wrap(ability.location())), dragon.getName());
        }

        public static ClientData from(ResourceLocation id, Holder<DragonPenalty> penalty, Optional<ResourceLocation> customIcon) {
            ResourceLocation icon = customIcon.orElse(((DragonPenalty)penalty.value()).icon().orElse(UNKNOWN_ICON));
            return new ClientData(id, icon, (Component)Component.translatable((String)Translation.Type.PENALTY.wrap(penalty.getKey().location())), (Component)Component.empty());
        }
    }
}

