/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.block_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.block_effects.AbilityBlockEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public record BonemealEffect(LevelBasedValue attempts, LevelBasedValue probability) implements AbilityBlockEffect
{
    public static final MapCodec<BonemealEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("attempts").forGetter(BonemealEffect::attempts), (App)LevelBasedValue.CODEC.fieldOf("probability").forGetter(BonemealEffect::probability)).apply((Applicative)instance, BonemealEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, BlockPos position, Direction direction) {
        if (dragon.getRandom().nextDouble() > (double)this.probability().calculate(ability.level())) {
            return;
        }
        BlockState state = dragon.serverLevel().getBlockState(position);
        Block block = state.getBlock();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
            float attempts = this.attempts().calculate(ability.level());
            int i = 0;
            while ((float)i < attempts) {
                if (!bonemealableBlock.isValidBonemealTarget((LevelReader)dragon.level(), position, state)) {
                    return;
                }
                bonemealableBlock.performBonemeal(dragon.serverLevel(), dragon.getRandom(), position, state);
                dragon.level().levelEvent(1505, position, 15);
                ++i;
            }
        }
    }

    @Override
    public MapCodec<? extends AbilityBlockEffect> blockCodec() {
        return CODEC;
    }
}

