/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.DamageModification;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record DamageModificationEffect(List<DamageModification> modifications) implements AbilityEntityEffect
{
    public static final MapCodec<DamageModificationEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DamageModification.CODEC.listOf().fieldOf("modifications").forGetter(DamageModificationEffect::modifications)).apply((Applicative)instance, DamageModificationEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        this.modifications.forEach(modification -> modification.apply(dragon, ability, target));
    }

    @Override
    public void remove(ServerPlayer dragon, DragonAbilityInstance ability, Entity entity, boolean isAutoRemoval) {
        this.modifications.forEach(modification -> {
            if (!isAutoRemoval || modification.shouldRemoveAutomatically()) {
                modification.remove(entity);
            }
        });
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        for (DamageModification modification : this.modifications) {
            components.add(modification.getDescription(ability.level()));
        }
        return components;
    }

    public static List<AbilityEntityEffect> only(DamageModification modification) {
        return List.of(new DamageModificationEffect(List.of(modification)));
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

