/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.body;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Condition;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscCodecs;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Modifier;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ModifierType;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.UnlockableBehavior;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.AttributeModifierSupplier;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.emotes.DragonEmoteSet;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public record DragonBody(boolean isDefault, Optional<UnlockableBehavior> unlockableBehavior, List<Modifier> modifiers, boolean canHideWings, ResourceLocation model, TextureSize textureSize, ResourceLocation animation, Optional<ResourceLocation> defaultIcon, List<String> bonesToHideForToggle, Holder<DragonEmoteSet> emotes, ScalingProportions scalingProportions, double crouchHeightRatio, Optional<MountingOffsets> mountingOffsets, Optional<BackpackOffsets> backpackOffsets, double betterCombatWeaponOffset) implements AttributeModifierSupplier
{
    public static final ResourceKey<Registry<DragonBody>> REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)DragonSurvival.res("dragon_body"));
    public static final ResourceLocation DEFAULT_MODEL = DragonSurvival.res("dragon_model");
    public static final Codec<DragonBody> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("is_default", (Object)false).forGetter(DragonBody::isDefault), (App)UnlockableBehavior.CODEC.optionalFieldOf("unlockable_behavior").forGetter(DragonBody::unlockableBehavior), (App)Modifier.CODEC.listOf().fieldOf("modifiers").forGetter(DragonBody::modifiers), (App)Codec.BOOL.optionalFieldOf("can_hide_wings", (Object)true).forGetter(DragonBody::canHideWings), (App)ResourceLocation.CODEC.optionalFieldOf("model", (Object)DEFAULT_MODEL).forGetter(DragonBody::model), (App)TextureSize.CODEC.optionalFieldOf("texture_size", (Object)new TextureSize(512, 512)).forGetter(DragonBody::textureSize), (App)ResourceLocation.CODEC.fieldOf("animation").forGetter(DragonBody::animation), (App)ResourceLocation.CODEC.optionalFieldOf("default_icon").forGetter(DragonBody::defaultIcon), (App)Codec.STRING.listOf().optionalFieldOf("bones_to_hide_for_toggle", List.of("WingLeft", "WingRight", "SmallWingLeft", "SmallWingRight")).forGetter(DragonBody::bonesToHideForToggle), (App)DragonEmoteSet.CODEC.fieldOf("emotes").forGetter(DragonBody::emotes), (App)ScalingProportions.CODEC.fieldOf("scaling_proportions").forGetter(DragonBody::scalingProportions), (App)MiscCodecs.doubleRange(0.0, 1.0).fieldOf("crouch_height_ratio").forGetter(DragonBody::crouchHeightRatio), (App)MountingOffsets.CODEC.optionalFieldOf("mounting_offset").forGetter(DragonBody::mountingOffsets), (App)BackpackOffsets.CODEC.optionalFieldOf("backpack_offset").forGetter(DragonBody::backpackOffsets), (App)Codec.DOUBLE.optionalFieldOf("bettercombat_weapon_offset", (Object)0.0).forGetter(DragonBody::betterCombatWeaponOffset)).apply((Applicative)instance, instance.stable(DragonBody::new)));
    public static final Codec<Holder<DragonBody>> CODEC = RegistryFixedCodec.create(REGISTRY);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<DragonBody>> STREAM_CODEC = ByteBufCodecs.holderRegistry(REGISTRY);
    private static final RandomSource RANDOM = RandomSource.create();

    public static List<UnlockableBehavior.BodyEntry> getBodies(ServerPlayer player, boolean isEditor) {
        ArrayList<UnlockableBehavior.BodyEntry> entries = new ArrayList<UnlockableBehavior.BodyEntry>();
        ResourceHelper.all((HolderLookup.Provider)player.registryAccess(), REGISTRY).forEach(body -> {
            UnlockableBehavior behaviour = ((DragonBody)body.value()).unlockableBehavior().orElse(null);
            if (behaviour == null) {
                entries.add(new UnlockableBehavior.BodyEntry((Holder<DragonBody>)body, true));
                return;
            }
            boolean isUnlocked = behaviour.unlockCondition().map(condition -> condition.test((Object)Condition.entityContext(player.serverLevel(), (Entity)player))).orElse(true);
            UnlockableBehavior.Visibility visibility = behaviour.visibility().orElse(null);
            if (isEditor) {
                if (visibility == UnlockableBehavior.Visibility.ALWAYS_VISIBLE) {
                    entries.add(new UnlockableBehavior.BodyEntry((Holder<DragonBody>)body, isUnlocked));
                    return;
                }
                if (visibility == UnlockableBehavior.Visibility.ALWAYS_HIDDEN) {
                    return;
                }
            }
            if (isUnlocked) {
                entries.add(new UnlockableBehavior.BodyEntry((Holder<DragonBody>)body, true));
                return;
            }
            if (isEditor && visibility == UnlockableBehavior.Visibility.VISIBLE_IF_LOCKED) {
                entries.add(new UnlockableBehavior.BodyEntry((Holder<DragonBody>)body, false));
            }
        });
        return entries;
    }

    @SubscribeEvent
    public static void register(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(REGISTRY, DIRECT_CODEC, DIRECT_CODEC);
    }

    public static boolean bodyIsValidForSpecies(Holder<DragonBody> body, @Nullable Holder<DragonSpecies> species) {
        if (species == null) {
            return ((DragonBody)body.value()).isDefault();
        }
        return DragonBody.bodyIsValidForSpecies(body, (DragonSpecies)species.value());
    }

    public static boolean bodyIsValidForSpecies(Holder<DragonBody> body, DragonSpecies species) {
        return species.bodies().size() == 0 && ((DragonBody)body.value()).isDefault() || species.bodies().contains(body);
    }

    public static Holder<DragonBody> getRandomUnlocked(ServerPlayer player) {
        return DragonBody.getRandomUnlocked(DragonStateProvider.getData((Player)player).species(), DragonBody.getBodies(player, false));
    }

    public static Holder<DragonBody> getRandomUnlocked(@Nullable Holder<DragonSpecies> species, List<UnlockableBehavior.BodyEntry> unlockedBodies) {
        List<Holder> validBodiesForSpecies = unlockedBodies.stream().filter(bodyEntry -> DragonBody.bodyIsValidForSpecies(bodyEntry.body(), species) && bodyEntry.isUnlocked()).map(UnlockableBehavior.BodyEntry::body).toList();
        return validBodiesForSpecies.get(RANDOM.nextInt(validBodiesForSpecies.size()));
    }

    public static HolderSet<DragonBody> getBodiesForSpecies(@Nullable HolderLookup.Provider provider, @Nullable Holder<DragonSpecies> species) {
        if (species == null || ((DragonSpecies)species.value()).bodies().size() == 0) {
            return DragonBody.getDefaultBodies(provider);
        }
        List<Holder.Reference<DragonBody>> all = ResourceHelper.all(provider, REGISTRY);
        List<Holder.Reference> bodiesForSpecies = all.stream().filter(body -> ((DragonSpecies)species.value()).bodies().contains((Holder)body)).toList();
        return HolderSet.direct(bodiesForSpecies);
    }

    private static HolderSet<DragonBody> getDefaultBodies(@Nullable HolderLookup.Provider provider) {
        List<Holder.Reference<DragonBody>> all = ResourceHelper.all(provider, REGISTRY);
        List<Holder.Reference> defaultBodies = all.stream().filter(body -> ((DragonBody)body.value()).isDefault()).toList();
        return HolderSet.direct(defaultBodies);
    }

    public static Holder<DragonBody> getRandom(@Nullable HolderLookup.Provider provider, @Nullable Holder<DragonSpecies> species) {
        List<Holder.Reference<DragonBody>> all = ResourceHelper.all(provider, REGISTRY);
        all = species == null || ((DragonSpecies)species.value()).bodies().size() == 0 ? all.stream().filter(body -> ((DragonBody)body.value()).isDefault()).toList() : all.stream().filter(body -> ((DragonSpecies)species.value()).bodies().contains((Holder)body)).toList();
        if (all.isEmpty()) {
            throw new IllegalStateException("No valid bodies found for species [" + String.valueOf(species) + "]");
        }
        return (Holder)all.get(RANDOM.nextInt(all.size()));
    }

    @Override
    public ModifierType getModifierType() {
        return ModifierType.DRAGON_BODY;
    }

    public static String getWingButtonName(Holder<DragonBody> holder) {
        return Translation.Type.BODY_WINGS.wrap(holder.getKey().location());
    }

    public static String getWingButtonDescription(Holder<DragonBody> holder) {
        return Translation.Type.BODY_WINGS_DESCRIPTION.wrap(holder.getKey().location());
    }

    public record TextureSize(int width, int height) {
        public static final Codec<TextureSize> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("width").forGetter(TextureSize::width), (App)Codec.INT.fieldOf("height").forGetter(TextureSize::height)).apply((Applicative)instance, TextureSize::new));
    }

    public record ScalingProportions(double width, double height, double eyeHeight, double scaleMultiplier, double shadowMultiplier) {
        public static final Codec<ScalingProportions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MiscCodecs.doubleRange(0.0, Double.MAX_VALUE).fieldOf("width").forGetter(ScalingProportions::width), (App)MiscCodecs.doubleRange(0.0, Double.MAX_VALUE).fieldOf("height").forGetter(ScalingProportions::height), (App)MiscCodecs.doubleRange(0.0, Double.MAX_VALUE).fieldOf("eye_height").forGetter(ScalingProportions::eyeHeight), (App)MiscCodecs.doubleRange(0.0, Double.MAX_VALUE).optionalFieldOf("scale_multiplier", (Object)1.0).forGetter(ScalingProportions::scaleMultiplier), (App)MiscCodecs.doubleRange(0.0, Double.MAX_VALUE).optionalFieldOf("shadow_multiplier", (Object)1.0).forGetter(ScalingProportions::shadowMultiplier)).apply((Applicative)instance, ScalingProportions::new));

        public static ScalingProportions of(double width, double height, double eyeHeight, double offset, double shadowOffset) {
            return new ScalingProportions(width, height, eyeHeight, offset, shadowOffset);
        }
    }

    public record MountingOffsets(Vec3 humanOffset, Vec3 dragonOffset, Vec3 scale) {
        public static final Codec<MountingOffsets> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3.CODEC.optionalFieldOf("human_offset", (Object)Vec3.ZERO).forGetter(MountingOffsets::humanOffset), (App)Vec3.CODEC.optionalFieldOf("dragon_offset", (Object)Vec3.ZERO).forGetter(MountingOffsets::dragonOffset), (App)Vec3.CODEC.optionalFieldOf("offset_per_scale_above_one", (Object)Vec3.ZERO).forGetter(MountingOffsets::scale)).apply((Applicative)instance, MountingOffsets::new));

        public static MountingOffsets of(Vec3 humanOffset, Vec3 dragonOffset, Vec3 scale) {
            return new MountingOffsets(humanOffset, dragonOffset, scale);
        }
    }

    public record BackpackOffsets(Vec3 posOffset, Vec3 rotOffset, Vec3 scale) {
        public static final Codec<BackpackOffsets> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3.CODEC.optionalFieldOf("position_offset", (Object)Vec3.ZERO).forGetter(BackpackOffsets::posOffset), (App)Vec3.CODEC.optionalFieldOf("rotation_offset", (Object)Vec3.ZERO).forGetter(BackpackOffsets::rotOffset), (App)Vec3.CODEC.optionalFieldOf("scale", (Object)new Vec3(1.0, 1.0, 1.0)).forGetter(BackpackOffsets::scale)).apply((Applicative)instance, BackpackOffsets::new));

        public static BackpackOffsets of(Vec3 pos_offset, Vec3 rot_offset, Vec3 scale) {
            return new BackpackOffsets(pos_offset, rot_offset, scale);
        }
    }
}

