/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.ResourceLocationWrapper;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DataReloadHandler;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ClawInventoryData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.PenaltyEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemBlacklistPenalty
implements PenaltyEffect {
    public static final MapCodec<ItemBlacklistPenalty> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocationWrapper.validatedCodec().listOf().fieldOf("items").forGetter(ItemBlacklistPenalty::items)).apply((Applicative)instance, ItemBlacklistPenalty::new));
    private final List<String> items;
    private Set<ResourceKey<Item>> blacklisted;
    private long lastUpdate;

    public ItemBlacklistPenalty(List<String> items) {
        this.items = items;
    }

    @Override
    public void apply(ServerPlayer player, Holder<DragonPenalty> penalty) {
        this.dropAllItemsInList((Player)player, (NonNullList<ItemStack>)player.getInventory().armor);
        this.dropAllItemsInList((Player)player, (NonNullList<ItemStack>)player.getInventory().offhand);
        ClawInventoryData clawData = ClawInventoryData.getData((Player)player);
        SimpleContainer clawContainer = clawData.getContainer();
        for (int slot = 0; slot < clawContainer.getContainerSize(); ++slot) {
            ItemStack stack = clawContainer.getItem(slot);
            if (stack.isEmpty() || !this.isBlacklisted(stack.getItem())) continue;
            ItemStack removed = clawContainer.removeItem(slot, stack.getCount());
            player.drop(removed, false);
        }
        ItemStack mainHandItem = player.getMainHandItem();
        if (this.isBlacklisted(mainHandItem.getItem())) {
            player.getInventory().removeItem(mainHandItem);
            player.drop(mainHandItem, false);
        }
    }

    public boolean isBlacklisted(Item item) {
        if (this.blacklisted == null || this.lastUpdate < DataReloadHandler.lastReload) {
            this.lastUpdate = System.currentTimeMillis();
            this.blacklisted = this.map(this.items);
        }
        return this.blacklisted.contains(item.builtInRegistryHolder().getKey());
    }

    private void dropAllItemsInList(Player player, NonNullList<ItemStack> items) {
        items.forEach(stack -> {
            if (this.isBlacklisted(stack.getItem())) {
                player.getInventory().removeItem(stack);
                player.drop(stack, false);
            }
        });
    }

    private Set<ResourceKey<Item>> map(List<String> entries) {
        HashSet<ResourceKey<Item>> blacklisted = new HashSet<ResourceKey<Item>>();
        entries.forEach(entry -> blacklisted.addAll(ResourceLocationWrapper.map(entry, BuiltInRegistries.ITEM)));
        return blacklisted;
    }

    public List<String> items() {
        return this.items;
    }

    @Override
    public MapCodec<? extends PenaltyEffect> codec() {
        return CODEC;
    }
}

