/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty;

import by.dragonsurvivalteam.dragonsurvival.registry.DSAttributes;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.PenaltySupply;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.PenaltyTrigger;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;

public record SupplyTrigger(ResourceLocation supplyType, Holder<Attribute> attributeToUseAsBase, int triggerRate, float reductionRate, float regenerationRate, List<RecoveryItem> recoveryItems, boolean displayLikeHungerBar, Optional<ParticleOptions> particlesOnTrigger) implements PenaltyTrigger
{
    @Translation(comments={" every %s seconds"})
    private static final String PENALTY_SUPPLY_TRIGGER = Translation.Type.GUI.wrap("penalty.supply_trigger");
    @Translation(comments={" on every game tick"})
    private static final String PENALTY_SUPPLY_TRIGGER_CONSTANT = Translation.Type.GUI.wrap("penalty.supply_trigger.constant");
    public static final MapCodec<SupplyTrigger> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("supply_type").forGetter(SupplyTrigger::supplyType), (App)Attribute.CODEC.optionalFieldOf("attribute", DSAttributes.PENALTY_RESISTANCE_TIME).forGetter(SupplyTrigger::attributeToUseAsBase), (App)ExtraCodecs.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("trigger_rate").forGetter(SupplyTrigger::triggerRate), (App)Codec.FLOAT.fieldOf("reduction_rate").forGetter(SupplyTrigger::reductionRate), (App)Codec.FLOAT.fieldOf("regeneration_rate").forGetter(SupplyTrigger::regenerationRate), (App)RecoveryItem.CODEC.codec().listOf().optionalFieldOf("recovery_items", List.of()).forGetter(SupplyTrigger::recoveryItems), (App)Codec.BOOL.optionalFieldOf("display_like_hunger_bar", (Object)false).forGetter(SupplyTrigger::displayLikeHungerBar), (App)ParticleTypes.CODEC.optionalFieldOf("particles_on_trigger").forGetter(SupplyTrigger::particlesOnTrigger)).apply((Applicative)instance, SupplyTrigger::new));

    @Override
    public boolean matches(ServerPlayer dragon, boolean conditionMatched) {
        PenaltySupply penaltySupply = (PenaltySupply)dragon.getData(DSDataAttachments.PENALTY_SUPPLY);
        if (!conditionMatched) {
            penaltySupply.regenerate(dragon, this.supplyType);
            return false;
        }
        penaltySupply.reduce(dragon, this.supplyType);
        if (dragon.level().getGameTime() % (long)this.triggerRate() == 0L) {
            this.particlesOnTrigger.ifPresent(particle -> {
                for (int i = 0; i < 2; ++i) {
                    ((ServerLevel)dragon.level()).sendParticles(particle, dragon.getX() + (dragon.getRandom().nextDouble() - 0.5) * 0.5, dragon.getEyeY() + (dragon.getRandom().nextDouble() - 0.5) * 0.5, dragon.getZ() + (dragon.getRandom().nextDouble() - 0.5) * 0.5, 1, 0.0, -dragon.getRandom().nextDouble() * 0.25, 0.0, (double)0.025f);
                }
            });
            return !penaltySupply.hasSupply(this.supplyType);
        }
        return false;
    }

    @Override
    public MutableComponent getDescription(Player dragon) {
        AttributeInstance attribute = dragon.getAttribute(this.attributeToUseAsBase);
        if (attribute == null) {
            return Component.empty();
        }
        double seconds = Functions.ticksToSeconds((int)attribute.getValue());
        if (seconds == 0.0) {
            return Component.translatable((String)PENALTY_SUPPLY_TRIGGER_CONSTANT);
        }
        return Component.translatable((String)PENALTY_SUPPLY_TRIGGER, (Object[])new Object[]{DSColors.dynamicValue(String.format("%.1f", seconds))});
    }

    @Override
    public MapCodec<? extends PenaltyTrigger> codec() {
        return CODEC;
    }

    public record RecoveryItem(List<ItemPredicate> itemPredicates, float percentRestored) {
        public static final MapCodec<RecoveryItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemPredicate.CODEC.listOf().fieldOf("item_predicates").forGetter(RecoveryItem::itemPredicates), (App)Codec.FLOAT.fieldOf("percent_restored").forGetter(RecoveryItem::percentRestored)).apply((Applicative)instance, RecoveryItem::new));
    }
}

