/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.DSAttributes;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects.ProjectileEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public record ProjectileDamageEffect(Holder<DamageType> damageType, LevelBasedValue amount) implements ProjectileEntityEffect
{
    @Translation(comments={"\u00a76\u25a0 %s \u00a76Projectile Damage:\u00a7r %s"})
    private static final String ABILITY_PROJECTILE_DAMAGE = Translation.Type.GUI.wrap("projectile.damage_effect");
    public static final MapCodec<ProjectileDamageEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DamageType.CODEC.fieldOf("damage_type").forGetter(ProjectileDamageEffect::damageType), (App)LevelBasedValue.CODEC.fieldOf("amount").forGetter(ProjectileDamageEffect::amount)).apply((Applicative)instance, ProjectileDamageEffect::new));

    @Override
    public void apply(Projectile projectile, Entity target, int level) {
        LivingEntity entity;
        Entity entity2 = projectile.getOwner();
        LivingEntity owner = entity2 instanceof LivingEntity ? (entity = (LivingEntity)entity2) : null;
        float damageAmount = this.amount().calculate(level);
        if (owner != null) {
            damageAmount *= (float)owner.getAttributeValue(DSAttributes.DRAGON_ABILITY_DAMAGE);
        }
        target.hurt(new DamageSource(this.damageType, (Entity)projectile, (Entity)owner), damageAmount);
        if (owner != null) {
            owner.setLastHurtMob(target);
        }
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, int level) {
        MutableComponent translation = Component.translatable((String)Translation.Type.DAMAGE_TYPE.wrap(this.damageType.getKey().location()));
        float damage = this.amount.calculate(level);
        MutableComponent abilityDamage = Component.translatable((String)ABILITY_PROJECTILE_DAMAGE, (Object[])new Object[]{translation.withColor(0xFFAA00), DSColors.dynamicValue(Float.valueOf(damage))});
        float additionalDamage = damage * (float)dragon.getAttributeValue(DSAttributes.DRAGON_ABILITY_DAMAGE) - damage;
        if (additionalDamage != 0.0f) {
            abilityDamage.append((Component)Component.translatable((String)LangKey.ABILITY_ADDITIONAL_DAMAGE, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(additionalDamage))}));
        }
        return List.of(abilityDamage);
    }

    @Override
    public MapCodec<? extends ProjectileEntityEffect> codec() {
        return CODEC;
    }
}

