/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.tileentity;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.SourceOfMagicBlock;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.SourceOfMagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlockEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.server.containers.SourceOfMagicContainer;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SourceOfMagicBlockEntity
extends BlockEntity
implements Container,
MenuProvider,
GeoBlockEntity {
    @Translation(comments={"Source of Magic"})
    private static final String DISPLAY_NAME = Translation.Type.GUI.wrap("container.source_of_magic");
    private static final String SOURCE_OF_MAGIC_DATA = "source_of_magic_data";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private Map<Item, Integer> consumables;
    @Nullable
    private Set<ResourceKey<DragonSpecies>> applicableSpecies;
    private NonNullList<ItemStack> inputItem = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private int ticks;

    public SourceOfMagicBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)DSBlockEntities.SOURCE_OF_MAGIC_TILE_ENTITY.get(), position, state);
    }

    public int getCurrentDuration() {
        return this.getDuration(this.getItem(0).getItem());
    }

    public int getDuration(Item item) {
        if (this.consumables == null) {
            return 0;
        }
        return this.consumables.getOrDefault(item, 0);
    }

    public void setConsumables(List<SourceOfMagicData.Consumable> consumables) {
        HashMap<Item, Integer> map = new HashMap<Item, Integer>();
        consumables.forEach(consumable -> map.put(consumable.item(), consumable.duration()));
        this.consumables = map;
    }

    public List<SourceOfMagicData.Consumable> getConsumables() {
        if (this.consumables == null) {
            return new ArrayList<SourceOfMagicData.Consumable>();
        }
        return this.consumables.entrySet().stream().map(entry -> new SourceOfMagicData.Consumable((Item)entry.getKey(), (Integer)entry.getValue())).collect(Collectors.toList());
    }

    public int consumableAmount() {
        if (this.consumables == null) {
            return 0;
        }
        return this.consumables.size();
    }

    public boolean isApplicableFor(DragonStateHandler handler) {
        if (!handler.isDragon()) {
            return false;
        }
        if (this.applicableSpecies == null || this.applicableSpecies.isEmpty()) {
            return true;
        }
        return this.applicableSpecies.contains(handler.speciesKey());
    }

    public void setApplicableSpecies(List<ResourceKey<DragonSpecies>> applicableSpecies) {
        this.applicableSpecies = Set.copyOf(applicableSpecies);
    }

    public static void serverTick(Level level, BlockPos position, BlockState state, SourceOfMagicBlockEntity blockEntity) {
        if (!((Boolean)state.getValue((Property)SourceOfMagicBlock.FILLED)).booleanValue() && !blockEntity.isEmpty()) {
            level.setBlockAndUpdate(position, (BlockState)state.setValue((Property)SourceOfMagicBlock.FILLED, (Comparable)Boolean.valueOf(true)));
        } else if (((Boolean)state.getValue((Property)SourceOfMagicBlock.FILLED)).booleanValue() && blockEntity.isEmpty()) {
            level.setBlockAndUpdate(position, (BlockState)state.setValue((Property)SourceOfMagicBlock.FILLED, (Comparable)Boolean.valueOf(false)));
        }
        if (!blockEntity.isEmpty() && blockEntity.ticks % 120 == 0) {
            level.playLocalSound((double)position.getX(), (double)position.getY(), (double)position.getZ(), state.getBlock() == DSBlocks.CAVE_SOURCE_OF_MAGIC.value() ? SoundEvents.LAVA_AMBIENT : SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, 0.5f, 1.0f, true);
        }
        ++blockEntity.ticks;
    }

    public boolean isEmpty() {
        return this.inputItem.isEmpty() || this.getItem(0).isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return (ItemStack)this.inputItem.get(slot);
    }

    @NotNull
    public ItemStack removeItem(int index, int amount) {
        return ContainerHelper.removeItem(this.inputItem, (int)index, (int)amount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.inputItem, (int)0);
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        if (slot >= 0 && slot < this.inputItem.size()) {
            this.inputItem.set(slot, (Object)stack);
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inputItem = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inputItem, (HolderLookup.Provider)provider);
        if (tag.contains(SOURCE_OF_MAGIC_DATA)) {
            SourceOfMagicData.CODEC.decode((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.getCompound(SOURCE_OF_MAGIC_DATA)).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).ifPresent(data -> {
                SourceOfMagicData sourceOfMagicData = (SourceOfMagicData)data.getFirst();
                this.setConsumables(sourceOfMagicData.consumables());
                this.setApplicableSpecies(sourceOfMagicData.applicableSpecies());
            });
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inputItem, (HolderLookup.Provider)provider);
        List<SourceOfMagicData.Consumable> consumables = this.getConsumables();
        ArrayList<ResourceKey<DragonSpecies>> applicableSpecies = new ArrayList<ResourceKey<DragonSpecies>>();
        if (this.applicableSpecies != null) {
            applicableSpecies.addAll(this.applicableSpecies);
        }
        SourceOfMagicData sourceOfMagicData = new SourceOfMagicData(consumables, applicableSpecies);
        SourceOfMagicData.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)sourceOfMagicData).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).ifPresent(compound -> tag.put(SOURCE_OF_MAGIC_DATA, compound));
    }

    public int getContainerSize() {
        return 1;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)DISPLAY_NAME);
    }

    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory inventory, @NotNull Player player) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeBlockPos(this.worldPosition);
        return new SourceOfMagicContainer(containerId, inventory, buffer);
    }

    public void clearContent() {
        this.inputItem.clear();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

