/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DragonUtils {
    public static Holder<DragonSpecies> getType(Player entity) {
        return DragonStateProvider.getData(entity).species();
    }

    public static Holder<DragonSpecies> getType(DragonStateHandler handler) {
        return handler.species();
    }

    public static Holder<DragonBody> getBody(Player player) {
        return DragonUtils.getBody(DragonStateProvider.getData(player));
    }

    public static Holder<DragonBody> getBody(DragonStateHandler handler) {
        return handler.body();
    }

    public static boolean isBody(DragonStateHandler data, Holder<DragonBody> typeToCheck) {
        if (data == null) {
            return false;
        }
        return DragonUtils.isBody(data.body(), typeToCheck);
    }

    public static boolean isBody(Holder<DragonBody> playerBody, Holder<DragonBody> typeToCheck) {
        if (playerBody == typeToCheck) {
            return true;
        }
        if (playerBody == null || typeToCheck == null) {
            return false;
        }
        return playerBody.is(typeToCheck);
    }

    public static boolean isSpecies(DragonStateHandler handler, ResourceKey<DragonSpecies> typeToCheck) {
        return DragonUtils.isSpecies(handler.speciesKey(), typeToCheck);
    }

    public static boolean isSpecies(Entity entity, ResourceKey<DragonSpecies> typeToCheck) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        Holder<DragonSpecies> playerType = DragonStateProvider.getData(player).species();
        if (playerType == null) {
            return false;
        }
        return DragonUtils.isSpecies((ResourceKey<DragonSpecies>)playerType.getKey(), typeToCheck);
    }

    public static boolean isSpecies(Holder<DragonSpecies> first, Holder<DragonSpecies> second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return first.getKey() == second.getKey();
    }

    public static boolean isSpecies(ResourceKey<DragonSpecies> playerType, ResourceKey<DragonSpecies> typeToCheck) {
        if (playerType == typeToCheck) {
            return true;
        }
        if (playerType == null || typeToCheck == null) {
            return false;
        }
        return playerType.equals(typeToCheck);
    }

    public static boolean isNearbyDragonPlayerToEntity(double detectionRadius, Level level, Entity entity) {
        List players = level.getEntitiesOfClass(Player.class, entity.getBoundingBox().inflate(detectionRadius));
        for (Player player : players) {
            if (!DragonStateProvider.isDragon((Entity)player)) continue;
            return true;
        }
        return false;
    }
}

