/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantmentUtils {
    public static int getLevel(@NotNull LivingEntity entity, @NotNull ResourceKey<Enchantment> enchantment) {
        return entity.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(enchantment).map(reference -> EnchantmentHelper.getEnchantmentLevel((Holder)reference, (LivingEntity)entity)).orElse(0);
    }

    public static int getLevel(@NotNull Level level, @NotNull ResourceKey<Enchantment> enchantment, @NotNull ItemStack stack) {
        return level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(enchantment).map(arg_0 -> ((ItemStack)stack).getEnchantmentLevel(arg_0)).orElse(0);
    }

    @Nullable
    public static Holder.Reference<Enchantment> getHolder(ResourceKey<Enchantment> enchantment) {
        HolderLookup.RegistryLookup lookup = CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT);
        if (lookup == null) {
            return null;
        }
        return lookup.get(enchantment).orElse(null);
    }

    public static void set(ItemEnchantments.Mutable enchantments, ResourceKey<Enchantment> enchantment, int level) {
        Holder.Reference<Enchantment> holder = EnchantmentUtils.getHolder(enchantment);
        if (holder != null) {
            enchantments.set(holder, level);
        }
    }
}

