/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class SpawningUtils {
    private static BlockPos findRandomSpawnPosition(Level level, Vec3 worldPos, int attempts, float radius) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < attempts; ++i) {
            float f = level.random.nextFloat() * ((float)Math.PI * 2);
            double x = worldPos.x + (double)Mth.floor((float)(Mth.cos((float)f) * radius));
            double z = worldPos.z + (double)Mth.floor((float)(Mth.sin((float)f) * radius));
            int y = level.getHeight(Heightmap.Types.WORLD_SURFACE, (int)x, (int)z);
            blockPos.set(x, (double)y, z);
            if (!level.hasChunksAt(blockPos.getX() - 10, blockPos.getY() - 10, blockPos.getZ() - 10, blockPos.getX() + 10, blockPos.getY() + 10, blockPos.getZ() + 10)) continue;
            return blockPos;
        }
        return null;
    }

    public static boolean spawn(Mob mob, Vec3 position, Level level, MobSpawnType type, int attempts, float radius, boolean useSpawnParticles) {
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos spawnPosition = SpawningUtils.findRandomSpawnPosition(level, position, attempts, radius);
        if (spawnPosition != null) {
            mob.setPos((double)spawnPosition.getX(), (double)spawnPosition.getY(), (double)spawnPosition.getZ());
            EventHooks.finalizeMobSpawn((Mob)mob, (ServerLevelAccessor)serverLevel, (DifficultyInstance)level.getCurrentDifficultyAt(spawnPosition), (MobSpawnType)type, null);
            level.addFreshEntity((Entity)mob);
            if (useSpawnParticles) {
                mob.spawnAnim();
            }
            return true;
        }
        return false;
    }

    public static boolean isAirOrFluid(BlockPos position, Level level, BlockPlaceContext context) {
        return !level.getFluidState(position).isEmpty() || level.isEmptyBlock(position) || level.getBlockState(position).canBeReplaced(context);
    }
}

