/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client;

import by.dragonsurvivalteam.dragonsurvival.client.handlers.ClientEvents;
import by.dragonsurvivalteam.dragonsurvival.client.handlers.ClientGrowthHudHandler;
import by.dragonsurvivalteam.dragonsurvival.client.handlers.magic.ClientMagicHUDHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonFoodHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RenderHudEvents {
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "hud"}, key="vanillaFoodLevel", comment={"Re-enable the vanilla hud for the food level"})
    public static Boolean vanillaFoodLevel = false;
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "hud"}, key="vanillaExperienceBar", comment={"Re-enable the vanilla hud for the experience bar"})
    public static Boolean vanillaExperienceBar = false;

    public static ForgeGui getForgeGUI() {
        return (ForgeGui)Minecraft.m_91087_().f_91065_;
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void onRenderOverlay(RenderGuiOverlayEvent.Pre event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (event.isCanceled() || minecraft.f_91066_.f_92062_) {
            return;
        }
        int screenWidth = event.getWindow().m_85445_();
        int screenHeight = event.getWindow().m_85446_();
        ResourceLocation id = event.getOverlay().id();
        if (!DragonFoodHandler.disableDragonFoodHandling && DragonFoodHandler.requireDragonFood.booleanValue() && !vanillaFoodLevel.booleanValue() && id == VanillaGuiOverlay.FOOD_LEVEL.id()) {
            boolean wasRendered = DragonFoodHandler.renderFoodBar(RenderHudEvents.getForgeGUI(), event.getGuiGraphics(), screenWidth, screenHeight);
            if (wasRendered) {
                event.setCanceled(true);
            }
        } else if (ServerConfig.consumeEXPAsMana.booleanValue() && !vanillaExperienceBar.booleanValue() && id == VanillaGuiOverlay.EXPERIENCE_BAR.id()) {
            boolean wasRendered = ClientMagicHUDHandler.renderExperienceBar(RenderHudEvents.getForgeGUI(), event.getGuiGraphics(), screenWidth);
            if (wasRendered) {
                event.setCanceled(true);
            }
        } else if (id == VanillaGuiOverlay.AIR_LEVEL.id()) {
            DragonStateHandler handler = DragonStateProvider.getHandler((Entity)ClientProxy.getLocalPlayer());
            if (handler == null || !handler.isDragon()) {
                return;
            }
            ClientEvents.renderOverlay(handler, RenderHudEvents.getForgeGUI(), event.getGuiGraphics());
            ClientMagicHUDHandler.renderAbilityHud(handler, event.getGuiGraphics(), screenWidth, screenHeight);
            ClientGrowthHudHandler.renderGrowth(handler, event.getGuiGraphics(), screenWidth, screenHeight);
        }
    }
}

