/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client;

import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class VisionHandler {
    private static boolean hadLavaVision;
    private static boolean hadWaterVision;

    @SubscribeEvent(receiveCanceled=true)
    public static void removeLavaAndWaterFog(ViewportEvent.RenderFog event) {
        if (VisionHandler.hasLavaVision() && event.getCamera().m_167685_() == FogType.LAVA) {
            event.setNearPlaneDistance(0.0f);
            event.setFarPlaneDistance(event.getRenderer().m_109152_() * 0.5f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLastEvent(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        boolean hasLavaVision = VisionHandler.hasLavaVision();
        boolean hasWaterVision = VisionHandler.hasWaterVision();
        boolean shouldUpdate = !hadLavaVision && hasLavaVision || hadLavaVision && !hasLavaVision;
        shouldUpdate = shouldUpdate || !hadWaterVision && hasWaterVision || hadWaterVision && !hasWaterVision;
        hadLavaVision = hasLavaVision;
        hadWaterVision = hasWaterVision;
        if (shouldUpdate) {
            event.getLevelRenderer().m_109818_();
        }
    }

    public static boolean hasLavaVision() {
        if (FMLEnvironment.dist != Dist.CLIENT) {
            return false;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            return player.m_21023_(DragonEffects.LAVA_VISION);
        }
        return false;
    }

    public static boolean hasWaterVision() {
        if (FMLEnvironment.dist != Dist.CLIENT) {
            return false;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            return player.m_21023_(DragonEffects.WATER_VISION);
        }
        return false;
    }
}

