/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.emotes;

import by.dragonsurvivalteam.dragonsurvival.client.emotes.Emote;
import by.dragonsurvivalteam.dragonsurvival.client.emotes.EmoteRegistry;
import by.dragonsurvivalteam.dragonsurvival.client.util.RenderingUtils;
import by.dragonsurvivalteam.dragonsurvival.client.util.TextRenderUtil;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.emotes.SyncEmote;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import com.mojang.blaze3d.platform.InputConstants;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class EmoteMenuHandler {
    private static final int PER_PAGE = 10;
    private static final ResourceLocation EMPTY_SLOT = new ResourceLocation("dragonsurvival", "textures/gui/emote/empty_slot.png");
    private static final ResourceLocation PLAY_ONCE = new ResourceLocation("dragonsurvival", "textures/gui/emote/play_once.png");
    private static final ResourceLocation PLAY_LOOPED = new ResourceLocation("dragonsurvival", "textures/gui/emote/play_looped.png");
    private static final ResourceLocation SOUND = new ResourceLocation("dragonsurvival", "textures/gui/emote/sound.png");
    private static final ResourceLocation NO_SOUND = new ResourceLocation("dragonsurvival", "textures/gui/emote/no_sound.png");
    private static final ResourceLocation BUTTON_UP = new ResourceLocation("dragonsurvival", "textures/gui/emote/button_up.png");
    private static final ResourceLocation BUTTON_DOWN = new ResourceLocation("dragonsurvival", "textures/gui/emote/button_down.png");
    private static final ResourceLocation BUTTON_LEFT = new ResourceLocation("dragonsurvival", "textures/gui/emote/button_left.png");
    private static final ResourceLocation BUTTON_RIGHT = new ResourceLocation("dragonsurvival", "textures/gui/emote/button_right.png");
    public static final ResourceLocation resetTexture = new ResourceLocation("dragonsurvival", "textures/gui/reset_icon.png");
    @ConfigRange(min=-1000.0, max=1000.0)
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "emotes"}, key="emoteXOffset", comment={"Offset the x position of the emote button in relation to its normal position"})
    public static Integer emoteXOffset = 0;
    @ConfigRange(min=-1000.0, max=1000.0)
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "emotes"}, key="emoteYOffset", comment={"Offset the y position of the emote button in relation to its normal position"})
    public static Integer emoteYOffset = 0;
    private static int emotePage = 0;
    private static boolean keybinding = false;
    private static String currentlyKeybinding = null;

    @SubscribeEvent
    public static void addEmoteButton(ScreenEvent.Init.Post initGuiEvent) {
        Screen screen = initGuiEvent.getScreen();
        currentlyKeybinding = null;
        if (screen instanceof ChatScreen) {
            ChatScreen chatScreen = (ChatScreen)screen;
            if (DragonUtils.isDragon((Entity)Minecraft.m_91087_().f_91074_)) {
                emotePage = Mth.m_14045_((int)emotePage, (int)0, (int)(EmoteMenuHandler.maxPages() - 1));
                final List<Emote> emotes = EmoteMenuHandler.getEmotes();
                if (emotes == null || emotes.size() <= 0) {
                    return;
                }
                int width = 160;
                int height = 10;
                int startX = chatScreen.f_96543_ - width;
                int startY = chatScreen.f_96544_ - 55;
                initGuiEvent.addListener((GuiEventListener)new Button(startX += emoteXOffset.intValue(), (startY += emoteYOffset.intValue()) - 12 * height - 5, width, height, (Component)Component.m_237119_().m_130946_(">"), button -> {}, Supplier::get){

                    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                        this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.m_5711_() && mouseY < this.m_252907_() + this.m_93694_();
                        DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
                        this.f_93623_ = this.f_93624_ = handler.getEmoteData().emoteMenuOpen;
                        if (!handler.getEmoteData().emoteMenuOpen) {
                            return;
                        }
                        int color = new Color(0.15f, 0.15f, 0.15f, 0.75f).getRGB();
                        guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), color);
                        int j = this.getFGColor();
                        guiGraphics.m_280137_(Minecraft.m_91087_().f_91062_, emotePage + 1 + "/" + EmoteMenuHandler.maxPages(), this.m_252754_() + this.m_5711_() / 2, this.m_252907_() + (this.m_93694_() - 8) / 2, j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
                    }

                    public boolean m_6375_(double mouseX, double mouseY, int button) {
                        return false;
                    }
                });
                initGuiEvent.addListener((GuiEventListener)new Button(startX + width / 4 - 10, startY - 12 * height - 5, 15, height, (Component)Component.m_237119_(), button -> {
                    if (emotePage > 0) {
                        emotePage = Mth.m_14045_((int)(emotePage - 1), (int)0, (int)(EmoteMenuHandler.maxPages() - 1));
                        emotes.clear();
                        emotes.addAll(EmoteMenuHandler.getEmotes());
                    }
                    currentlyKeybinding = null;
                }, Supplier::get){

                    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                        this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.m_5711_() && mouseY < this.m_252907_() + this.m_93694_();
                        DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
                        this.f_93623_ = this.f_93624_ = handler.getEmoteData().emoteMenuOpen;
                        if (!handler.getEmoteData().emoteMenuOpen) {
                            return;
                        }
                        if (this.f_93622_) {
                            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), new Color(0.35f, 0.35f, 0.35f, 0.75f).getRGB());
                        }
                        guiGraphics.m_280163_(BUTTON_LEFT, this.m_252754_() + (this.m_5711_() - 9) / 2, this.m_252907_() + (this.m_93694_() - 9) / 2, 0.0f, 0.0f, 9, 9, 9, 9);
                    }
                });
                initGuiEvent.addListener((GuiEventListener)new Button(startX + width - (width / 4 + 5), startY - 12 * height - 5, 15, height, (Component)Component.m_237119_(), button -> {
                    if (emotePage < EmoteMenuHandler.maxPages() - 1) {
                        emotePage = Mth.m_14045_((int)(emotePage + 1), (int)0, (int)(EmoteMenuHandler.maxPages() - 1));
                        emotes.clear();
                        emotes.addAll(EmoteMenuHandler.getEmotes());
                    }
                    currentlyKeybinding = null;
                }, Supplier::get){

                    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                        this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.m_5711_() && mouseY < this.m_252907_() + this.m_93694_();
                        DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
                        this.f_93623_ = this.f_93624_ = handler.getEmoteData().emoteMenuOpen;
                        if (!handler.getEmoteData().emoteMenuOpen) {
                            return;
                        }
                        if (this.f_93622_) {
                            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), new Color(0.35f, 0.35f, 0.35f, 0.75f).getRGB());
                        }
                        guiGraphics.m_280163_(BUTTON_RIGHT, this.m_252754_() + (this.m_5711_() - 9) / 2, this.m_252907_() + (this.m_93694_() - 9) / 2, 0.0f, 0.0f, 9, 9, 9, 9);
                    }
                });
                initGuiEvent.addListener((GuiEventListener)new Button(startX, startY, width, height, (Component)Component.m_237119_().m_130946_(">"), btn -> {
                    DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
                    handler.getEmoteData().emoteMenuOpen = !handler.getEmoteData().emoteMenuOpen;
                    NetworkHandler.CHANNEL.sendToServer((Object)new SyncEmote(Minecraft.m_91087_().f_91074_.m_19879_(), handler.getEmoteData()));
                    currentlyKeybinding = null;
                }, Supplier::get){

                    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                        this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
                        DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
                        int color = this.f_93622_ ? new Color(0.35f, 0.35f, 0.35f, 0.75f).getRGB() : new Color(0.15f, 0.15f, 0.15f, 0.75f).getRGB();
                        guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, color);
                        int j = this.getFGColor();
                        guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"ds.emote.toggle"), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
                        if (handler.getEmoteData().emoteMenuOpen) {
                            guiGraphics.m_280163_(BUTTON_UP, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 9, 9, 9, 9);
                        } else {
                            guiGraphics.m_280163_(BUTTON_DOWN, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 9, 9, 9, 9);
                        }
                    }
                });
                int i = 0;
                while (i < 10) {
                    final int finalI = i++;
                    initGuiEvent.addListener((GuiEventListener)new Button(startX, startY - 20 - height * (9 - finalI), width, height, (Component)Component.m_237119_(), btn -> {
                        Emote emote;
                        DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
                        Emote emote2 = emote = emotes.size() > finalI ? (Emote)emotes.get(finalI) : null;
                        if (emote == null || Stream.of(handler.getEmoteData().currentEmotes).anyMatch(s -> s != null && Objects.equals(s.animation, emote.animation))) {
                            return;
                        }
                        if (emote.blend && Stream.of(handler.getEmoteData().currentEmotes).anyMatch(s -> s != null && s.blend) || !emote.blend && Stream.of(handler.getEmoteData().currentEmotes).anyMatch(s -> s != null && !s.blend)) {
                            EmoteMenuHandler.clearEmotes((Entity)Minecraft.m_91087_().f_91074_);
                        }
                        EmoteMenuHandler.addEmote(emote);
                    }, Supplier::get){

                        public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                            Emote emote;
                            DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
                            this.f_93623_ = this.f_93624_ = handler.getEmoteData().emoteMenuOpen;
                            boolean bl = this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.m_5711_() && mouseY < this.m_252907_() + this.m_93694_();
                            if (!handler.getEmoteData().emoteMenuOpen) {
                                return;
                            }
                            int color = this.f_93622_ && emotes.size() > finalI ? new Color(0.1f, 0.1f, 0.1f, 0.8f).getRGB() : new Color(0.1f, 0.1f, 0.1f, 0.5f).getRGB();
                            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), color);
                            Emote emote2 = emote = emotes.size() > finalI ? (Emote)emotes.get(finalI) : null;
                            if (emote != null) {
                                guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)emote.name), this.m_252754_() + 22, this.m_252907_() + (this.m_93694_() - 8) / 2, Color.lightGray.getRGB());
                                guiGraphics.m_280163_(emote.loops ? PLAY_LOOPED : PLAY_ONCE, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 10, 10, 10, 10);
                                guiGraphics.m_280163_(emote.sound != null ? SOUND : NO_SOUND, this.m_252754_() + 10, this.m_252907_(), 0.0f, 0.0f, 10, 10, 10, 10);
                            }
                        }
                    });
                    initGuiEvent.addListener((GuiEventListener)new ExtendedButton(startX - 65, startY - 20 - height * (9 - finalI), 60, height, (Component)Component.m_237119_(), btn -> {
                        Emote emote;
                        Emote emote2 = emote = emotes.size() > finalI ? (Emote)emotes.get(finalI) : null;
                        if (emote != null) {
                            currentlyKeybinding = emote.id;
                        }
                    }, Supplier::get){

                        public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                            Emote emote;
                            DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
                            this.f_93624_ = handler.getEmoteData().emoteMenuOpen && keybinding;
                            this.f_93623_ = this.f_93624_;
                            boolean bl = this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.m_5711_() && mouseY < this.m_252907_() + this.m_93694_();
                            if (!handler.getEmoteData().emoteMenuOpen || !keybinding) {
                                return;
                            }
                            int color = this.f_93622_ && emotes.size() > finalI ? new Color(0.1f, 0.1f, 0.1f, 0.8f).getRGB() : new Color(0.1f, 0.1f, 0.1f, 0.5f).getRGB();
                            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), color);
                            Emote emote2 = emote = emotes.size() > finalI ? (Emote)emotes.get(finalI) : null;
                            if (emote != null) {
                                int id;
                                if (Objects.equals(currentlyKeybinding, emote.id)) {
                                    RenderingUtils.drawRect(guiGraphics, this.m_252754_(), this.m_252907_(), this.m_5711_() - 1, this.m_93694_(), new Color(0.1f, 0.1f, 0.1f, 0.8f).getRGB());
                                    TextRenderUtil.drawCenteredScaledText(guiGraphics, this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + 1, 1.0f, "...", -1);
                                } else if (handler.getEmoteData().emoteKeybinds.containsKey(emote.id) && (id = handler.getEmoteData().emoteKeybinds.get(emote.id).intValue()) != 0) {
                                    InputConstants.Key input = InputConstants.Type.KEYSYM.m_84895_(id);
                                    TextRenderUtil.drawCenteredScaledText(guiGraphics, this.m_252754_() + this.m_5711_() / 2, this.m_252907_() + 1, 1.0f, input.m_84875_().getString(), -1);
                                }
                            }
                        }

                        public boolean m_6375_(double mouseX, double mouseY, int button) {
                            if (button == 1) {
                                Emote emote;
                                DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
                                Emote emote2 = emote = emotes.size() > finalI ? (Emote)emotes.get(finalI) : null;
                                if (emote != null) {
                                    handler.getEmoteData().emoteKeybinds.put(emote.id, -1);
                                    NetworkHandler.CHANNEL.sendToServer((Object)new SyncEmote(Minecraft.m_91087_().f_91074_.m_19879_(), handler.getEmoteData()));
                                    return true;
                                }
                            }
                            return super.m_6375_(mouseX, mouseY, button);
                        }
                    });
                    initGuiEvent.addListener((GuiEventListener)new ExtendedButton(startX - 70 - height, startY - 20 - height * (9 - finalI), height, height, (Component)Component.m_237119_(), btn -> {
                        Emote emote = emotes.size() > finalI ? (Emote)emotes.get(finalI) : null;
                        DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
                        if (emote != null) {
                            currentlyKeybinding = null;
                            handler.getEmoteData().emoteKeybinds.put(emote.id, -1);
                            NetworkHandler.CHANNEL.sendToServer((Object)new SyncEmote(Minecraft.m_91087_().f_91074_.m_19879_(), handler.getEmoteData()));
                        }
                    }, Supplier::get){

                        public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                            Emote emote = emotes.size() > finalI ? (Emote)emotes.get(finalI) : null;
                            DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
                            this.f_93624_ = handler.getEmoteData().emoteMenuOpen && keybinding && emote != null && handler.getEmoteData().emoteKeybinds.getOrDefault(emote.id, -1) != -1;
                            this.f_93623_ = this.f_93624_;
                            boolean bl = this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.m_5711_() && mouseY < this.m_252907_() + this.m_93694_();
                            if (!handler.getEmoteData().emoteMenuOpen || !keybinding || emote == null || handler.getEmoteData().emoteKeybinds.getOrDefault(emote.id, -1) == -1) {
                                return;
                            }
                            int color = this.f_93622_ && emotes.size() > finalI ? new Color(0.1f, 0.1f, 0.1f, 0.8f).getRGB() : new Color(0.1f, 0.1f, 0.1f, 0.5f).getRGB();
                            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), color);
                            guiGraphics.m_280163_(resetTexture, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.m_5711_(), this.m_93694_(), this.m_5711_(), this.m_93694_());
                        }
                    });
                }
                initGuiEvent.addListener((GuiEventListener)new ExtendedButton(startX + width / 2 - width / 4, startY - height, width / 2, height, (Component)Component.m_237119_(), button -> {
                    keybinding = !keybinding;
                    currentlyKeybinding = null;
                }, Supplier::get){

                    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                        DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
                        this.f_93623_ = this.f_93624_ = handler.getEmoteData().emoteMenuOpen;
                        boolean bl = this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.m_5711_() && mouseY < this.m_252907_() + this.m_93694_();
                        if (!handler.getEmoteData().emoteMenuOpen) {
                            return;
                        }
                        int color = this.f_93622_ ? new Color(0.1f, 0.1f, 0.1f, 0.8f).getRGB() : new Color(0.1f, 0.1f, 0.1f, 0.5f).getRGB();
                        guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), color);
                        int foregroundColor = this.getFGColor();
                        guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"ds.emote.keybinds"), this.m_252754_() + this.m_5711_() / 2, this.m_252907_() + (this.m_93694_() - 8) / 2, foregroundColor | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
                    }
                });
            }
        }
    }

    public static void focusChatBox(ChatScreen screen) {
        for (GuiEventListener element : screen.m_6702_()) {
            if (!(element instanceof EditBox)) continue;
            screen.m_7522_(element);
            break;
        }
    }

    public static void clearEmotes(Entity entity) {
        if (entity instanceof Player) {
            DragonStateHandler handler = DragonUtils.getHandler(entity);
            handler.getEmoteData().currentEmotes = new Emote[4];
            handler.getEmoteData().emoteTicks = new Integer[4];
            NetworkHandler.CHANNEL.sendToServer((Object)new SyncEmote(entity.m_19879_(), handler.getEmoteData()));
        }
    }

    public static void addEmote(Emote emote) {
        DragonStateHandler cap = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
        for (int i = 0; i < 4; ++i) {
            if (cap.getEmoteData().currentEmotes[i] != null) continue;
            cap.getEmoteData().currentEmotes[i] = emote;
            break;
        }
        List<Emote> ls1 = Stream.of(cap.getEmoteData().currentEmotes).limit(4L).toList();
        List<Integer> ls2 = Stream.of(cap.getEmoteData().emoteTicks).limit(4L).toList();
        cap.getEmoteData().currentEmotes = ls1.toArray(new Emote[0]);
        cap.getEmoteData().emoteTicks = ls2.toArray(new Integer[0]);
        NetworkHandler.CHANNEL.sendToServer((Object)new SyncEmote(Minecraft.m_91087_().f_91074_.m_19879_(), cap.getEmoteData()));
    }

    public static List<Emote> getEmotes() {
        DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
        ArrayList<Emote> emotes = new ArrayList<Emote>();
        HashMap<Integer, ArrayList<Emote>> list = new HashMap<Integer, ArrayList<Emote>>();
        emotes.addAll(EmoteRegistry.EMOTES);
        emotes.removeIf(em -> {
            if (em.requirements != null) {
                if (em.requirements.type != null) {
                    boolean hasType = false;
                    for (String t : em.requirements.type) {
                        if (!t.equalsIgnoreCase(handler.getTypeName())) continue;
                        hasType = true;
                        break;
                    }
                    if (!hasType) {
                        return true;
                    }
                }
                if (em.requirements.age != null) {
                    boolean hasAge = false;
                    for (String t : em.requirements.age) {
                        if (!t.equalsIgnoreCase(handler.getLevel().name)) continue;
                        hasAge = true;
                        break;
                    }
                    return !hasAge;
                }
            }
            return false;
        });
        int num = 0;
        for (Emote emote : emotes) {
            num = EmoteMenuHandler.createMap(num, list, emote);
        }
        return list.size() > emotePage ? (List)list.get(emotePage) : new ArrayList<Emote>();
    }

    public static int maxPages() {
        int num = 0;
        HashMap<Integer, ArrayList<Emote>> list = new HashMap<Integer, ArrayList<Emote>>();
        for (Emote emote : EmoteRegistry.EMOTES) {
            num = EmoteMenuHandler.createMap(num, list, emote);
        }
        return list.keySet().size();
    }

    private static int createMap(int num, HashMap<Integer, ArrayList<Emote>> list, Emote emote) {
        if (!list.containsKey(num)) {
            list.put(num, new ArrayList());
        }
        if (list.get(num).size() >= 10) {
            list.put(++num, new ArrayList());
        }
        list.get(num).add(emote);
        return num;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onKey(InputEvent.Key keyInputEvent) {
        Screen sc = Minecraft.m_91087_().f_91080_;
        int pKeyCode = keyInputEvent.getKey();
        if (pKeyCode == -1) {
            return;
        }
        DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
        if (pKeyCode == -1) {
            return;
        }
        if (handler.isDragon()) {
            Map.Entry entry;
            if (sc instanceof ChatScreen) {
                if (currentlyKeybinding != null) {
                    if (pKeyCode == 256) {
                        handler.getEmoteData().emoteKeybinds.remove(currentlyKeybinding);
                    } else {
                        handler.getEmoteData().emoteKeybinds.put(currentlyKeybinding, keyInputEvent.getKey());
                    }
                    NetworkHandler.CHANNEL.sendToServer((Object)new SyncEmote(Minecraft.m_91087_().f_91074_.m_19879_(), handler.getEmoteData()));
                    currentlyKeybinding = null;
                }
            } else if (handler.getEmoteData().emoteKeybinds.contains(pKeyCode) && (entry = (Map.Entry)handler.getEmoteData().emoteKeybinds.entrySet().stream().filter(s -> (Integer)s.getValue() == pKeyCode).findFirst().orElse(null)) != null) {
                Emote emote = EmoteRegistry.EMOTES.stream().filter(s -> Objects.equals(s.id, entry.getKey())).findFirst().orElse(null);
                if (emote == null || Stream.of(handler.getEmoteData().currentEmotes).anyMatch(s -> s != null && Objects.equals(s.animation, emote.animation))) {
                    return;
                }
                if (emote.blend && Stream.of(handler.getEmoteData().currentEmotes).anyMatch(s -> s != null && s.blend) || !emote.blend && Stream.of(handler.getEmoteData().currentEmotes).anyMatch(s -> s != null && !s.blend)) {
                    EmoteMenuHandler.clearEmotes((Entity)Minecraft.m_91087_().f_91074_);
                }
                EmoteMenuHandler.addEmote(emote);
            }
        }
    }
}

