/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.emotes;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvivalMod;
import by.dragonsurvivalteam.dragonsurvival.client.emotes.Emote;
import by.dragonsurvivalteam.dragonsurvival.util.GsonFactory;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EmoteRegistry {
    public static final ResourceLocation CLIENT_EMOTES = new ResourceLocation("dragonsurvival", "emotes.json");
    public static final ArrayList<Emote> EMOTES = new ArrayList();
    private static boolean hasStarted = false;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientStart(FMLClientSetupEvent event) {
        EmoteRegistry.reload(Minecraft.m_91087_().m_91098_(), CLIENT_EMOTES);
        if (Minecraft.m_91087_().m_91098_() instanceof ReloadableResourceManager) {
            ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)((ResourceManagerReloadListener)manager -> {
                EMOTES.clear();
                EmoteRegistry.reload(Minecraft.m_91087_().m_91098_(), CLIENT_EMOTES);
                EmoteRegistry.initEmoteRotation();
            }));
        }
    }

    protected static void reload(ResourceManager manager, ResourceLocation location) {
        try {
            Gson gson = GsonFactory.getDefault();
            Resource resource = manager.m_213713_(location).orElse(null);
            if (resource == null) {
                throw new RuntimeException(String.format("Resource '%s' not found!", location.m_135815_()));
            }
            InputStream in = resource.m_215507_();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                EmoteRegistryClass je = (EmoteRegistryClass)gson.fromJson((Reader)reader, EmoteRegistryClass.class);
                if (je != null) {
                    List<Emote> emts = Arrays.asList(je.emotes);
                    HashMap<String, Integer> nameCount = new HashMap<String, Integer>();
                    for (Emote emt : emts) {
                        nameCount.putIfAbsent(emt.name, 0);
                        nameCount.put(emt.name, (Integer)nameCount.get(emt.name) + 1);
                        emt.id = emt.name + "_" + nameCount.get(emt.name);
                    }
                    EMOTES.addAll(emts);
                }
            }
            catch (IOException exception) {
                DragonSurvivalMod.LOGGER.warn("Reader could not be closed", (Throwable)exception);
            }
        }
        catch (IOException exception) {
            DragonSurvivalMod.LOGGER.error("Resource [" + location + "] could not be opened", (Throwable)exception);
        }
    }

    public static void initEmoteRotation() {
    }

    public static class EmoteRegistryClass {
        public Emote[] emotes;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class clientStart {
        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void clientStart(EntityJoinLevelEvent event) {
            if (!hasStarted) {
                EmoteRegistry.initEmoteRotation();
                hasStarted = true;
            }
        }
    }
}

