/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui;

import by.dragonsurvivalteam.dragonsurvival.client.gui.settings.ConfigSideSelectionScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.TabButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.DSButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.DSImageButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HelpButton;
import by.dragonsurvivalteam.dragonsurvival.client.handlers.ClientEvents;
import by.dragonsurvivalteam.dragonsurvival.client.handlers.Keybind;
import by.dragonsurvivalteam.dragonsurvival.client.util.RenderingUtils;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonGrowthHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.claw.DragonClawsMenuToggle;
import by.dragonsurvivalteam.dragonsurvival.network.claw.SyncDragonClawRender;
import by.dragonsurvivalteam.dragonsurvival.network.container.OpenInventory;
import by.dragonsurvivalteam.dragonsurvival.network.container.SortInventoryPacket;
import by.dragonsurvivalteam.dragonsurvival.server.containers.DragonContainer;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class DragonScreen
extends EffectRenderingInventoryScreen<DragonContainer> {
    public static final ResourceLocation INVENTORY_TOGGLE_BUTTON = new ResourceLocation("dragonsurvival", "textures/gui/inventory_button.png");
    public static final ResourceLocation SORTING_BUTTON = new ResourceLocation("dragonsurvival", "textures/gui/sorting_button.png");
    public static final ResourceLocation SETTINGS_BUTTON = new ResourceLocation("dragonsurvival", "textures/gui/settings_button.png");
    static final ResourceLocation BACKGROUND = new ResourceLocation("dragonsurvival", "textures/gui/dragon_inventory.png");
    private static final ResourceLocation CLAWS_TEXTURE = new ResourceLocation("dragonsurvival", "textures/gui/dragon_claws.png");
    private static final ResourceLocation DRAGON_CLAW_BUTTON = new ResourceLocation("dragonsurvival", "textures/gui/dragon_claws_button.png");
    private static final ResourceLocation DRAGON_CLAW_CHECKMARK = new ResourceLocation("dragonsurvival", "textures/gui/dragon_claws_checked.png");
    private final Player player;
    public boolean clawsMenu = false;
    private boolean buttonClicked;
    private boolean isGrowthIconHovered;
    private static HashMap<String, ResourceLocation> textures;

    private static void initResources() {
        textures = new HashMap();
        Set<String> keys = DragonTypes.staticTypes.keySet();
        for (String key : keys) {
            AbstractDragonType type = DragonTypes.staticTypes.get(key);
            String start = "textures/gui/growth/";
            String end = ".png";
            for (int i = 1; i <= DragonLevel.values().length; ++i) {
                String growthResource = DragonScreen.createTextureKey(type, "growth", "_" + i);
                textures.put(growthResource, new ResourceLocation("dragonsurvival", start + growthResource + end));
            }
            String circleResource = DragonScreen.createTextureKey(type, "circle", "");
            textures.put(circleResource, new ResourceLocation("dragonsurvival", start + circleResource + end));
        }
    }

    private static String createTextureKey(AbstractDragonType type, String textureType, String addition) {
        return textureType + "_" + type.getTypeNameLowerCase() + addition;
    }

    public DragonScreen(DragonContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.player = inv.f_35978_;
        DragonStateProvider.getCap((Entity)this.player).ifPresent(cap -> {
            this.clawsMenu = cap.getClawToolData().isMenuOpen();
        });
        this.f_97726_ = 203;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (ClientEvents.mouseX != -1.0 && ClientEvents.mouseY != -1.0 && this.f_96541_.m_91268_() != null) {
            InputConstants.m_84833_((long)this.f_96541_.m_91268_().m_85439_(), (int)212993, (double)ClientEvents.mouseX, (double)ClientEvents.mouseY);
            ClientEvents.mouseX = -1.0;
            ClientEvents.mouseY = -1.0;
        }
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        DragonStateHandler handler = DragonUtils.getHandler((Entity)this.player);
        this.m_142416_((GuiEventListener)new TabButton(this.f_97735_, this.f_97736_ - 28, TabButton.TabType.INVENTORY, (Screen)this));
        this.m_142416_((GuiEventListener)new TabButton(this.f_97735_ + 28, this.f_97736_ - 26, TabButton.TabType.ABILITY, (Screen)this));
        this.m_142416_((GuiEventListener)new TabButton(this.f_97735_ + 57, this.f_97736_ - 26, TabButton.TabType.GITHUB_REMINDER, (Screen)this));
        this.m_142416_((GuiEventListener)new TabButton(this.f_97735_ + 86, this.f_97736_ - 26, TabButton.TabType.SKINS, (Screen)this));
        this.m_142416_((GuiEventListener)new DSButton(this.f_97735_ + 27, this.f_97736_ + 10, 11, 11, button -> {
            this.clawsMenu = !this.clawsMenu;
            this.m_169413_();
            this.m_7856_();
            NetworkHandler.CHANNEL.sendToServer((Object)new DragonClawsMenuToggle(this.clawsMenu));
            DragonStateProvider.getCap((Entity)this.player).ifPresent(cap -> cap.getClawToolData().setMenuOpen(this.clawsMenu));
        }, new Component[]{Component.m_237115_((String)"ds.gui.claws")}){

            public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.m_280163_(DRAGON_CLAW_BUTTON, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 11, 11, 11, 11);
            }
        });
        this.m_142416_((GuiEventListener)new HelpButton(this.f_97735_ - 58, this.f_97736_ - 40, 32, 32, null, 0){

            @Override
            public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                this.f_93624_ = DragonScreen.this.clawsMenu;
                this.f_93623_ = DragonScreen.this.clawsMenu;
            }

            public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                DragonScreen.this.isGrowthIconHovered = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
            }
        });
        this.m_142416_((GuiEventListener)new HelpButton(this.f_97735_ - 80 + 34, this.f_97736_ + 112, 9, 9, "ds.skill.help.claws", 0){

            public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                this.f_93624_ = DragonScreen.this.clawsMenu;
                this.f_93623_ = DragonScreen.this.clawsMenu;
                super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }
        });
        this.m_142416_((GuiEventListener)new DSButton(this.f_97735_ - 80 + 34, this.f_97736_ + 140, 9, 9, (Component)Component.m_237119_(), button -> {
            boolean claws;
            handler.getClawToolData().shouldRenderClaws = claws = !handler.getClawToolData().shouldRenderClaws;
            ConfigHandler.updateConfigValue("renderDragonClaws", (Object)handler.getClawToolData().shouldRenderClaws);
            NetworkHandler.CHANNEL.sendToServer((Object)new SyncDragonClawRender(this.player.m_19879_(), claws));
        }, new Component[]{Component.m_237115_((String)"ds.gui.claws.rendering")}){

            public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                this.f_93623_ = DragonScreen.this.clawsMenu;
                DragonStateHandler handler = DragonUtils.getHandler((Entity)DragonScreen.this.player);
                if (handler.getClawToolData().shouldRenderClaws && DragonScreen.this.clawsMenu) {
                    guiGraphics.m_280163_(DRAGON_CLAW_CHECKMARK, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 9, 9, 9, 9);
                }
                this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
            }
        });
        if (ClientEvents.inventoryToggle.booleanValue()) {
            this.m_142416_((GuiEventListener)new DSImageButton(this.f_97735_ + this.f_97726_ - 28, this.f_96544_ / 2 - 30 + 47, 20, 18, 0, 0, 19, INVENTORY_TOGGLE_BUTTON, p_onPress_1_ -> {
                Minecraft.m_91087_().m_91152_((Screen)new InventoryScreen(this.player));
                NetworkHandler.CHANNEL.sendToServer((Object)new OpenInventory());
            }, new Component[]{Component.m_237115_((String)"ds.gui.toggle_inventory.vanilla")}));
        }
        this.m_142416_((GuiEventListener)new DSImageButton(this.f_97735_ + this.f_97726_ - 28, this.f_96544_ / 2 - 1, 20, 18, 0, 0, 18, SORTING_BUTTON, p_onPress_1_ -> NetworkHandler.CHANNEL.sendToServer((Object)new SortInventoryPacket()), new Component[]{Component.m_237115_((String)"ds.gui.sort")}));
        this.m_142416_((GuiEventListener)new DSImageButton(this.f_97735_ + this.f_97726_ - 28, this.f_96544_ / 2 + 35, 20, 18, 0, 0, 18, SETTINGS_BUTTON, p_onPress_1_ -> Minecraft.m_91087_().m_91152_((Screen)new ConfigSideSelectionScreen((Screen)this, Minecraft.m_91087_().f_91066_, (Component)Component.m_237115_((String)"ds.gui.tab_button.4"))), new Component[]{Component.m_237115_((String)"ds.gui.tab_button.4")}));
    }

    protected void m_280003_(@NotNull GuiGraphics guiGraphics, int p_230451_2_, int p_230451_3_) {
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        graphics.m_280218_(BACKGROUND, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        RenderSystem.disableBlend();
        DragonStateHandler handler = DragonUtils.getHandler((Entity)this.player);
        graphics.m_280588_(this.f_97735_ + 25, this.f_97736_ + 8, this.f_97735_ + 101, this.f_97736_ + 77);
        double renderedSize = Math.min(handler.getSize(), ServerConfig.DEFAULT_MAX_GROWTH_SIZE) / 6.0;
        InventoryScreen.m_274545_((GuiGraphics)graphics, (int)(this.f_97735_ + 65), (int)(this.f_97736_ + 75 + (int)(renderedSize * 1.25)), (int)((int)renderedSize + 15), (float)(this.f_97735_ + 51 - mouseX), (float)(this.f_97736_ + 75 - 50 - mouseY), (LivingEntity)this.f_96541_.f_91074_);
        graphics.m_280618_();
        if (this.clawsMenu) {
            graphics.m_280218_(CLAWS_TEXTURE, this.f_97735_ - 80, this.f_97736_, 0, 0, 77, 170);
        }
        if (this.clawsMenu) {
            if (textures == null || textures.isEmpty()) {
                DragonScreen.initResources();
            }
            double curSize = handler.getSize();
            float progress = 0.0f;
            if (handler.getLevel() == DragonLevel.NEWBORN) {
                progress = (float)((curSize - (double)DragonLevel.NEWBORN.size) / (double)(DragonLevel.YOUNG.size - DragonLevel.NEWBORN.size));
            } else if (handler.getLevel() == DragonLevel.YOUNG) {
                progress = (float)((curSize - (double)DragonLevel.YOUNG.size) / (double)(DragonLevel.ADULT.size - DragonLevel.YOUNG.size));
            } else if (handler.getLevel() == DragonLevel.ADULT && handler.getSize() < 40.0) {
                progress = (float)((curSize - (double)DragonLevel.ADULT.size) / (double)(40 - DragonLevel.ADULT.size));
            } else if (handler.getLevel() == DragonLevel.ADULT && handler.getSize() >= 40.0) {
                progress = (float)((curSize - 40.0) / (ServerConfig.maxGrowthSize - 40.0));
            }
            int size = 34;
            int thickness = 5;
            int circleX = this.f_97735_ - 58;
            int circleY = this.f_97736_ - 40;
            int sides = 6;
            int radius = size / 2;
            Color c = new Color(99, 99, 99);
            RenderSystem.setShaderColor((float)((float)c.brighter().getRed() / 255.0f), (float)((float)c.brighter().getBlue() / 255.0f), (float)((float)c.brighter().getGreen() / 255.0f), (float)1.0f);
            RenderingUtils.drawSmoothCircle(graphics, circleX + radius, circleY + radius, radius, sides, 1.0, 0.0);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)textures.get(DragonScreen.createTextureKey(handler.getType(), "circle", "")));
            RenderingUtils.drawTexturedCircle(graphics, circleX + radius, circleY + radius, radius, 0.5, 0.5, 0.5, sides, progress, -0.5);
            RenderSystem.setShaderColor((float)((float)c.getRed() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)1.0f);
            RenderingUtils.drawSmoothCircle(graphics, circleX + radius, circleY + radius, radius - thickness, sides, 1.0, 0.0);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280398_(textures.get(DragonScreen.createTextureKey(handler.getType(), "growth", "_" + (handler.getLevel().ordinal() + 1))), circleX + 6, circleY + 6, 150, 0.0f, 0.0f, 20, 20, 20, 20);
        }
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean m_7933_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_231046_1_, (int)p_231046_2_);
        if (Keybind.DRAGON_INVENTORY.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
        if (this.isGrowthIconHovered) {
            DragonStateHandler handler = DragonUtils.getHandler((Entity)this.player);
            String age = (int)handler.getSize() - handler.getLevel().size + "/";
            double seconds = 0.0;
            if (handler.getLevel() == DragonLevel.NEWBORN) {
                age = age + (DragonLevel.YOUNG.size - handler.getLevel().size);
                missing = (double)DragonLevel.YOUNG.size - handler.getSize();
                increment = (double)(DragonLevel.YOUNG.size - DragonLevel.NEWBORN.size) / ((double)DragonGrowthHandler.newbornToYoung * 20.0) * ServerConfig.newbornGrowthModifier;
                seconds = missing / increment / 20.0;
            } else if (handler.getLevel() == DragonLevel.YOUNG) {
                age = age + (DragonLevel.ADULT.size - handler.getLevel().size);
                missing = (double)DragonLevel.ADULT.size - handler.getSize();
                increment = (double)(DragonLevel.ADULT.size - DragonLevel.YOUNG.size) / ((double)DragonGrowthHandler.youngToAdult * 20.0) * ServerConfig.youngGrowthModifier;
                seconds = missing / increment / 20.0;
            } else if (handler.getLevel() == DragonLevel.ADULT && handler.getSize() < 40.0) {
                age = age + (40 - handler.getLevel().size);
                missing = 40.0 - handler.getSize();
                increment = (double)(40 - DragonLevel.ADULT.size) / ((double)DragonGrowthHandler.adultToMax * 20.0) * ServerConfig.adultGrowthModifier;
                seconds = missing / increment / 20.0;
            } else if (handler.getLevel() == DragonLevel.ADULT && handler.getSize() >= 40.0) {
                age = age + (int)(ServerConfig.maxGrowthSize - (double)handler.getLevel().size);
                missing = ServerConfig.maxGrowthSize - handler.getSize();
                increment = (ServerConfig.maxGrowthSize - 40.0) / ((double)DragonGrowthHandler.beyond * 20.0) * ServerConfig.maxGrowthModifier;
                seconds = missing / increment / 20.0;
            }
            if (seconds != 0.0) {
                String hourString;
                int minutes = (int)(seconds / 60.0);
                seconds -= (double)(minutes * 60);
                int hours = minutes / 60;
                Object object = hours > 0 ? (hours >= 10 ? Integer.toString(hours) : "0" + hours) : (hourString = "00");
                String minuteString = minutes > 0 ? (minutes >= 10 ? Integer.toString(minutes) : "0" + (minutes -= hours * 60)) : "00";
                age = handler.growing ? age + " (" + hourString + ":" + minuteString + ")" : age + " (\u00a74--:--\u00a7r)";
            }
            ArrayList<Item> allowedList = new ArrayList<Item>();
            List<Item> newbornList = ConfigHandler.getResourceElements(Item.class, ServerConfig.growNewborn);
            List<Item> youngList = ConfigHandler.getResourceElements(Item.class, ServerConfig.growYoung);
            List<Item> adultList = ConfigHandler.getResourceElements(Item.class, ServerConfig.growAdult);
            if (handler.getSize() < (double)DragonLevel.YOUNG.size) {
                allowedList.addAll(newbornList);
            } else if (handler.getSize() < (double)DragonLevel.ADULT.size) {
                allowedList.addAll(youngList);
            } else {
                allowedList.addAll(adultList);
            }
            List<String> displayData = allowedList.stream().map(i -> new ItemStack((ItemLike)i).m_41611_().getString()).toList();
            StringJoiner result = new StringJoiner(", ");
            displayData.forEach(result::add);
            List<MutableComponent> components = List.of(Component.m_237110_((String)"ds.gui.growth_stage", (Object[])new Object[]{handler.getLevel().getName()}), Component.m_237110_((String)"ds.gui.growth_age", (Object[])new Object[]{age}), Component.m_237110_((String)"ds.gui.growth_help", (Object[])new Object[]{result}));
            graphics.m_280666_(Minecraft.m_91087_().f_91062_, components, mouseX, mouseY);
        }
    }

    static {
        DragonScreen.initResources();
    }
}

