/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.dragon_editor;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvivalMod;
import by.dragonsurvivalteam.dragonsurvival.client.gui.DragonAltarGUI;
import by.dragonsurvivalteam.dragonsurvival.client.gui.SkinsScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.dragon_editor.buttons.AdultEditorButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.dragon_editor.buttons.BackgroundColorButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.dragon_editor.buttons.CopySettingsButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.dragon_editor.buttons.DragonBodyButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.dragon_editor.buttons.DragonEditorDropdownButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.dragon_editor.buttons.DragonEditorSlotButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.dragon_editor.buttons.NewbornEditorButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.dragon_editor.buttons.YoungEditorButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.ColorSelectorButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.UndoRedoButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.ArrowButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.ExtendedCheckbox;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HelpButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.DragonEditorConfirmComponent;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.DragonUIRenderComponent;
import by.dragonsurvivalteam.dragonsurvival.client.handlers.magic.ClientMagicHUDHandler;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.DragonEditorHandler;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.DragonEditorRegistry;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.EnumSkinLayer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonEditorObject;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.LayerSettings;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.SkinPreset;
import by.dragonsurvivalteam.dragonsurvival.client.util.FakeClientPlayerUtils;
import by.dragonsurvivalteam.dragonsurvival.client.util.TextRenderUtil;
import by.dragonsurvivalteam.dragonsurvival.commands.DragonCommand;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonBody;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonBodies;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import by.dragonsurvivalteam.dragonsurvival.network.dragon_editor.SyncPlayerSkinPreset;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncSpinStatus;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncAltarCooldown;
import by.dragonsurvivalteam.dragonsurvival.network.syncing.CompleteDataSync;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.ServerFlightHandler;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import by.dragonsurvivalteam.dragonsurvival.util.GsonFactory;
import com.google.common.collect.EvictingQueue;
import com.google.gson.Gson;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.Queue;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.common.util.Lazy;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;

public class DragonEditorScreen
extends Screen {
    private static final ResourceLocation backgroundTexture = new ResourceLocation("textures/block/black_concrete.png");
    private static final ResourceLocation RESET_POSITION = new ResourceLocation("dragonsurvival", "textures/gui/reset_position_button.png");
    private static final ResourceLocation SAVE = new ResourceLocation("dragonsurvival", "textures/gui/save_icon.png");
    private static final ResourceLocation RANDOM = new ResourceLocation("dragonsurvival", "textures/gui/random_icon.png");
    private static final ResourceLocation RESET = new ResourceLocation("dragonsurvival", "textures/gui/reset_button.png");
    public final ConcurrentHashMap<Integer, EvictingQueue<CompoundTag>> UNDO_QUEUES = new ConcurrentHashMap();
    public final ConcurrentHashMap<Integer, EvictingQueue<CompoundTag>> REDO_QUEUES = new ConcurrentHashMap();
    private final Screen source;
    private final String[] animations = new String[]{"sit_dentist", "sit_head_locked", "idle_head_locked", "fly_head_locked", "swim_fast_head_locked", "run_head_locked", "spinning_on_back"};
    @ConfigRange(min=1.0, max=1000.0)
    @ConfigOption(side=ConfigSide.CLIENT, category={"misc"}, key="editorHistory", comment={"The amount of undos and redos that are saved in the dragon editor."})
    public static Integer editorHistory = 10;
    public int HISTORY_SIZE = editorHistory;
    public int guiLeft;
    public int guiTop;
    public boolean confirmation;
    public boolean showUi = true;
    public DragonUIRenderComponent dragonRender;
    public static final DragonStateHandler handler = new DragonStateHandler();
    public DragonLevel level;
    public AbstractDragonType dragonType;
    public AbstractDragonBody dragonBody;
    public SkinPreset preset;
    public int currentSelected;
    private HashMap<DragonLevel, Integer> presetSelections = new HashMap();
    public int backgroundColor = -804253680;
    float tick;
    private int curAnimation;
    private int lastSelected;
    private boolean hasInit;
    private DragonEditorConfirmComponent conf;
    private boolean isEditor;

    public DragonEditorScreen(Screen source) {
        this(source, null);
        this.isEditor = true;
    }

    public DragonEditorScreen(Screen source, AbstractDragonType dragonType) {
        super((Component)Component.m_237115_((String)"ds.gui.dragon_editor"));
        this.source = source;
        this.dragonType = dragonType;
    }

    private static void reverseQueue(Queue<CompoundTag> queue) {
        CompoundTag curr;
        int i;
        int n = queue.size();
        Stack<CompoundTag> stack = new Stack<CompoundTag>();
        for (i = 0; i < n; ++i) {
            curr = queue.poll();
            stack.push(curr);
        }
        for (i = 0; i < n; ++i) {
            curr = (CompoundTag)stack.pop();
            queue.add(curr);
        }
    }

    public void doAction() {
        this.UNDO_QUEUES.computeIfAbsent(this.currentSelected, s -> EvictingQueue.create((int)this.HISTORY_SIZE));
        this.REDO_QUEUES.computeIfAbsent(this.currentSelected, s -> EvictingQueue.create((int)this.HISTORY_SIZE));
        this.REDO_QUEUES.get(this.currentSelected).clear();
        DragonEditorScreen.reverseQueue((Queue)this.UNDO_QUEUES.get(this.currentSelected));
        this.UNDO_QUEUES.get(this.currentSelected).add((Object)this.preset.writeNBT());
        DragonEditorScreen.reverseQueue((Queue)this.UNDO_QUEUES.get(this.currentSelected));
    }

    public void undoAction() {
        this.UNDO_QUEUES.computeIfAbsent(this.currentSelected, s -> EvictingQueue.create((int)this.HISTORY_SIZE));
        this.REDO_QUEUES.computeIfAbsent(this.currentSelected, s -> EvictingQueue.create((int)this.HISTORY_SIZE));
        if (this.UNDO_QUEUES.get(this.currentSelected).size() > 0) {
            DragonEditorScreen.reverseQueue((Queue)this.REDO_QUEUES.get(this.currentSelected));
            this.REDO_QUEUES.get(this.currentSelected).add((Object)this.preset.writeNBT());
            DragonEditorScreen.reverseQueue((Queue)this.REDO_QUEUES.get(this.currentSelected));
            this.preset.readNBT((CompoundTag)this.UNDO_QUEUES.get(this.currentSelected).poll());
            handler.getSkinData().compileSkin();
            this.update();
        }
    }

    public void redoAction() {
        this.UNDO_QUEUES.computeIfAbsent(this.currentSelected, s -> EvictingQueue.create((int)this.HISTORY_SIZE));
        this.REDO_QUEUES.computeIfAbsent(this.currentSelected, s -> EvictingQueue.create((int)this.HISTORY_SIZE));
        if (this.REDO_QUEUES.get(this.currentSelected).size() > 0) {
            DragonEditorScreen.reverseQueue((Queue)this.UNDO_QUEUES.get(this.currentSelected));
            this.UNDO_QUEUES.get(this.currentSelected).add((Object)this.preset.writeNBT());
            DragonEditorScreen.reverseQueue((Queue)this.UNDO_QUEUES.get(this.currentSelected));
            this.preset.readNBT((CompoundTag)this.REDO_QUEUES.get(this.currentSelected).poll());
            handler.getSkinData().compileSkin();
            this.update();
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        if (this.dragonRender == null) {
            this.m_7856_();
        }
        this.tick += pPartialTicks;
        if (this.tick >= 1200.0f) {
            this.save();
            this.tick = 0.0f;
        }
        if (this.showUi) {
            this.dragonRender.x = this.f_96543_ / 2 - 70;
            this.dragonRender.y = this.guiTop;
            this.dragonRender.width = 140;
            this.dragonRender.height = 125;
        } else {
            this.dragonRender.x = 0;
            this.dragonRender.width = this.f_96543_;
        }
        FakeClientPlayerUtils.getFakePlayer((int)0, (DragonStateHandler)DragonEditorScreen.handler).animationSupplier = () -> this.animations[this.curAnimation];
        this.m_280273_(guiGraphics);
        this.m_6702_().stream().filter(DragonUIRenderComponent.class::isInstance).toList().forEach(s -> ((DragonUIRenderComponent)((Object)s)).m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks));
        DragonAltarGUI.renderBorders(guiGraphics, backgroundTexture, 0, this.f_96543_, 32, this.f_96544_ - 32, this.f_96543_, this.f_96544_);
        TextRenderUtil.drawCenteredScaledText(guiGraphics, this.f_96543_ / 2, 10, 2.0f, this.f_96539_.getString(), DyeColor.WHITE.m_41071_());
        if (this.showUi) {
            int i = 0;
            for (EnumSkinLayer layers : EnumSkinLayer.values()) {
                SkinsScreen.drawNonShadowLineBreak(guiGraphics, this.f_96547_, (Component)Component.m_237115_((String)("ds.gui.dragon_editor.part." + layers.getNameLowerCase())), (i < 5 ? this.f_96543_ / 2 - 100 - 100 : this.f_96543_ / 2 + 83) + 45, this.guiTop + 10 + (i >= 5 ? (i - 5) * 30 : i * 30) - 12, DyeColor.WHITE.m_41071_());
                ++i;
            }
        }
        if (this.showUi) {
            SkinsScreen.drawNonShadowLineBreak(guiGraphics, this.f_96547_, (Component)Component.m_237119_().m_130946_(WordUtils.capitalize((String)this.animations[this.curAnimation].replace("_", " "))), this.f_96543_ / 2, this.f_96544_ / 2 + 75 - 22, DyeColor.GRAY.m_41071_());
        }
        for (Renderable widget : new CopyOnWriteArrayList(this.f_169369_)) {
            widget.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        }
        for (GuiEventListener child : this.f_96540_) {
            if (child instanceof DragonUIRenderComponent) continue;
            ((Renderable)child).m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        }
    }

    public SkinPreset save() {
        SkinPreset newPreset = new SkinPreset();
        newPreset.readNBT(this.preset.writeNBT());
        String type = this.dragonType != null ? this.dragonType.getTypeNameUpperCase() : null;
        DragonEditorRegistry.getSavedCustomizations().skinPresets.computeIfAbsent(type, key -> new HashMap());
        DragonEditorRegistry.getSavedCustomizations().skinPresets.get(type).put(this.currentSelected, newPreset);
        for (DragonLevel dl : this.presetSelections.keySet()) {
            DragonEditorRegistry.getSavedCustomizations().current.get(type).put(dl, this.presetSelections.get((Object)dl));
        }
        try {
            Gson gson = GsonFactory.newBuilder().setPrettyPrinting().create();
            FileWriter writer = new FileWriter(DragonEditorRegistry.savedFile);
            gson.toJson((Object)DragonEditorRegistry.getSavedCustomizations(), (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            DragonSurvivalMod.LOGGER.error("An error occured while trying to save the dragon skin", (Throwable)e);
        }
        return newPreset;
    }

    public void m_280273_(@NotNull GuiGraphics guiGraphics) {
        guiGraphics.m_280046_(0, 0, this.f_96543_, this.f_96544_, -350, this.backgroundColor);
    }

    private void initialize(DragonStateHandler localHandler) {
        if (this.dragonType == null && localHandler.isDragon()) {
            this.level = localHandler.getLevel();
            this.dragonType = localHandler.getType();
        }
        if (this.dragonType == null) {
            return;
        }
        if (this.dragonBody == null) {
            this.dragonBody = localHandler.getBody();
            if (this.dragonBody == null) {
                this.dragonBody = DragonBodies.getStatic("center");
            }
        }
        if (this.level == null) {
            this.level = DragonLevel.NEWBORN;
        }
        String type = this.dragonType.getTypeNameUpperCase();
        DragonEditorRegistry.getSavedCustomizations().current.computeIfAbsent(type, key -> new HashMap());
        DragonEditorRegistry.getSavedCustomizations().current.get(type).putIfAbsent(this.level, 0);
        this.currentSelected = DragonEditorRegistry.getSavedCustomizations().current.get(type).get((Object)this.level);
        DragonEditorRegistry.getSavedCustomizations().skinPresets.computeIfAbsent(type, key -> new HashMap());
        DragonEditorRegistry.getSavedCustomizations().skinPresets.get(type).computeIfAbsent(this.currentSelected, key -> {
            SkinPreset newPreset = new SkinPreset();
            newPreset.initDefaults(this.dragonType);
            return newPreset;
        });
        SkinPreset curPreset = DragonEditorRegistry.getSavedCustomizations().skinPresets.get(type).get(this.currentSelected);
        this.preset = new SkinPreset();
        this.preset.readNBT(curPreset.writeNBT());
        DragonEditorScreen.handler.getSkinData().skinPreset = this.preset;
        handler.getSkinData().compileSkin();
        this.dragonRender.zoom = this.level.size * 4 - 5;
        handler.setHasFlight(true);
        handler.setType(this.dragonType);
        handler.setBody(this.dragonBody);
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - 256) / 2;
        this.guiTop = (this.f_96544_ - 120) / 2;
        this.conf = new DragonEditorConfirmComponent(this, this.f_96543_ / 2 - 65, this.f_96544_ / 2 - 90, 130, 154);
        this.initDragonRender();
        final Minecraft minecraft = this.getMinecraft();
        if (!this.hasInit) {
            DragonStateHandler dshandler = DragonUtils.getHandler((Entity)minecraft.f_91074_);
            this.initialize(dshandler);
            this.update();
            this.hasInit = true;
        }
        this.m_142416_((GuiEventListener)new NewbornEditorButton(this));
        this.m_142416_((GuiEventListener)new YoungEditorButton(this));
        this.m_142416_((GuiEventListener)new AdultEditorButton(this));
        for (int i1 = 0; i1 < DragonBodies.ORDER.length; ++i1) {
            this.m_142416_((GuiEventListener)new DragonBodyButton(this, this.f_96543_ / 2 - 71 + i1 * 27, this.f_96544_ / 2 + 69, 25, 25, DragonBodies.getStatic(DragonBodies.ORDER[i1]), i1, this.isEditor));
        }
        int maxWidth = -1;
        for (EnumSkinLayer layers : EnumSkinLayer.values()) {
            String name = layers.name().substring(0, 1).toUpperCase(Locale.ROOT) + layers.getNameLowerCase().substring(1).replace("_", " ");
            maxWidth = (int)Math.max((float)maxWidth, (float)this.f_96547_.m_92895_(name) * 1.45f);
        }
        int i = 0;
        for (EnumSkinLayer layers : EnumSkinLayer.values()) {
            ArrayList<String> valueList = DragonEditorHandler.getKeys(this.dragonType, layers);
            if (layers != EnumSkinLayer.BASE) {
                valueList.add(0, "None");
            }
            String[] values = valueList.toArray(new String[0]);
            String curValue = DragonEditorScreen.partToTranslation(((LayerSettings)((SkinPreset.SkinAgeGroup)this.preset.skinAges.get((Object)((Object)this.level)).get()).layerSettings.get((Object)((Object)layers)).get()).selectedSkin);
            final DragonEditorDropdownButton btn2 = new DragonEditorDropdownButton(this, i < 8 ? this.f_96543_ / 2 - 210 : this.f_96543_ / 2 + 80, this.guiTop - 5 + (i >= 8 ? (i - 8) * 20 : i * 20), 100, 15, curValue, values, layers);
            this.m_142416_((GuiEventListener)btn2);
            this.m_142416_((GuiEventListener)new ArrowButton(btn2.m_252754_() - 15, btn2.m_252907_() + 1, 16, 16, false, s -> {
                int index = 0;
                for (int i1 = 0; i1 < btn.values.length; ++i1) {
                    if (!Objects.equals(btn.values[i1], btn.current)) continue;
                    index = i1;
                    break;
                }
                index = Functions.wrap(index - 1, 0, btn.values.length - 1);
                this.doAction();
                btn.current = btn.values[index];
                btn.setter.accept(btn.current);
                btn2.updateMessage();
                LayerSettings settings = (LayerSettings)((SkinPreset.SkinAgeGroup)this.preset.skinAges.get((Object)((Object)((Object)this.level))).get()).layerSettings.get((Object)layers).get();
                DragonEditorObject.Texture text = DragonEditorHandler.getSkin((Player)FakeClientPlayerUtils.getFakePlayer(0, handler), layers, settings.selectedSkin, this.dragonType);
                if (text != null && !settings.modifiedColor) {
                    settings.hue = text.average_hue.floatValue();
                }
            }){

                public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
                    this.f_93623_ = DragonEditorScreen.this.showUi;
                    if (this.f_93623_) {
                        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
                    }
                }
            });
            this.m_142416_((GuiEventListener)new ArrowButton(btn2.m_252754_() + btn2.m_5711_() - 1, btn2.m_252907_() + 1, 16, 16, true, s -> {
                int index = 0;
                for (int i1 = 0; i1 < btn.values.length; ++i1) {
                    if (!Objects.equals(btn.values[i1], btn.current)) continue;
                    index = i1;
                    break;
                }
                index = Functions.wrap(index + 1, 0, btn.values.length - 1);
                this.doAction();
                btn.current = btn.values[index];
                btn.setter.accept(btn.current);
                btn2.updateMessage();
                LayerSettings settings = (LayerSettings)((SkinPreset.SkinAgeGroup)this.preset.skinAges.get((Object)((Object)((Object)this.level))).get()).layerSettings.get((Object)layers).get();
                DragonEditorObject.Texture text = DragonEditorHandler.getSkin((Player)FakeClientPlayerUtils.getFakePlayer(0, handler), layers, settings.selectedSkin, this.dragonType);
                if (text != null && !settings.modifiedColor) {
                    settings.hue = text.average_hue.floatValue();
                }
            }){

                public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
                    boolean bl = this.f_93623_ = DragonEditorScreen.this.showUi || btn2.values == null || btn2.values.length <= 1;
                    if (DragonEditorScreen.this.showUi) {
                        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
                    }
                }
            });
            this.m_142416_((GuiEventListener)new ColorSelectorButton(this, layers, btn2.m_252754_() + 14 + btn2.m_5711_() + 2, btn2.m_252907_(), btn2.m_93694_(), btn2.m_93694_(), s -> {
                this.doAction();
                ((LayerSettings)((SkinPreset.SkinAgeGroup)this.preset.skinAges.get((Object)((Object)((Object)this.level))).get()).layerSettings.get((Object)((Object)((Object)layers))).get()).hue = s.floatValue();
                handler.getSkinData().compileSkin();
                this.update();
            }));
            ++i;
        }
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 45, this.f_96544_ / 2 + 75 - 27, 15, 15, (Component)Component.m_237119_(), btn -> {
            ++this.curAnimation;
            if (this.curAnimation >= this.animations.length) {
                this.curAnimation = 0;
            }
        }, Supplier::get){

            public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
                this.f_93623_ = this.f_93624_ = DragonEditorScreen.this.showUi;
                super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
            }

            public void m_87963_(@NotNull GuiGraphics guiGraphics, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
                if (this.m_198029_()) {
                    guiGraphics.m_280163_(ClientMagicHUDHandler.widgetTextures, this.m_252754_(), this.m_252907_(), 33.0f, 111.0f, 11, 17, 128, 128);
                } else {
                    guiGraphics.m_280163_(ClientMagicHUDHandler.widgetTextures, this.m_252754_(), this.m_252907_(), 22.0f, 111.0f, 11, 17, 128, 128);
                }
            }
        });
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 45 - 20, this.f_96544_ / 2 + 75 - 27, 15, 15, (Component)Component.m_237119_(), btn -> {
            --this.curAnimation;
            if (this.curAnimation < 0) {
                this.curAnimation = this.animations.length - 1;
            }
        }, Supplier::get){

            public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
                this.f_93623_ = this.f_93624_ = DragonEditorScreen.this.showUi;
                super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
            }

            public void m_87963_(@NotNull GuiGraphics guiGraphics, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ClientMagicHUDHandler.widgetTextures);
                if (this.m_198029_()) {
                    guiGraphics.m_280163_(ClientMagicHUDHandler.widgetTextures, this.m_252754_(), this.m_252907_(), 11.0f, 111.0f, 11, 17, 128, 128);
                } else {
                    guiGraphics.m_280163_(ClientMagicHUDHandler.widgetTextures, this.m_252754_(), this.m_252907_(), 0.0f, 111.0f, 11, 17, 128, 128);
                }
            }
        });
        for (int num = 1; num <= 9; ++num) {
            this.m_142416_((GuiEventListener)new DragonEditorSlotButton(this.f_96543_ / 2 + 200 + 15, this.guiTop + (num - 1) * 12 + 5 + 30, num, this));
        }
        ExtendedCheckbox wingsCheckBox = new ExtendedCheckbox(this.f_96543_ / 2 - 220, this.f_96544_ - 25, 120, 17, 17, (Component)Component.m_237115_((String)"ds.gui.dragon_editor.wings"), ((SkinPreset.SkinAgeGroup)this.preset.skinAges.get((Object)((Object)this.level)).get()).wings, p -> {
            ((SkinPreset.SkinAgeGroup)this.preset.skinAges.get((Object)((Object)((Object)this.level))).get()).wings = p.m_93840_();
        }){

            @Override
            public void m_87963_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
                this.f_93822_ = ((SkinPreset.SkinAgeGroup)DragonEditorScreen.this.preset.skinAges.get((Object)((Object)DragonEditorScreen.this.level)).get()).wings;
                super.m_87963_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
            }

            public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
                if (this.m_198029_()) {
                    guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"ds.gui.dragon_editor.wings.tooltip"), pMouseX, pMouseY);
                }
            }
        };
        this.m_142416_((GuiEventListener)wingsCheckBox);
        this.m_142416_((GuiEventListener)new ExtendedCheckbox(this.f_96543_ / 2 + 100, this.f_96544_ - 25, 120, 17, 17, (Component)Component.m_237115_((String)"ds.gui.dragon_editor.default_skin"), ((SkinPreset.SkinAgeGroup)this.preset.skinAges.get((Object)((Object)this.level)).get()).defaultSkin, p -> {
            ((SkinPreset.SkinAgeGroup)this.preset.skinAges.get((Object)((Object)((Object)this.level))).get()).defaultSkin = p.m_93840_();
        }){

            @Override
            public void m_87963_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
                this.f_93822_ = ((SkinPreset.SkinAgeGroup)DragonEditorScreen.this.preset.skinAges.get((Object)((Object)DragonEditorScreen.this.level)).get()).defaultSkin;
                super.m_87963_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
            }

            public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
                if (this.m_198029_()) {
                    guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"ds.gui.dragon_editor.default_skin.tooltip"), pMouseX, pMouseY);
                }
            }
        });
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 75 - 10, this.f_96544_ - 25, 75, 20, (Component)Component.m_237115_((String)"ds.gui.dragon_editor.save"), null){
            Renderable renderButton;
            boolean toggled;

            public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
                super.m_87963_(guiGraphics, mouseX, mouseY, partial);
                if (!(!this.toggled || this.f_93624_ && DragonEditorScreen.this.confirmation)) {
                    this.toggled = false;
                    Screen screen = Minecraft.m_91087_().f_91080_;
                    screen.f_96540_.removeIf(s -> s == DragonEditorScreen.this.conf);
                    screen.f_169369_.removeIf(s -> s == this.renderButton);
                }
            }

            public void m_5691_() {
                DragonStateProvider.getCap((Entity)minecraft.f_91074_).ifPresent(cap -> {
                    minecraft2.f_91074_.m_9236_().m_5594_((Player)minecraft2.f_91074_, minecraft2.f_91074_.m_20183_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 0.7f);
                    if (!((cap.getType() == null || cap.getType().equals(DragonEditorScreen.this.dragonType)) && (cap.getBody() == null || cap.getBody().equals(DragonEditorScreen.this.dragonBody)) || ServerConfig.saveAllAbilities.booleanValue() && ServerConfig.saveGrowthStage.booleanValue())) {
                        DragonEditorScreen.this.confirmation = true;
                        return;
                    }
                    if (!DragonEditorScreen.this.confirmation) {
                        DragonEditorScreen.this.confirm();
                    }
                });
                if (DragonEditorScreen.this.confirmation) {
                    if (!this.toggled) {
                        this.renderButton = new ExtendedButton(0, 0, 0, 0, (Component)Component.m_237119_(), null){

                            public void m_88315_(@NotNull GuiGraphics guiGraphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
                                this.f_93624_ = false;
                                this.f_93623_ = false;
                                if (DragonEditorScreen.this.conf != null && DragonEditorScreen.this.confirmation) {
                                    DragonEditorScreen.this.conf.m_88315_(guiGraphics, p_230430_2_, p_230430_3_, p_230430_4_);
                                }
                            }
                        };
                        DragonEditorScreen.this.f_96540_.add(0, DragonEditorScreen.this.conf);
                        DragonEditorScreen.this.f_96540_.add(DragonEditorScreen.this.conf);
                        DragonEditorScreen.this.f_169369_.add(this.renderButton);
                    }
                    this.toggled = !this.toggled;
                } else {
                    DragonEditorScreen.this.f_96540_.removeIf(s -> s == DragonEditorScreen.this.conf);
                    DragonEditorScreen.this.f_169369_.removeIf(s -> s == this.renderButton);
                }
            }

            public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
                if (this.m_198029_()) {
                    guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"ds.gui.dragon_editor.tooltip.done"), pMouseX, pMouseY);
                }
            }
        });
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 + 10, this.f_96544_ - 25, 75, 20, (Component)Component.m_237115_((String)"ds.gui.dragon_editor.back"), null){

            public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
                super.m_87963_(guiGraphics, mouseX, mouseY, partial);
            }

            public void m_5691_() {
                Minecraft.m_91087_().m_91152_(DragonEditorScreen.this.source);
            }

            public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
                if (this.m_198029_()) {
                    guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"ds.gui.dragon_editor.tooltip.back"), pMouseX, pMouseY);
                }
            }
        });
        this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 290, 11, 18, 18, (Component)Component.m_237119_(), btn -> {
            this.doAction();
            this.preset.skinAges.put(this.level, (Lazy<SkinPreset.SkinAgeGroup>)Lazy.of(() -> new SkinPreset.SkinAgeGroup(this.level, this.dragonType)));
            wingsCheckBox.f_93822_ = true;
            handler.getSkinData().compileSkin();
            this.update();
        }){

            public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
                if (this.m_198029_()) {
                    guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"ds.gui.dragon_editor.reset"), pMouseX, pMouseY);
                }
            }

            public void m_87963_(@NotNull GuiGraphics guiGraphics, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
                guiGraphics.m_280163_(RESET, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
            }
        });
        this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 260, 11, 18, 18, (Component)Component.m_237119_(), btn -> {
            this.doAction();
            ArrayList<String> extraKeys = DragonEditorHandler.getKeys((Player)FakeClientPlayerUtils.getFakePlayer(0, handler), EnumSkinLayer.EXTRA);
            extraKeys.removeIf(s -> {
                DragonEditorObject.Texture text = DragonEditorHandler.getSkin((Player)FakeClientPlayerUtils.getFakePlayer(0, handler), EnumSkinLayer.EXTRA, s, this.dragonType);
                if (text == null) {
                    DragonSurvivalMod.LOGGER.error("Key " + s + " not found!");
                    return true;
                }
                return !text.random;
            });
            for (EnumSkinLayer layer : EnumSkinLayer.values()) {
                ArrayList<String> keys = DragonEditorHandler.getKeys((Player)FakeClientPlayerUtils.getFakePlayer(0, handler), layer);
                if (Objects.equals(layer.name, "Extra")) {
                    keys = extraKeys;
                }
                if (layer != EnumSkinLayer.BASE) {
                    keys.add("None");
                }
                if (!keys.isEmpty()) {
                    String key = keys.get(minecraft.f_91074_.m_217043_().m_188503_(keys.size()));
                    if (Objects.equals(layer.name, "Extra")) {
                        extraKeys.remove(key);
                    }
                    LayerSettings settings = (LayerSettings)((SkinPreset.SkinAgeGroup)this.preset.skinAges.get((Object)((Object)((Object)this.level))).get()).layerSettings.get((Object)layer).get();
                    settings.selectedSkin = key;
                    DragonEditorObject.Texture text = DragonEditorHandler.getSkin((Player)FakeClientPlayerUtils.getFakePlayer(0, handler), layer, key, this.dragonType);
                    if (text != null && text.randomHue) {
                        settings.hue = minecraft.f_91074_.m_217043_().m_188501_();
                        settings.saturation = 0.25f + minecraft.f_91074_.m_217043_().m_188501_() * 0.5f;
                        settings.brightness = 0.3f + minecraft.f_91074_.m_217043_().m_188501_() * 0.3f;
                        settings.modifiedColor = true;
                    } else {
                        settings.hue = text != null ? text.average_hue.floatValue() : 0.0f;
                        settings.saturation = 0.5f;
                        settings.brightness = 0.5f;
                        settings.modifiedColor = true;
                    }
                }
                handler.getSkinData().compileSkin();
            }
            this.update();
        }){

            public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
                if (this.m_198029_()) {
                    guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"ds.gui.dragon_editor.random"), pMouseX, pMouseY);
                }
            }

            public void m_87963_(@NotNull GuiGraphics guiGraphics, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
                guiGraphics.m_280163_(RANDOM, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
            }
        });
        this.m_142416_((GuiEventListener)new UndoRedoButton(this.guiLeft + 318, 11, 18, 18, false, button -> this.undoAction()){

            public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
                this.f_93623_ = DragonEditorScreen.this.UNDO_QUEUES.containsKey(DragonEditorScreen.this.currentSelected) && !DragonEditorScreen.this.UNDO_QUEUES.get(DragonEditorScreen.this.currentSelected).isEmpty();
                super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
                if (this.m_198029_()) {
                    guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"ds.gui.dragon_editor.undo"), pMouseX, pMouseY);
                }
            }
        });
        this.m_142416_((GuiEventListener)new UndoRedoButton(this.guiLeft + 340, 11, 18, 18, true, button -> this.redoAction()){

            public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
                this.f_93623_ = DragonEditorScreen.this.REDO_QUEUES.containsKey(DragonEditorScreen.this.currentSelected) && !DragonEditorScreen.this.REDO_QUEUES.get(DragonEditorScreen.this.currentSelected).isEmpty();
                super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
                if (this.m_198029_()) {
                    guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"ds.gui.dragon_editor.redo"), pMouseX, pMouseY);
                }
            }
        });
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 + 213, this.guiTop + 10, 18, 18, (Component)Component.m_237119_(), button -> {}){

            public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
                this.f_93623_ = this.f_93624_ = DragonEditorScreen.this.showUi;
                super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
                if (this.f_93624_) {
                    guiGraphics.m_280163_(SAVE, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 16, 16, 16, 16);
                    if (this.m_198029_()) {
                        guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"ds.gui.dragon_editor.save_slot"), pMouseX, pMouseY);
                    }
                }
            }

            public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
            }
        });
        this.m_142416_((GuiEventListener)new CopySettingsButton(this, this.guiLeft + 230, 11, 18, 18, (Component)Component.m_237119_(), button -> {}));
        this.m_142416_((GuiEventListener)new ExtendedCheckbox(this.guiLeft - 15, 11, 40, 18, 18, (Component)Component.m_237115_((String)"ds.gui.dragon_editor.show_ui"), this.showUi, p -> {
            this.showUi = p.m_93840_();
        }));
        this.m_142416_((GuiEventListener)new BackgroundColorButton(this.guiLeft - 45, 11, 18, 18, (Component)Component.m_237119_(), s -> {}, this));
        this.m_142416_((GuiEventListener)new HelpButton(this.dragonType, this.guiLeft - 75, 11, 15, 15, "ds.help.customization", 1));
    }

    public void update() {
        if (this.dragonType != null) {
            handler.setType(this.dragonType);
        }
        handler.setBody(this.dragonBody);
        DragonEditorScreen.handler.getSkinData().skinPreset = this.preset;
        handler.setSize(this.level.size);
        handler.setHasFlight(true);
        if (this.currentSelected != this.lastSelected) {
            this.preset = new SkinPreset();
            if (DragonEditorRegistry.getSavedCustomizations().skinPresets.containsKey(this.dragonType.getTypeNameUpperCase())) {
                this.preset.readNBT(DragonEditorRegistry.getSavedCustomizations().skinPresets.get(this.dragonType.getTypeNameUpperCase()).get(this.currentSelected).writeNBT());
            }
            DragonEditorScreen.handler.getSkinData().skinPreset = this.preset;
        }
        this.presetSelections.put(this.level, this.currentSelected);
        this.lastSelected = this.currentSelected;
        this.initDragonRender();
    }

    private void initDragonRender() {
        this.f_96540_.removeIf(DragonUIRenderComponent.class::isInstance);
        float yRot = -3.0f;
        float xRot = -5.0f;
        float zoom = 0.0f;
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        if (this.dragonRender != null) {
            yRot = this.dragonRender.yRot;
            xRot = this.dragonRender.xRot;
            zoom = this.dragonRender.zoom;
            xOffset = this.dragonRender.xOffset;
            yOffset = this.dragonRender.yOffset;
        }
        this.dragonRender = new DragonUIRenderComponent(this, this.f_96543_ / 2 - 70, this.guiTop, 140, 125, () -> FakeClientPlayerUtils.getFakeDragon(0, handler));
        this.dragonRender.xRot = xRot;
        this.dragonRender.yRot = yRot;
        this.dragonRender.zoom = zoom;
        this.dragonRender.xOffset = xOffset;
        this.dragonRender.yOffset = yOffset;
        this.f_96540_.add(0, this.dragonRender);
    }

    public void confirm() {
        DragonStateProvider.getCap((Entity)this.f_96541_.f_91074_).ifPresent(cap -> {
            this.f_96541_.f_91074_.m_9236_().m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 0.7f);
            if (cap.getType() == null || !cap.getType().equals(this.dragonType) || cap.getBody() == null || !cap.getBody().equals(this.dragonBody)) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237115_((String)("ds." + this.dragonType.getTypeNameLowerCase() + "_dragon_choice")));
                if (this.dragonType == null && cap.getType() != null) {
                    DragonCommand.reInsertClawTools((Player)this.f_96541_.f_91074_, cap);
                }
                cap.setType(this.dragonType, (Player)this.f_96541_.f_91074_);
                cap.setBody(this.dragonBody, (Player)this.f_96541_.f_91074_);
                double size = cap.getSavedDragonSize(cap.getTypeName());
                if (!ServerConfig.saveGrowthStage.booleanValue() || size == 0.0) {
                    cap.setSize(DragonLevel.NEWBORN.size, (Player)this.f_96541_.f_91074_);
                } else {
                    cap.setSize(size, (Player)this.f_96541_.f_91074_);
                }
                cap.setHasFlight(ServerConfig.saveGrowthStage.booleanValue() ? cap.hasFlight() || ServerFlightHandler.startWithLevitation.booleanValue() : ServerFlightHandler.startWithLevitation);
                cap.setIsHiding(false);
                cap.getMovementData().spinLearned = ServerConfig.saveGrowthStage != false && cap.getMovementData().spinLearned;
                NetworkHandler.CHANNEL.sendToServer((Object)new CompleteDataSync(this.f_96541_.f_91074_.m_19879_(), cap.writeNBT()));
                NetworkHandler.CHANNEL.sendToServer((Object)new SyncAltarCooldown(this.f_96541_.f_91074_.m_19879_(), Functions.secondsToTicks(ServerConfig.altarUsageCooldown)));
                NetworkHandler.CHANNEL.sendToServer((Object)new SyncSpinStatus(this.f_96541_.f_91074_.m_19879_(), cap.getMovementData().spinAttack, cap.getMovementData().spinCooldown, cap.getMovementData().spinLearned));
                ClientProxy.requestClientData(handler);
            }
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                NetworkHandler.CHANNEL.sendToServer((Object)new SyncPlayerSkinPreset(this.f_96541_.f_91074_.m_19879_(), this.save()));
            }
        });
        this.f_96541_.f_91074_.m_6915_();
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY) && this.dragonRender != null && this.dragonRender.m_5953_(pMouseX, pMouseY)) {
            return this.dragonRender.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return false;
    }

    public static String partToTranslation(String part) {
        String text = "ds.skin_part." + handler.getTypeNameLowerCase() + "." + part.toLowerCase(Locale.ENGLISH);
        if (I18n.m_118936_((String)text)) {
            return text;
        }
        return part;
    }

    public static String partToTechnical(String part) {
        return part.replace("ds.skin_part.", "").replace(handler.getTypeNameLowerCase() + ".", "");
    }
}

