/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.settings;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvivalMod;
import by.dragonsurvivalteam.dragonsurvival.client.gui.settings.ConfigListMenu;
import by.dragonsurvivalteam.dragonsurvival.client.gui.settings.widgets.CycleOption;
import by.dragonsurvivalteam.dragonsurvival.client.gui.settings.widgets.DSDropDownOption;
import by.dragonsurvivalteam.dragonsurvival.client.gui.settings.widgets.DSNumberFieldOption;
import by.dragonsurvivalteam.dragonsurvival.client.gui.settings.widgets.DSTextBoxOption;
import by.dragonsurvivalteam.dragonsurvival.client.gui.settings.widgets.Option;
import by.dragonsurvivalteam.dragonsurvival.client.gui.settings.widgets.ProgressOption;
import by.dragonsurvivalteam.dragonsurvival.client.gui.settings.widgets.ResourceTextFieldOption;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.fields.TextField;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.lists.CategoryEntry;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.lists.OptionEntry;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.lists.OptionListEntry;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.lists.OptionsList;
import by.dragonsurvivalteam.dragonsurvival.client.util.TooltipUtils;
import by.dragonsurvivalteam.dragonsurvival.config.ConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.config.SyncBooleanConfig;
import by.dragonsurvivalteam.dragonsurvival.network.config.SyncEnumConfig;
import by.dragonsurvivalteam.dragonsurvival.network.config.SyncNumberConfig;
import com.electronwill.nightconfig.core.EnumGetMethod;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigScreen
extends OptionsSubScreen {
    private static final Float sliderPercentage = Float.valueOf(0.1f);
    private final ArrayList<Option> OPTIONS = new ArrayList();
    private final TreeMap<String, List<Option>> categories = new TreeMap();
    private final ArrayList<String> optionKeys = new ArrayList();
    public OptionsList list;
    private double scroll;

    public ConfigScreen(Screen screen, Options options, Component component) {
        super(screen, options, component);
        OptionsList.activeCats.clear();
        this.f_96539_ = component;
    }

    public abstract ConfigSide screenSide();

    protected void m_7856_() {
        if (this.list != null) {
            this.scroll = this.list.m_93517_();
        }
        this.OPTIONS.clear();
        this.categories.clear();
        this.optionKeys.clear();
        OptionsList.configMap.clear();
        this.list = new OptionsList(this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32);
        this.addConfigs();
        this.list.add(this.OPTIONS.toArray(new Option[0]), null);
        int categoryNumber = 0;
        for (Map.Entry<String, List<Option>> entryList : this.categories.entrySet()) {
            CategoryEntry entry = null;
            if (!entryList.getKey().isEmpty()) {
                String path;
                String lastPath = path = entryList.getKey();
                for (String pathElement : path.split("\\.")) {
                    if (this.list.findCategory(pathElement, lastPath) == null || Objects.requireNonNull(this.list.findCategory((String)pathElement, (String)lastPath)).parent != null && !Objects.requireNonNull(this.list.findCategory((String)pathElement, (String)lastPath)).parent.origName.equals(lastPath)) {
                        entry = this.list.addCategory(pathElement, entry, categoryNumber);
                        ++categoryNumber;
                    } else {
                        entry = this.list.findCategory(pathElement, lastPath);
                    }
                    lastPath = pathElement;
                }
            }
            this.list.add(entryList.getValue().toArray(new Option[0]), entry);
        }
        this.f_96540_.add(this.list);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)).m_252987_(32, this.f_96544_ - 27, 152, 20).m_253136_());
        this.m_142416_((GuiEventListener)new TextField(this.list.m_5756_() - 150 - 32, this.f_96544_ - 27, 182, 20, (Component)Component.m_237113_((String)"Search")){
            final ArrayList<CategoryEntry> categories;
            {
                this.categories = new ArrayList();
            }

            public boolean m_5534_(char codePoint, int modifiers) {
                OptionEntry entry2;
                this.categories.forEach(entry -> {
                    entry.enabled = false;
                });
                this.categories.clear();
                if (!this.m_94155_().isEmpty() && (entry2 = ConfigScreen.this.list.findClosest(this.m_94155_())) != null) {
                    CategoryEntry category = entry2.category;
                    while (category != null) {
                        category.enabled = true;
                        this.categories.add(category);
                        category = category.parent;
                    }
                    ConfigScreen.this.list.centerScrollOn(entry2);
                }
                return super.m_5534_(codePoint, modifiers);
            }
        });
        this.list.m_93410_(this.scroll);
    }

    private void addConfigs() {
        ArrayList<ConfigOption> configOptions = new ArrayList<ConfigOption>();
        for (String s : ConfigHandler.configs.getOrDefault((Object)this.screenSide(), Collections.emptyList())) {
            if (!ConfigHandler.configObjects.containsKey(s)) continue;
            ConfigOption option = ConfigHandler.configObjects.get(s);
            configOptions.add(option);
        }
        configOptions.sort((configOptionOne, configOptionTwo) -> Arrays.compare((Comparable[])configOptionOne.category(), (Comparable[])configOptionTwo.category()));
        for (ConfigOption configOption : configOptions) {
            Object joiner;
            Object value;
            Option option;
            Object tooltip0;
            String name;
            String key = configOption.key();
            Field field = ConfigHandler.configFields.get(configOption.key());
            ForgeConfigSpec.ConfigValue<?> configValue = ConfigHandler.configValues.get(configOption.key());
            String category = String.join((CharSequence)".", configOption.category());
            if (this.optionKeys.contains(key) || configValue == null) continue;
            String fullPath = String.join((CharSequence)".", List.of(category, key));
            String translatedName = Component.m_237115_((String)("ds." + fullPath)).getString();
            String translateTooltip = Component.m_237115_((String)("ds." + fullPath + ".tooltip")).getString();
            String string = name = !translatedName.equalsIgnoreCase("ds." + fullPath) ? translatedName : key;
            Object object = !translateTooltip.equalsIgnoreCase("ds." + fullPath + ".tooltip") ? translateTooltip : (tooltip0 = configOption.comment() != null ? String.join((CharSequence)"\n", configOption.comment()) : "");
            if (configOption.restart()) {
                tooltip0 = (String)tooltip0 + "\n" + I18n.m_118938_((String)"ds.config.server_restart", (Object[])new Object[0]);
            }
            ConfigRange range = field.isAnnotationPresent(ConfigRange.class) ? field.getAnnotation(ConfigRange.class) : null;
            boolean hasDecimals = field.getType() == Double.class || field.getType() == Float.class;
            Double min = range != null ? range.min() : -2.147483648E9;
            Double max = range != null ? range.max() : 2.147483647E9;
            MutableComponent tooltip = Component.m_237113_((String)tooltip0);
            Class checkType = Primitives.unwrap(field.getType());
            if (Number.class.isAssignableFrom(field.getType())) {
                BiFunction<Class, Number, Object> numberFunction = (type, val) -> {
                    BigDecimal outVal = BigDecimal.valueOf(val.doubleValue()).setScale(3, RoundingMode.FLOOR);
                    if (hasDecimals) {
                        return outVal.doubleValue();
                    }
                    return outVal.intValue();
                };
                Function<Options, Number> getter = options -> (Number)configValue.get();
                BiConsumer<Options, Number> setter = (settings, settingValue) -> {
                    ConfigHandler.updateConfigValue(configValue, numberFunction.apply(checkType, (Number)settingValue));
                    if (this.screenSide() == ConfigSide.SERVER) {
                        if (field.getType() == Double.class || field.getType() == Float.class) {
                            NetworkHandler.CHANNEL.sendToServer((Object)new SyncNumberConfig(ConfigHandler.createConfigPath(configOption), settingValue.doubleValue()));
                        } else if (field.getType() == Integer.class || field.getType() == Long.class) {
                            NetworkHandler.CHANNEL.sendToServer((Object)new SyncNumberConfig(ConfigHandler.createConfigPath(configOption), settingValue.longValue()));
                        }
                    }
                };
                option = new DSNumberFieldOption(name, min, max, getter, setter, TooltipUtils.createTooltip((Component)tooltip, 200), hasDecimals);
                OptionsList.configMap.put(option, key);
                this.addOption(category, name, option);
                continue;
            }
            if (checkType.equals(Boolean.TYPE)) {
                CycleOption<Boolean> option2 = new CycleOption<Boolean>(name, val -> (Boolean)configValue.get(), (settings, optionO, settingValue) -> {
                    ConfigHandler.updateConfigValue(configValue, settingValue);
                    if (this.screenSide() == ConfigSide.SERVER) {
                        NetworkHandler.CHANNEL.sendToServer((Object)new SyncBooleanConfig(ConfigHandler.createConfigPath(configOption), (boolean)settingValue));
                    }
                }, () -> CycleButton.m_168896_((Component)((MutableComponent)CommonComponents.f_130653_).m_130940_(ChatFormatting.GREEN), (Component)((MutableComponent)CommonComponents.f_130654_).m_130940_(ChatFormatting.RED)).m_168929_()).setTooltip(arg_0 -> ConfigScreen.lambda$addConfigs$11((Component)tooltip, arg_0));
                OptionsList.configMap.put(option2, key);
                this.addOption(category, name, option2);
                continue;
            }
            if (checkType.isEnum()) {
                Class<?> enumClass = configValue.get().getClass();
                value = null;
                Object object2 = configValue.get();
                if (object2 instanceof String) {
                    String stringValue = (String)object2;
                    value = EnumGetMethod.ORDINAL_OR_NAME.get((Object)stringValue, enumClass);
                } else {
                    object2 = configValue.get();
                    if (object2 instanceof Enum) {
                        Enum enumValue2 = (Enum)object2;
                        value = EnumGetMethod.ORDINAL_OR_NAME.get((Object)enumValue2.ordinal(), enumClass);
                    }
                }
                if (value != null) {
                    DSDropDownOption option3 = new DSDropDownOption(name, (Enum<?>)value, enumValue -> {
                        ConfigHandler.updateConfigValue(configValue, enumValue);
                        if (this.screenSide() == ConfigSide.SERVER) {
                            NetworkHandler.CHANNEL.sendToServer((Object)new SyncEnumConfig(ConfigHandler.createConfigPath(configOption), (Enum<?>)enumValue));
                        }
                    }, TooltipUtils.createTooltip((Component)tooltip, 200));
                    OptionsList.configMap.put(option3, key);
                    this.addOption(category, name, option3);
                    continue;
                }
                DragonSurvivalMod.LOGGER.error("An enum configuration seems to be broken for [" + ConfigHandler.createConfigPath(configOption) + "] - value: [" + configValue.get() + "], class: [" + configValue.get().getClass() + "]");
                continue;
            }
            if (checkType.isAssignableFrom(List.class)) {
                List listConfig;
                value = configValue.get();
                if (value instanceof List && ((listConfig = (List)value).isEmpty() || listConfig.get(0) instanceof String || listConfig.get(0) instanceof Number)) {
                    joiner = new StringJoiner(",");
                    if (!listConfig.isEmpty()) {
                        for (Object listElement : listConfig) {
                            ((StringJoiner)joiner).add("[" + listElement.toString() + "]");
                        }
                    } else {
                        ((StringJoiner)joiner).add("[]");
                    }
                    String text = Minecraft.m_91087_().f_91062_.m_92854_((FormattedText)Component.m_237113_((String)((StringJoiner)joiner).toString()), 120).getString();
                    option = new CycleOption<String>(name, options -> text, (val1, val2, val3) -> this.f_96541_.m_91152_((Screen)new ConfigListMenu((Screen)this, this.f_96541_.f_91066_, (Component)Component.m_237113_((String)name), configValue, this.screenSide(), configOption)), () -> new CycleButton.Builder(ignored -> Component.m_237113_((String)text)).m_168929_().m_168961_((Object[])new String[]{text}).m_168948_((Object)text)).setTooltip(arg_0 -> ConfigScreen.lambda$addConfigs$18((Component)tooltip, arg_0));
                    OptionsList.configMap.put(option, key);
                    this.addOption(category, name, option);
                    continue;
                }
                DragonSurvivalMod.LOGGER.warn("Invalid configuration: [" + key + "]");
                continue;
            }
            if (!checkType.isAssignableFrom(String.class) || !((joiner = configValue.get()) instanceof String)) continue;
            String stringValue = (String)joiner;
            Option option4 = ConfigHandler.isResource(configOption) ? new ResourceTextFieldOption(configOption.key(), stringValue, settings -> stringValue) : new DSTextBoxOption(stringValue, settings -> stringValue);
            OptionsList.configMap.put(option4, key);
            this.addOption(category, name, option4);
        }
    }

    private void addOption(String category, String path, Option option) {
        if (category != null) {
            this.categories.computeIfAbsent(category, key -> new ArrayList()).add(option);
        } else {
            this.OPTIONS.add(option);
        }
        this.optionKeys.add(path);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.list.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_257959_(ConfigScreen.tooltipAt(this.list, mouseX, mouseY));
    }

    public static List<FormattedCharSequence> tooltipAt(OptionsList options, int mouseX, int mouseY) {
        Optional<AbstractWidget> optional = options.getMouseOver(mouseX, mouseY);
        OptionListEntry entry = options.getEntryAtPos(mouseX, mouseY);
        if (optional.isEmpty() && entry instanceof OptionEntry) {
            OptionEntry optionEntry = (OptionEntry)entry;
            if (optionEntry.resetButton.m_274382_()) {
                Tooltip tooltip = optionEntry.resetButton.m_278622_();
                return tooltip != null ? tooltip.m_257408_(Minecraft.m_91087_()) : List.of();
            }
            optional = Optional.of(optionEntry.widget);
        }
        if (optional.isPresent() && optional.get().f_93624_ && !optional.get().m_198029_()) {
            Tooltip tooltip = optional.get().m_278622_();
            return tooltip != null ? tooltip.m_257408_(Minecraft.m_91087_()) : List.of();
        }
        return ImmutableList.of();
    }

    private static /* synthetic */ OptionInstance.TooltipSupplier lambda$addConfigs$18(Component tooltip, Minecraft minecraft) {
        return ignored -> TooltipUtils.createTooltip(tooltip, 200);
    }

    private static /* synthetic */ OptionInstance.TooltipSupplier lambda$addConfigs$11(Component tooltip, Minecraft minecraft) {
        return ignored -> TooltipUtils.createTooltip(tooltip, 200);
    }

    private static /* synthetic */ Component lambda$addConfigs$6(BiFunction numberFunction, Class checkType, Options settings, ProgressOption slider) {
        return Component.m_237113_((String)("" + numberFunction.apply(checkType, slider.get(settings))));
    }

    private static /* synthetic */ Double lambda$addConfigs$5(boolean hasDecimals, Function getter, Options options) {
        return hasDecimals ? ((Number)getter.apply(options)).doubleValue() : (double)((Number)getter.apply(options)).intValue();
    }
}

