/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.settings.widgets;

import by.dragonsurvivalteam.dragonsurvival.client.gui.settings.widgets.Option;
import by.dragonsurvivalteam.dragonsurvival.client.gui.settings.widgets.SliderButton;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ProgressOption
extends Option {
    protected final float steps;
    protected final double minValue;
    protected double maxValue;
    private final Function<Options, Double> getter;
    private final BiConsumer<Options, Double> setter;
    private final BiFunction<Options, ProgressOption, Component> toString;
    private final Tooltip tooltip;

    public ProgressOption(String pCaptionKey, double pMinValue, double pMaxValue, float pSteps, Function<Options, Double> pGetter, BiConsumer<Options, Double> pSetter, BiFunction<Options, ProgressOption, Component> pToString, Tooltip tooltip) {
        super(pCaptionKey);
        this.minValue = pMinValue;
        this.maxValue = pMaxValue;
        this.steps = pSteps;
        this.getter = pGetter;
        this.setter = pSetter;
        this.toString = pToString;
        this.tooltip = tooltip;
    }

    @Override
    public AbstractWidget createButton(Options pOptions, int pX, int pY, int pWidth) {
        return new SliderButton(pOptions, pX, pY, pWidth, 20, this, this.tooltip);
    }

    public double toPct(double pValue) {
        return Mth.m_14008_((double)((this.clamp(pValue) - this.minValue) / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
    }

    public double toValue(double pValue) {
        return this.clamp(Mth.m_14139_((double)Mth.m_14008_((double)pValue, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue));
    }

    private double clamp(double pValue) {
        if (this.steps > 0.0f) {
            pValue = this.steps * (float)Math.round(pValue / (double)this.steps);
        }
        return Mth.m_14008_((double)pValue, (double)this.minValue, (double)this.maxValue);
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float pValue) {
        this.maxValue = pValue;
    }

    public void set(Options pOptions, double pValue) {
        this.setter.accept(pOptions, pValue);
    }

    public double get(Options pOptions) {
        return this.getter.apply(pOptions);
    }

    public Component getMessage(Options pOptions) {
        return this.toString.apply(pOptions, this);
    }
}

