/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons;

import by.dragonsurvivalteam.dragonsurvival.client.gui.DragonAltarGUI;
import by.dragonsurvivalteam.dragonsurvival.client.gui.dragon_editor.DragonEditorScreen;
import by.dragonsurvivalteam.dragonsurvival.client.handlers.ClientEvents;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonFoodHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.RequestClientData;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncSpinStatus;
import by.dragonsurvivalteam.dragonsurvival.network.player.SynchronizeDragonCap;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncAltarCooldown;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class AltarTypeButton
extends Button {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("dragonsurvival", "textures/gui/dragon_altar_icons.png");
    private final DragonAltarGUI gui;
    public AbstractDragonType type;

    public AltarTypeButton(DragonAltarGUI gui, AbstractDragonType type, int x, int y) {
        super(x, y, 49, 147, (Component)Component.m_237119_(), Button::m_5691_, f_252438_);
        this.gui = gui;
        this.type = type;
    }

    private List<Component> altarDragonInfoLocalized(String dragonType, List<Item> foodList) {
        String foodInfo = "";
        if (Screen.m_96638_()) {
            if (!Objects.equals(dragonType, "human")) {
                StringBuilder food = new StringBuilder();
                for (Item item : foodList) {
                    food.append(item.m_7626_(new ItemStack((ItemLike)item)).getString()).append("; ");
                }
                foodInfo = food.toString();
            }
        } else {
            foodInfo = I18n.m_118938_((String)"ds.hold_shift.for_food", (Object[])new Object[0]);
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        for (String string : I18n.m_118938_((String)("ds.altar_dragon_info." + dragonType), (Object[])new Object[0]).split("\n")) {
            if (string.equals("{0}")) {
                string = foodInfo;
            }
            tooltips.add((Component)Component.m_237113_((String)string));
        }
        return tooltips;
    }

    public void m_5691_() {
        this.initiateDragonForm(this.type);
    }

    protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean atTheTopOrBottom;
        boolean bl = atTheTopOrBottom = mouseY > this.m_252907_() + 6 && mouseY < this.m_252907_() + 26 || mouseY > this.m_252907_() + 133 && mouseY < this.m_252907_() + 153;
        if (this.m_274382_() && atTheTopOrBottom) {
            guiGraphics.m_280666_(Minecraft.m_91087_().f_91062_, this.altarDragonInfoLocalized((String)(this.type == null ? "human" : this.type.getTypeNameLowerCase() + "_dragon"), this.type == null ? Collections.emptyList() : DragonFoodHandler.getEdibleFoods(this.type)), mouseX, mouseY);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        int uOffset = 3;
        if (DragonUtils.isDragonType(this.type, (AbstractDragonType)DragonTypes.CAVE)) {
            uOffset = 0;
        } else if (DragonUtils.isDragonType(this.type, (AbstractDragonType)DragonTypes.FOREST)) {
            uOffset = 1;
        } else if (DragonUtils.isDragonType(this.type, (AbstractDragonType)DragonTypes.SEA)) {
            uOffset = 2;
        }
        guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, new Color(0.5f, 0.5f, 0.5f).getRGB());
        guiGraphics.m_280163_(BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_(), (float)(uOffset * 49), this.f_93622_ ? 0.0f : 147.0f, 49, 147, 512, 512);
    }

    private void initiateDragonForm(AbstractDragonType type) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (type == null) {
            Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237115_((String)"ds.choice_human"));
            DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
                player.m_9236_().m_5594_((Player)player, player.m_20183_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 0.7f);
                if (ServerConfig.saveGrowthStage.booleanValue()) {
                    cap.setSavedDragonSize(cap.getTypeName(), cap.getSize());
                }
                cap.setType(null);
                cap.setBody(null, (Player)player);
                cap.setSize(20.0, (Player)player);
                cap.setIsHiding(false);
                if (!ServerConfig.saveAllAbilities.booleanValue()) {
                    cap.getMovementData().spinLearned = false;
                    cap.setHasFlight(false);
                }
                NetworkHandler.CHANNEL.sendToServer((Object)new SyncAltarCooldown(Minecraft.m_91087_().f_91074_.m_19879_(), Functions.secondsToTicks(ServerConfig.altarUsageCooldown)));
                NetworkHandler.CHANNEL.sendToServer((Object)new SynchronizeDragonCap(player.m_19879_(), cap.isHiding(), cap.getType(), cap.getBody(), cap.getSize(), cap.hasFlight(), 0));
                NetworkHandler.CHANNEL.sendToServer((Object)new SyncSpinStatus(Minecraft.m_91087_().f_91074_.m_19879_(), cap.getMovementData().spinAttack, cap.getMovementData().spinCooldown, cap.getMovementData().spinLearned));
                ClientEvents.sendClientData(new RequestClientData(cap.getType(), cap.getBody(), cap.getLevel()));
            });
            player.m_6915_();
        } else {
            Minecraft.m_91087_().m_91152_((Screen)new DragonEditorScreen(this.gui, type));
        }
    }
}

