/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.dropdown;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvivalMod;
import by.dragonsurvivalteam.dragonsurvival.client.gui.settings.widgets.ResourceTextFieldOption;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.dropdown.DropdownList;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.dropdown.ResourceDropdownEntry;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.dropdown.ResourceEntry;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.lists.OptionsList;
import by.dragonsurvivalteam.dragonsurvival.config.ConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigType;
import com.google.common.primitives.Primitives;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ResourceTextField
extends EditBox {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("dragonsurvival", "textures/gui/textbox.png");
    private static final int maxItems = 6;
    private final List<ResourceEntry> suggestions = new ArrayList<ResourceEntry>();
    private final ResourceTextFieldOption textField;
    protected DropdownList list;
    private ResourceEntry stack;
    private final String optionKey;
    private final boolean isItem;
    private final boolean isBlock;
    private final boolean isEntity;
    private final boolean isEffect;
    private final boolean isBiome;
    private final boolean configValueIsList;

    public ResourceTextField(String optionKey, ResourceTextFieldOption textField, int x, int y, int width, int height, Component component) {
        super(Minecraft.m_91087_().f_91062_, x, y, width, height, component);
        this.m_94182_(false);
        this.textField = textField;
        this.optionKey = optionKey;
        Field field = ConfigHandler.configFields.get(optionKey);
        Class checkType = Primitives.unwrap(field.getType());
        if (field.isAnnotationPresent(ConfigType.class)) {
            ConfigType type = field.getAnnotation(ConfigType.class);
            checkType = Primitives.unwrap(type.value());
        }
        this.isItem = Item.class.isAssignableFrom(checkType);
        this.isBlock = Block.class.isAssignableFrom(checkType);
        this.isEntity = EntityType.class.isAssignableFrom(checkType);
        this.isEffect = MobEffect.class.isAssignableFrom(checkType);
        this.isBiome = Biome.class.isAssignableFrom(checkType);
        this.configValueIsList = field.getType().isAssignableFrom(List.class);
        this.list = new DropdownList(this.m_252754_(), this.m_252907_() + this.f_93619_, this.f_93618_, 0, 23);
        Minecraft.m_91087_().f_91080_.f_96540_.add(this.list);
        this.update();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.shouldBeHidden()) {
            return;
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (!(!this.m_93696_() && this.list == null || this.f_93624_ && (this.m_5953_(mouseX, mouseY) || this.list.m_5953_(mouseX, mouseY)))) {
            this.m_93692_(false);
        }
        if (this.m_93696_() && this.list != null) {
            this.list.reposition(this.m_252754_(), this.m_252907_() + this.f_93619_, this.f_93618_, Math.min(this.suggestions.size() + 1, 6) * this.f_93619_);
        }
        if (this.list != null && this.list.visible) {
            this.list.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean m_142518_() {
        if (this.shouldBeHidden()) {
            return false;
        }
        return super.m_142518_();
    }

    public void update() {
        String resource;
        this.stack = null;
        this.suggestions.clear();
        if (this.list != null) {
            this.list.m_6702_().clear();
        }
        String string = resource = this.m_94155_().isEmpty() && this.textField != null ? this.textField.getter.apply(Minecraft.m_91087_().f_91066_) : this.m_94155_();
        while (StringUtils.countMatches((CharSequence)resource, (CharSequence)":") > 1) {
            resource = resource.substring(0, resource.lastIndexOf(":"));
        }
        List<ResourceEntry> resourceEntries = this.parseCombinedList(Collections.singletonList(resource), true);
        for (ResourceEntry resourceEntry : resourceEntries) {
            if (!resourceEntry.displayItems.isEmpty()) {
                this.stack = resourceEntry;
                break;
            }
            if (resourceEntries.indexOf(resourceEntry) != resourceEntries.size() - 1) continue;
            this.stack = resourceEntry;
        }
        if (!this.m_93696_()) {
            return;
        }
        this.fillSuggestions(resource);
        if (this.suggestions.isEmpty() && !resource.isEmpty()) {
            this.fillSuggestions("");
        }
        this.suggestions.removeIf(entry -> entry.id.isEmpty());
        this.suggestions.removeIf(ResourceEntry::isEmpty);
        this.suggestions.sort((entryOne, entryTwo) -> entryTwo.mod.compareTo(entryOne.mod));
        this.suggestions.sort(Comparator.comparing(c -> c.id));
        for (int i = 0; i < this.suggestions.size(); ++i) {
            ResourceEntry entry2 = this.suggestions.get(i);
            if (this.list == null) continue;
            this.list.addEntry(new ResourceDropdownEntry(this, i, entry2, val -> {
                this.m_94144_(val.id);
                this.m_93692_(false);
                this.update();
            }));
        }
    }

    private void fillSuggestions(String resource) {
        SuggestionsBuilder builder = new SuggestionsBuilder(resource, 0);
        if (this.isItem) {
            SharedSuggestionProvider.m_82926_((Iterable)ForgeRegistries.ITEMS.getKeys(), (SuggestionsBuilder)builder);
        }
        if (this.isBlock) {
            SharedSuggestionProvider.m_82926_((Iterable)ForgeRegistries.BLOCKS.getKeys(), (SuggestionsBuilder)builder);
        }
        if (this.isEntity) {
            SharedSuggestionProvider.m_82926_((Iterable)ForgeRegistries.ENTITY_TYPES.getKeys(), (SuggestionsBuilder)builder);
        }
        if (this.isEffect) {
            SharedSuggestionProvider.m_82926_((Iterable)ForgeRegistries.MOB_EFFECTS.getKeys(), (SuggestionsBuilder)builder);
        }
        if (this.isBiome) {
            SharedSuggestionProvider.m_82926_((Iterable)ForgeRegistries.BIOMES.getKeys(), (SuggestionsBuilder)builder);
        }
        Suggestions sgs = builder.build();
        ArrayList<String> suggestions = new ArrayList<String>(sgs.getList().stream().map(Suggestion::getText).toList());
        suggestions.removeIf(string -> string == null || string.isEmpty());
        suggestions.forEach(string -> this.suggestions.addAll(this.parseCombinedList(Collections.singletonList(string), true)));
    }

    public List<ResourceEntry> parseCombinedList(List<String> values, boolean isTag) {
        ArrayList<ResourceEntry> results = new ArrayList<ResourceEntry>();
        for (String value : values) {
            LocalPlayer localPlayer;
            ResourceLocation location;
            if (value.isEmpty() || StringUtils.countMatches((CharSequence)value, (CharSequence)":") == 0 || (location = ResourceLocation.m_135820_((String)value)) == null) continue;
            if (isTag) {
                if (this.isItem) {
                    try {
                        results.add(new ResourceEntry(value, Objects.requireNonNull(ForgeRegistries.ITEMS.tags().getTag(TagKey.m_203882_((ResourceKey)ForgeRegistries.Keys.ITEMS, (ResourceLocation)location)).stream().map(ItemStack::new).toList()), true));
                    }
                    catch (Exception e) {
                        DragonSurvivalMod.LOGGER.debug("Error while trying to retrieve a value from the 'ITEMS' registry for the config, value: [" + value + "]", (Throwable)e);
                    }
                }
                if (this.isBlock) {
                    try {
                        results.add(new ResourceEntry(value, Objects.requireNonNull(ForgeRegistries.BLOCKS.tags().getTag(TagKey.m_203882_((ResourceKey)ForgeRegistries.Keys.BLOCKS, (ResourceLocation)location))).stream().map(ItemStack::new).toList(), true));
                    }
                    catch (Exception e) {
                        DragonSurvivalMod.LOGGER.debug("Error while trying to retrieve a value from the 'BLOCKS' registry for the config, value: [" + value + "]", (Throwable)e);
                    }
                }
                if (this.isEntity) {
                    try {
                        results.add(new ResourceEntry(value, Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.tags().getTag(TagKey.m_203882_((ResourceKey)ForgeRegistries.Keys.ENTITY_TYPES, (ResourceLocation)location))).stream().map(type -> new ItemStack((ItemLike)ForgeSpawnEggItem.fromEntityType((EntityType)type))).toList(), true));
                    }
                    catch (Exception e) {
                        DragonSurvivalMod.LOGGER.debug("Error while trying to retrieve a value from the 'ENTITY_TYPES' registry for the config, value: [" + value + "]", (Throwable)e);
                    }
                }
            }
            if ((localPlayer = Minecraft.m_91087_().f_91074_) != null) {
                Optional optionalLookup;
                RegistryAccess registryAccess = localPlayer.m_9236_().m_9598_();
                if (this.isItem) {
                    optionalLookup = registryAccess.m_254861_(ForgeRegistries.Keys.ITEMS);
                    optionalLookup.ifPresent(lookup -> {
                        try {
                            results.add(new ResourceEntry(value, Collections.singletonList(new ItemStack(ItemParser.m_235305_((HolderLookup)lookup, (StringReader)new StringReader(value)).f_235328_()))));
                        }
                        catch (CommandSyntaxException commandSyntaxException) {
                            // empty catch block
                        }
                    });
                }
                if (this.isBlock) {
                    optionalLookup = registryAccess.m_254861_(ForgeRegistries.Keys.BLOCKS);
                    optionalLookup.ifPresent(lookup -> {
                        try {
                            results.add(new ResourceEntry(value, Collections.singletonList(new ItemStack((ItemLike)BlockStateParser.m_234691_((HolderLookup)lookup, (StringReader)new StringReader(value), (boolean)false).f_234748_().m_60734_()))));
                        }
                        catch (CommandSyntaxException commandSyntaxException) {
                            // empty catch block
                        }
                    });
                }
                if (this.isEntity) {
                    optionalLookup = registryAccess.m_254861_(ForgeRegistries.Keys.ITEMS);
                    optionalLookup.ifPresent(lookup -> {
                        try {
                            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location);
                            if (entityType != null) {
                                SpawnEggItem item = ForgeSpawnEggItem.fromEntityType((EntityType)entityType);
                                if (item != null) {
                                    results.add(new ResourceEntry(value, Collections.singletonList(new ItemStack((ItemLike)item))));
                                } else {
                                    results.add(new ResourceEntry(value, Collections.singletonList(new ItemStack(ItemParser.m_235305_((HolderLookup)lookup, (StringReader)new StringReader(value)).f_235328_()))));
                                }
                            }
                        }
                        catch (CommandSyntaxException commandSyntaxException) {
                            // empty catch block
                        }
                    });
                }
            }
            if (!this.isEffect) continue;
            try {
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(location);
                MobEffectInstance instance = new MobEffectInstance(effect, 20);
                ItemStack stack = new ItemStack((ItemLike)Items.f_42589_);
                PotionUtils.m_43549_((ItemStack)stack, (Potion)Potions.f_43599_);
                PotionUtils.m_43552_((ItemStack)stack, Collections.singletonList(instance));
                results.add(new ResourceEntry(value, Collections.singletonList(stack)));
            }
            catch (Exception e) {
                DragonSurvivalMod.LOGGER.debug("Error while trying to retrieve a value from the 'MOB_EFFECTS' registry for the config, value: [" + value + "]", (Throwable)e);
            }
        }
        results.forEach(entry -> {
            if (entry.displayItems != null && !entry.displayItems.isEmpty()) {
                entry.displayItems = entry.displayItems.stream().filter(c -> {
                    boolean blockItem = c.m_41720_() instanceof BlockItem;
                    boolean itemNameBlockItem = c.m_41720_() instanceof ItemNameBlockItem;
                    return !this.isItem ? !itemNameBlockItem : this.isBlock || itemNameBlockItem || !blockItem;
                }).toList();
                entry.displayItems = entry.displayItems.stream().filter(itemStack -> !itemStack.m_41619_()).toList();
            }
        });
        return results;
    }

    public void m_94180_(int pNum) {
        super.m_94180_(pNum);
        this.update();
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        boolean val = super.m_5534_(pCodePoint, pModifiers);
        this.update();
        return val;
    }

    public void m_93692_(boolean focus) {
        if (this.shouldBeHidden()) {
            return;
        }
        super.m_93692_(focus);
        boolean bl = this.list.visible = focus && Minecraft.m_91087_().f_91080_ != null && !Minecraft.m_91087_().f_91080_.f_96540_.isEmpty() && this.configValueIsList;
        if (Minecraft.m_91087_().f_91080_ == null) {
            DragonSurvivalMod.LOGGER.warn("Screen was not available while trying to focus 'ResourceTextField' [" + this.optionKey + "]");
            return;
        }
        Minecraft.m_91087_().f_91080_.f_96540_.forEach(widget -> {
            DropdownList dropdownList;
            if (widget instanceof DropdownList && (dropdownList = (DropdownList)((Object)widget)) != this.list && this.list.visible && dropdownList.visible) {
                dropdownList.visible = false;
            }
        });
    }

    private boolean shouldBeHidden() {
        AtomicBoolean shouldBeHidden = new AtomicBoolean(false);
        Minecraft.m_91087_().f_91080_.f_96540_.forEach(widget -> {
            if (widget instanceof OptionsList) {
                OptionsList optionsList = (OptionsList)((Object)widget);
                optionsList.m_6702_().forEach(listEntry -> {
                    ResourceTextField resourceTextField;
                    GuiEventListener entry;
                    if (!listEntry.m_6702_().isEmpty() && (entry = (GuiEventListener)listEntry.m_6702_().get(0)) instanceof ResourceTextField && (resourceTextField = (ResourceTextField)entry) != this && resourceTextField.list.visible && !resourceTextField.list.m_6702_().isEmpty() && this.m_252907_() > resourceTextField.list.getTop() - 23 && this.m_252907_() < resourceTextField.list.getBottom() + 3) {
                        shouldBeHidden.set(true);
                    }
                });
            }
        });
        return shouldBeHidden.get();
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.shouldBeHidden()) {
            return;
        }
        int v = this.f_93622_ ? 32 : 0;
        guiGraphics.blitWithBorder(BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_() + 1, 0, v, this.f_93618_, this.f_93619_, 32, 32, 10, 10, 10, 10);
        if (this.stack != null && !this.stack.isEmpty()) {
            this.stack.tick();
            guiGraphics.m_280480_(this.stack.getDisplayItem(), this.m_252754_() + 3, this.m_252907_() + 3);
        }
        this.m_252865_(this.m_252754_() + 25);
        this.m_253211_(this.m_252907_() + 6);
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_94202_(0xE0E0E0);
        if (this.m_94155_().isEmpty() && !this.m_6035_().toString().isBlank()) {
            boolean isFocus = this.m_93696_();
            this.m_93692_(false);
            int cursor = this.m_94207_();
            this.m_94196_(0);
            this.m_94202_(0x707070);
            this.m_94144_(this.m_6035_().getString());
            super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
            this.m_94144_("");
            this.m_94202_(0xE0E0E0);
            this.m_94196_(cursor);
            this.m_93692_(isFocus);
        }
        this.m_252865_(this.m_252754_() - 25);
        this.m_253211_(this.m_252907_() - 6);
    }
}

