/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic;

import by.dragonsurvivalteam.dragonsurvival.client.util.RenderingUtils;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class ColorPickerButton
extends ExtendedButton {
    public Color defaultColor;
    public Consumer<Color> colorConsumer;
    double selectorX;
    double selectorY;

    public ColorPickerButton(int xPos, int yPos, int width, int height, Color defaultColor, Consumer<Color> colorConsumer) {
        super(xPos, yPos, width, height, (Component)Component.m_237119_(), null);
        this.defaultColor = defaultColor;
        this.colorConsumer = colorConsumer;
        float[] hsb = Color.RGBtoHSB(defaultColor.getRed(), defaultColor.getGreen(), defaultColor.getBlue(), null);
        this.selectorX = hsb[0] * (float)width;
        this.selectorY = hsb[2] < 1.0f ? hsb[2] * ((float)height / 2.0f) : (float)height / 2.0f + (1.0f - hsb[1]) * ((float)height / 2.0f);
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        RenderingUtils.renderColorSquare(guiGraphics, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
        RenderingUtils.fill(guiGraphics, (double)this.m_252754_() + this.selectorX - 2.0, (double)this.m_252907_() + this.selectorY - 2.0, (double)this.m_252754_() + this.selectorX + 2.0, (double)this.m_252907_() + this.selectorY + 2.0, Color.black.getRGB());
        RenderingUtils.fill(guiGraphics, (double)this.m_252754_() + this.selectorX - 1.0, (double)this.m_252907_() + this.selectorY - 1.0, (double)this.m_252754_() + this.selectorX + 1.0, (double)this.m_252907_() + this.selectorY + 1.0, this.getColor().getRGB());
    }

    public Color getColor() {
        double hue = this.selectorX / (double)this.f_93618_ * 360.0 / 360.0;
        if (this.selectorY > (double)((float)this.f_93619_ / 2.0f)) {
            double saturation = 1.0 - (this.selectorY - (double)((float)this.f_93619_ / 2.0f)) / (double)((float)this.f_93619_ / 2.0f) * 360.0 / 360.0;
            return Color.getHSBColor((float)hue, (float)saturation, 1.0f);
        }
        double brightness = this.selectorY / (double)((float)this.f_93619_ / 2.0f) * 360.0 / 360.0;
        return Color.getHSBColor((float)hue, 1.0f, (float)brightness);
    }

    public void m_5716_(double pMouseX, double pMouseY) {
        this.selectorX = Mth.m_14008_((double)(pMouseX - (double)this.m_252754_()), (double)0.0, (double)this.f_93618_);
        this.selectorY = Mth.m_14008_((double)(pMouseY - (double)this.m_252907_()), (double)0.0, (double)this.f_93619_);
        this.colorConsumer.accept(this.getColor());
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.selectorX = Mth.m_14008_((double)(pMouseX - (double)this.m_252754_()), (double)0.0, (double)this.f_93618_);
        this.selectorY = Mth.m_14008_((double)(pMouseY - (double)this.m_252907_()), (double)0.0, (double)this.f_93619_);
        this.colorConsumer.accept(this.getColor());
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void m_7435_(SoundManager pHandler) {
    }
}

