/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic;

import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class HelpButton
extends ExtendedButton {
    public static final ResourceLocation texture = new ResourceLocation("dragonsurvival", "textures/gui/help_button.png");
    public String text;
    private final List<Component> tooltip;
    public int variation;
    public AbstractDragonType type;

    public HelpButton(int x, int y, int sizeX, int sizeY, String text, int variation) {
        this(DragonUtils.getDragonType((Entity)Minecraft.m_91087_().f_91074_), x, y, sizeX, sizeY, text, variation);
    }

    public HelpButton(AbstractDragonType type, int x, int y, int sizeX, int sizeY, String text, int variation) {
        super(x, y, sizeX, sizeY, (Component)Component.m_237119_(), s -> {});
        this.text = text;
        this.variation = variation;
        this.type = type;
        this.tooltip = new ArrayList<Component>();
        if (text != null && !text.isBlank()) {
            for (String string : I18n.m_118938_((String)text, (Object[])new Object[0]).split("\n")) {
                this.tooltip.add((Component)Component.m_237113_((String)string));
            }
        }
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        float size = this.variation == 0 ? 18.0f : 22.0f;
        float xSize = (float)(this.f_93618_ + (this.variation == 0 ? 0 : 2)) / size;
        float ySize = (float)(this.f_93619_ + (this.variation == 0 ? 0 : 2)) / size;
        int offset = 0;
        if (this.m_198029_()) {
            int id;
            if (this.type == null) {
                id = 4;
            } else {
                id = switch (this.type.getTypeName()) {
                    case "cave" -> 1;
                    case "forest" -> 2;
                    case "sea" -> 3;
                    default -> 0;
                };
            }
            offset += (int)((float)id * size);
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.m_252754_() - (float)this.m_252754_() * xSize, (float)this.m_252907_() - (float)this.m_252907_() * ySize, 0.0f);
        guiGraphics.m_280168_().m_85841_(xSize, ySize, 0.0f);
        if (this.variation == 0) {
            guiGraphics.m_280163_(texture, this.m_252754_(), this.m_252907_(), 0.0f, (float)offset, 18, 18, 256, 256);
        } else {
            guiGraphics.m_280163_(texture, this.m_252754_() - 1, this.m_252907_() - 1, 18.0f, (float)offset, 22, 22, 256, 256);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280666_(Minecraft.m_91087_().f_91062_, this.tooltip, mouseX, mouseY);
    }

    public boolean m_6375_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        return false;
    }
}

