/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.lists;

import by.dragonsurvivalteam.dragonsurvival.client.gui.settings.widgets.Option;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.lists.CategoryEntry;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.lists.OptionEntry;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.lists.OptionListEntry;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class OptionsList
extends ContainerObjectSelectionList<OptionListEntry> {
    public static ConcurrentHashMap<Option, String> configMap = new ConcurrentHashMap();
    public static CopyOnWriteArrayList<Integer> activeCats = new CopyOnWriteArrayList();
    public int listWidth;

    public OptionsList(int listWidth, int height, int top, int bottom) {
        Minecraft minecraft = Minecraft.m_91087_();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        super(minecraft, listWidth, height, top, bottom, 9 * 2 + 8);
        this.listWidth = listWidth;
        this.m_93488_(false);
    }

    public CategoryEntry addCategory(String p_214333_1_, CategoryEntry ent, int catNum) {
        String name = p_214333_1_.substring(0, 1).toUpperCase(Locale.ROOT) + p_214333_1_.substring(1).replace("_", " ");
        CategoryEntry entry = new CategoryEntry(this, (Component)Component.m_237119_().m_130946_(name), ent, catNum);
        entry.origName = p_214333_1_;
        this.addEntry(entry);
        return entry;
    }

    public int addEntry(OptionListEntry p_230513_1_) {
        return super.m_7085_((AbstractSelectionList.Entry)p_230513_1_);
    }

    protected int m_5775_() {
        int size = this.f_93395_;
        for (OptionListEntry ent : this.m_6702_()) {
            size += ent.getHeight();
        }
        return size;
    }

    public void centerScrollOn(OptionListEntry p_230951_1_) {
        int num = this.m_6702_().indexOf((Object)p_230951_1_);
        int size = 0;
        for (int i = 0; i < num; ++i) {
            size += ((OptionListEntry)this.m_93500_(i)).getHeight();
        }
        this.m_93410_(size + p_230951_1_.getHeight() / 2 - (this.f_93391_ - this.f_93390_) / 2);
    }

    protected void ensureVisible(OptionListEntry p_230954_1_) {
        int k;
        int i = this.m_7610_(this.m_6702_().indexOf((Object)p_230954_1_));
        int j = i - this.f_93390_ - 4 - p_230954_1_.getHeight();
        if (j < 0) {
            this.m_93429_(j);
        }
        if ((k = this.f_93391_ - i - p_230954_1_.getHeight() - p_230954_1_.getHeight()) < 0) {
            this.m_93429_(-k);
        }
    }

    public void m_93429_(int p_230937_1_) {
        this.m_93410_(this.m_93517_() + (double)p_230937_1_);
    }

    protected int m_7610_(int index) {
        int height = 0;
        for (int i = 0; i < index; ++i) {
            OptionListEntry e = (OptionListEntry)this.m_93500_(i);
            height += e.getHeight();
        }
        return this.f_93390_ + 4 - (int)this.m_93517_() + height - 4;
    }

    public boolean removeEntry(OptionListEntry p_230956_1_) {
        return super.m_93502_((AbstractSelectionList.Entry)p_230956_1_);
    }

    public void add(Option[] options, CategoryEntry entry) {
        for (Option option : options) {
            this.add(option, entry);
        }
    }

    public void add(Option option, CategoryEntry entry) {
        AbstractWidget widget = option.createButton(this.f_93386_.f_91066_, this.m_5756_() - 165, 0, 140);
        this.addEntry(new OptionEntry((Map<Option, AbstractWidget>)ImmutableMap.of((Object)option, (Object)widget), option, option.getCaption(), widget, entry));
    }

    public int m_5756_() {
        return Minecraft.m_91087_().f_91080_.f_96543_ - 32;
    }

    public boolean m_6375_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        this.m_93481_(p_231044_1_, p_231044_3_, p_231044_5_);
        if (!this.m_5953_(p_231044_1_, p_231044_3_)) {
            return false;
        }
        OptionListEntry e = this.getEntryAtPos(p_231044_1_, p_231044_3_);
        if (e != null) {
            if (e.m_6375_(p_231044_1_, p_231044_3_, p_231044_5_)) {
                this.m_7522_((GuiEventListener)e);
                this.m_7897_(true);
                return true;
            }
        } else if (p_231044_5_ == 0) {
            this.m_6205_((int)(p_231044_1_ - (double)(this.f_93393_ + this.f_93388_ / 2 - this.m_5759_() / 2)), (int)(p_231044_3_ - (double)this.f_93390_) + (int)this.m_93517_() - 4);
            return true;
        }
        return this.f_93399_;
    }

    public OptionListEntry getEntryAtPos(double p_230933_1_, double p_230933_3_) {
        int i = this.m_5759_() / 2;
        int j = this.f_93393_ + this.f_93388_ / 2;
        int k = j - i;
        int l = j + i;
        int i1 = Mth.m_14107_((double)(p_230933_3_ - (double)this.f_93390_)) - this.f_93395_ + (int)this.m_93517_() - 4;
        int curSize = 0;
        int j1 = 0;
        for (int g = 0; g < this.m_6702_().size(); ++g) {
            if ((curSize += ((OptionListEntry)this.m_93500_(g)).getHeight()) < i1) continue;
            j1 = g;
            break;
        }
        return p_230933_1_ < (double)this.m_5756_() && p_230933_1_ >= (double)k && p_230933_1_ <= (double)l && j1 >= 0 && i1 >= 0 && j1 < this.m_5773_() ? (OptionListEntry)((Object)this.m_6702_().get(j1)) : null;
    }

    public int m_5759_() {
        return this.listWidth;
    }

    protected void m_239227_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float partialTicks) {
        int itemCount = this.m_5773_();
        for (int index = 0; index < itemCount; ++index) {
            int top = this.m_7610_(index);
            int bottom = this.m_93485_(index);
            OptionListEntry entry = (OptionListEntry)this.m_93500_(index);
            boolean bl = entry.visible = bottom >= this.f_93390_ + 16 && top <= this.f_93391_ - 16;
            if (bottom < this.f_93390_ || top > this.f_93391_) continue;
            int entryHeight = entry.getHeight();
            int rowWidth = this.m_5759_();
            int rowLeft = this.m_5747_();
            boolean mouseOver = this.m_5953_(pMouseX, pMouseY) && Objects.equals((Object)this.getEntryAtPos(pMouseX, pMouseY), (Object)entry);
            entry.m_6311_(guiGraphics, index, top, rowLeft, rowWidth, entryHeight, pMouseX, pMouseY, mouseOver, partialTicks);
        }
    }

    public int m_93485_(int index) {
        return this.m_7610_(index) + ((OptionListEntry)this.m_93500_(index)).getHeight();
    }

    @Nullable
    public CategoryEntry findCategory(String text, String lastKey) {
        for (OptionListEntry optionsrowlist$row : this.m_6702_()) {
            if (!(optionsrowlist$row instanceof CategoryEntry)) continue;
            CategoryEntry cat = (CategoryEntry)optionsrowlist$row;
            if (cat.parent != null && !cat.parent.origName.equals(lastKey) || !cat.origName.equals(text)) continue;
            return cat;
        }
        return null;
    }

    public OptionEntry findClosest(String text) {
        OptionEntry closest = null;
        int dif = -1;
        for (OptionListEntry row : this.m_6702_()) {
            if (!(row instanceof OptionEntry)) continue;
            OptionEntry ent = (OptionEntry)row;
            String difText = StringUtils.difference((String)ent.key.getString().toLowerCase(Locale.ROOT).replace(" ", ""), (String)text.toLowerCase(Locale.ROOT).replace(" ", ""));
            if (difText.length() >= ent.key.getString().length() || dif != -1 && difText.length() >= dif) continue;
            closest = ent;
            dif = difText.length();
        }
        return closest;
    }

    @Nullable
    public AbstractWidget findOption(Option pOption) {
        for (OptionListEntry optionslist$entry : this.m_6702_()) {
            AbstractWidget abstractwidget;
            if (!(optionslist$entry instanceof OptionEntry) || (abstractwidget = ((OptionEntry)optionslist$entry).options.get(pOption)) == null) continue;
            return abstractwidget;
        }
        return null;
    }

    public Optional<AbstractWidget> getMouseOver(double p_238518_1_, double p_238518_3_) {
        for (OptionListEntry optionsrowlist$row : this.m_6702_()) {
            for (AbstractWidget widget : optionsrowlist$row.children) {
                if (!widget.m_5953_(p_238518_1_, p_238518_3_)) continue;
                return Optional.of(widget);
            }
        }
        return Optional.empty();
    }
}

