/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.handlers;

import by.dragonsurvivalteam.dragonsurvival.client.gui.DragonScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.TabButton;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRender;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.DragonEditorRegistry;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.SkinPreset;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.types.CaveDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.types.ForestDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.types.SeaDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonSizeHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.magic.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.CaveDragon.passive.ContrastShowerAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.ForestDragon.passive.LightInDarknessAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.SeaDragon.passive.WaterAbility;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.RequestClientData;
import by.dragonsurvivalteam.dragonsurvival.network.claw.SyncDragonClawRender;
import by.dragonsurvivalteam.dragonsurvival.network.container.OpenDragonInventory;
import by.dragonsurvivalteam.dragonsurvival.network.dragon_editor.SyncDragonSkinSettings;
import by.dragonsurvivalteam.dragonsurvival.network.dragon_editor.SyncPlayerSkinPreset;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    public static final ResourceLocation DRAGON_HUD = new ResourceLocation("dragonsurvival:textures/gui/dragon_hud.png");
    public static ConcurrentHashMap<Integer, Integer> dragonsJumpingTicks = new ConcurrentHashMap(20);
    public static double mouseX = -1.0;
    public static double mouseY = -1.0;
    @ConfigOption(side=ConfigSide.CLIENT, category={"inventory"}, key="dragonInventory", comment={"Should the default inventory be replaced as a dragon?"})
    public static Boolean dragonInventory = true;
    @ConfigOption(side=ConfigSide.CLIENT, category={"inventory"}, key="dragonTabs", comment={"Should dragon tabs be added to the default player inventory?"})
    public static Boolean dragonTabs = true;
    @ConfigOption(side=ConfigSide.CLIENT, category={"inventory"}, key="inventoryToggle", comment={"Should the buttons for toggeling between dragon and normaly inventory be added?"})
    public static Boolean inventoryToggle = true;
    private static ItemStack BOLAS;

    @SubscribeEvent
    public static void decreaseJumpDuration(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.phase == TickEvent.Phase.END) {
            Player player = playerTickEvent.player;
            dragonsJumpingTicks.computeIfPresent(player.m_19879_(), (playerEntity1, integer) -> integer > 0 ? integer - 1 : integer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendClientData(RequestClientData message) {
        if (message.type == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            NetworkHandler.CHANNEL.sendToServer((Object)new SyncDragonClawRender(player.m_19879_(), ClientDragonRender.renderDragonClaws));
            NetworkHandler.CHANNEL.sendToServer((Object)new SyncDragonSkinSettings(player.m_19879_(), ClientDragonRender.renderNewbornSkin, ClientDragonRender.renderYoungSkin, ClientDragonRender.renderAdultSkin));
            DragonStateProvider.getCap((Entity)player).ifPresent(arg_0 -> ClientEvents.lambda$sendClientData$1(message, (Player)player, arg_0));
        }
    }

    @SubscribeEvent
    public static void onOpenScreen(ScreenEvent.Opening openEvent) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!dragonInventory.booleanValue()) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        if (player == null || player.m_7500_() || !DragonUtils.isDragon((Entity)player)) {
            return;
        }
        if (openEvent.getScreen() instanceof InventoryScreen) {
            openEvent.setCanceled(true);
            NetworkHandler.CHANNEL.sendToServer((Object)new OpenDragonInventory());
        }
    }

    @SubscribeEvent
    public static void addCraftingButton(ScreenEvent.Init.Post initGuiEvent) {
        InventoryScreen screen;
        Screen sc = initGuiEvent.getScreen();
        if (!DragonUtils.isDragon((Entity)Minecraft.m_91087_().f_91074_)) {
            return;
        }
        if (sc instanceof InventoryScreen) {
            screen = (InventoryScreen)sc;
            if (dragonTabs.booleanValue()) {
                initGuiEvent.addListener((GuiEventListener)new TabButton(screen.getGuiLeft(), screen.getGuiTop() - 28, TabButton.TabType.INVENTORY, (Screen)screen));
                initGuiEvent.addListener((GuiEventListener)new TabButton(screen.getGuiLeft() + 28, screen.getGuiTop() - 26, TabButton.TabType.ABILITY, (Screen)screen));
                initGuiEvent.addListener((GuiEventListener)new TabButton(screen.getGuiLeft() + 57, screen.getGuiTop() - 26, TabButton.TabType.GITHUB_REMINDER, (Screen)screen));
                initGuiEvent.addListener((GuiEventListener)new TabButton(screen.getGuiLeft() + 86, screen.getGuiTop() - 26, TabButton.TabType.SKINS, (Screen)screen));
            }
            if (inventoryToggle.booleanValue()) {
                initGuiEvent.addListener((GuiEventListener)new ImageButton(screen.getGuiLeft() + 128, screen.f_96544_ / 2 - 22, 20, 18, 20, 0, 19, DragonScreen.INVENTORY_TOGGLE_BUTTON, p_onPress_1_ -> OpenDragonInventory.SendOpenDragonInventoryAndMaintainCursorPosition()){

                    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
                        if (this.m_198029_()) {
                            ArrayList<MutableComponent> description = new ArrayList<MutableComponent>(List.of(Component.m_237115_((String)"ds.gui.toggle_inventory.dragon")));
                            guiGraphics.m_280666_(Minecraft.m_91087_().f_91062_, description, mouseX, mouseY);
                        }
                    }
                });
            }
        }
        if (sc instanceof CreativeModeInventoryScreen) {
            screen = (CreativeModeInventoryScreen)sc;
            if (inventoryToggle.booleanValue()) {
                initGuiEvent.addListener((GuiEventListener)new ImageButton(screen.getGuiLeft() + 128 + 20, screen.f_96544_ / 2 - 50, 20, 18, 20, 0, 19, DragonScreen.INVENTORY_TOGGLE_BUTTON, p_onPress_1_ -> OpenDragonInventory.SendOpenDragonInventoryAndMaintainCursorPosition(), (CreativeModeInventoryScreen)screen){
                    final /* synthetic */ CreativeModeInventoryScreen val$screen;
                    {
                        this.val$screen = creativeModeInventoryScreen;
                        super(pX, pY, pWidth, pHeight, pXTexStart, pYTexStart, pYDiffTex, pResourceLocation, pOnPress);
                    }

                    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                        this.f_93623_ = this.f_93624_ = this.val$screen.m_258017_();
                        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                    }

                    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTick) {
                        super.m_87963_(guiGraphics, mouseX, mouseY, pPartialTick);
                        if (this.m_274382_()) {
                            guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"ds.gui.toggle_inventory.dragon"), mouseX, mouseY);
                        }
                    }
                });
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void removeFireOverlay(RenderBlockScreenEffectEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
            if (cap.isDragon() && Objects.equals(cap.getType(), DragonTypes.CAVE) && event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.FIRE) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void renderTrap(RenderLivingEvent.Pre<LivingEntity, EntityModel<LivingEntity>> postEvent) {
        LivingEntity entity = postEvent.getEntity();
        if (entity.m_21124_(DragonEffects.TRAPPED) != null) {
            DragonStateHandler handler;
            int light = postEvent.getPackedLight();
            int overlayCoords = LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f);
            MultiBufferSource buffers = postEvent.getMultiBufferSource();
            PoseStack matrixStack = postEvent.getPoseStack();
            float scale = entity.m_20192_();
            if (entity instanceof Player && (handler = DragonUtils.getHandler((Entity)entity)) != null && handler.isDragon()) {
                scale = (float)DragonSizeHandler.calculateDragonEyeHeight(handler.getSize(), ServerConfig.hitboxGrowsPastHuman);
            }
            ClientEvents.renderBolas(light, overlayCoords, buffers, matrixStack, scale);
        }
    }

    public static void renderBolas(int light, int overlayCoords, MultiBufferSource buffers, PoseStack matrixStack, float eyeHeight) {
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, 0.9f + eyeHeight / 8.0f, 0.0f);
        matrixStack.m_85841_(1.6f + eyeHeight / 8.0f, 1.6f + eyeHeight / 8.0f, 1.6f + eyeHeight / 8.0f);
        if (BOLAS == null) {
            BOLAS = new ItemStack((ItemLike)DSItems.huntingNet);
        }
        Minecraft.m_91087_().m_91291_().m_269128_(BOLAS, ItemDisplayContext.NONE, light, overlayCoords, matrixStack, buffers, (Level)Minecraft.m_91087_().f_91073_, 0);
        matrixStack.m_85849_();
    }

    @SubscribeEvent
    public static void unloadWorld(LevelEvent.Unload worldEvent) {
        ClientDragonRender.playerDragonHashMap.clear();
    }

    public static String getMaterial(String texture, ItemStack clawItem) {
        Item item = clawItem.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem item2 = (TieredItem)item;
            Tier tier = item2.m_43314_();
            texture = tier == Tiers.NETHERITE ? (String)texture + "netherite_" : (tier == Tiers.DIAMOND ? (String)texture + "diamond_" : (tier == Tiers.IRON ? (String)texture + "iron_" : (tier == Tiers.GOLD ? (String)texture + "gold_" : (tier == Tiers.STONE ? (String)texture + "stone_" : (tier == Tiers.WOOD ? (String)texture + "wooden_" : (String)texture + "moded_")))));
            return texture;
        }
        return (String)texture + "moded_";
    }

    public static void renderOverlay(DragonStateHandler handler, ForgeGui forgeGUI, GuiGraphics guiGraphics) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer == null || !forgeGUI.shouldDrawSurvivalElements()) {
            return;
        }
        AbstractDragonType abstractDragonType = handler.getType();
        if (abstractDragonType instanceof SeaDragonType) {
            SeaDragonType seaDragonType = (SeaDragonType)abstractDragonType;
            if (seaDragonType.timeWithoutWater > 0.0 && ServerConfig.penalties.booleanValue() && ServerConfig.seaTicksWithoutWater != 0) {
                RenderSystem.enableBlend();
                int rightHeight = forgeGUI.rightHeight;
                forgeGUI.rightHeight += 10;
                int maxTimeWithoutWater = ServerConfig.seaTicksWithoutWater;
                WaterAbility waterAbility = DragonAbilities.getSelfAbility((LivingEntity)localPlayer, WaterAbility.class);
                if (waterAbility != null) {
                    maxTimeWithoutWater += Functions.secondsToTicks(waterAbility.getDuration());
                }
                double timeWithoutWater = (double)maxTimeWithoutWater - seaDragonType.timeWithoutWater;
                boolean flag = false;
                if (timeWithoutWater < 0.0) {
                    flag = true;
                    timeWithoutWater = Math.abs(timeWithoutWater);
                }
                int left = Minecraft.m_91087_().m_91268_().m_85445_() / 2 + 91;
                int top = Minecraft.m_91087_().m_91268_().m_85446_() - rightHeight;
                int full = flag ? Mth.m_14107_((double)(timeWithoutWater * 10.0 / (double)maxTimeWithoutWater)) : Mth.m_14165_((double)((timeWithoutWater - 2.0) * 10.0 / (double)maxTimeWithoutWater));
                int partial = Mth.m_14165_((double)(timeWithoutWater * 10.0 / (double)maxTimeWithoutWater)) - full;
                for (int i = 0; i < full + partial; ++i) {
                    guiGraphics.m_280218_(DRAGON_HUD, left - i * 8 - 9, top, flag ? 18 : (i < full ? 0 : 9), 36, 9, 9);
                }
                RenderSystem.disableBlend();
            }
        } else {
            AbstractDragonType maxTimeWithoutWater = handler.getType();
            if (maxTimeWithoutWater instanceof CaveDragonType) {
                int rightHeight;
                CaveDragonType caveDragonType = (CaveDragonType)maxTimeWithoutWater;
                if (caveDragonType.timeInRain > 0 && ServerConfig.penalties.booleanValue() && ServerConfig.caveRainDamage != 0.0) {
                    RenderSystem.enableBlend();
                    rightHeight = forgeGUI.rightHeight;
                    forgeGUI.rightHeight += 10;
                    ContrastShowerAbility contrastShower = DragonAbilities.getSelfAbility((LivingEntity)localPlayer, ContrastShowerAbility.class);
                    int maxRainTime = 0;
                    if (contrastShower != null) {
                        maxRainTime += Functions.secondsToTicks(contrastShower.getDuration());
                    }
                    int timeInRain = maxRainTime - Math.min(caveDragonType.timeInRain, maxRainTime);
                    int left = Minecraft.m_91087_().m_91268_().m_85445_() / 2 + 91;
                    int top = Minecraft.m_91087_().m_91268_().m_85446_() - rightHeight;
                    int full = Mth.m_14165_((double)((double)(timeInRain - 2) * 10.0 / (double)maxRainTime));
                    int partial = Mth.m_14165_((double)((double)timeInRain * 10.0 / (double)maxRainTime)) - full;
                    for (int i = 0; i < full + partial; ++i) {
                        guiGraphics.m_280218_(DRAGON_HUD, left - i * 8 - 9, top, i < full ? 0 : 9, 54, 9, 9);
                    }
                    RenderSystem.disableBlend();
                }
                if (caveDragonType.lavaAirSupply < ServerConfig.caveLavaSwimmingTicks && ServerConfig.bonuses.booleanValue() && ServerConfig.caveLavaSwimmingTicks != 0 && ServerConfig.caveLavaSwimming.booleanValue()) {
                    RenderSystem.enableBlend();
                    rightHeight = forgeGUI.rightHeight;
                    forgeGUI.rightHeight += 10;
                    int left = Minecraft.m_91087_().m_91268_().m_85445_() / 2 + 91;
                    int top = Minecraft.m_91087_().m_91268_().m_85446_() - rightHeight;
                    int full = Mth.m_14165_((double)((double)(caveDragonType.lavaAirSupply - 2) * 10.0 / (double)ServerConfig.caveLavaSwimmingTicks.intValue()));
                    int partial = Mth.m_14165_((double)((double)caveDragonType.lavaAirSupply * 10.0 / (double)ServerConfig.caveLavaSwimmingTicks.intValue())) - full;
                    for (int i = 0; i < full + partial; ++i) {
                        guiGraphics.m_280218_(DRAGON_HUD, left - i * 8 - 9, top, i < full ? 0 : 9, 27, 9, 9);
                    }
                    RenderSystem.disableBlend();
                }
            } else {
                AbstractDragonType left = handler.getType();
                if (left instanceof ForestDragonType) {
                    ForestDragonType forestDragonType = (ForestDragonType)left;
                    if (forestDragonType.timeInDarkness > 0 && ServerConfig.penalties.booleanValue() && ServerConfig.forestStressTicks != 0 && !localPlayer.m_21023_(DragonEffects.STRESS)) {
                        RenderSystem.enableBlend();
                        int rightHeight = forgeGUI.rightHeight;
                        forgeGUI.rightHeight += 10;
                        int maxTimeInDarkness = ServerConfig.forestStressTicks;
                        LightInDarknessAbility lightInDarkness = DragonAbilities.getSelfAbility((LivingEntity)localPlayer, LightInDarknessAbility.class);
                        if (lightInDarkness != null) {
                            maxTimeInDarkness += Functions.secondsToTicks(lightInDarkness.getDuration());
                        }
                        int timeInDarkness = maxTimeInDarkness - Math.min(forestDragonType.timeInDarkness, maxTimeInDarkness);
                        int left2 = Minecraft.m_91087_().m_91268_().m_85445_() / 2 + 91;
                        int top = Minecraft.m_91087_().m_91268_().m_85446_() - rightHeight;
                        int full = Mth.m_14165_((double)((double)(timeInDarkness - 2) * 10.0 / (double)maxTimeInDarkness));
                        int partial = Mth.m_14165_((double)((double)timeInDarkness * 10.0 / (double)maxTimeInDarkness)) - full;
                        for (int i = 0; i < full + partial; ++i) {
                            guiGraphics.m_280218_(DRAGON_HUD, left2 - i * 8 - 9, top, i < full ? 0 : 9, 45, 9, 9);
                        }
                        RenderSystem.disableBlend();
                    }
                }
            }
        }
    }

    private static /* synthetic */ void lambda$sendClientData$1(RequestClientData message, Player player, DragonStateHandler cap) {
        if (cap.isDragon() && DragonEditorRegistry.getSavedCustomizations() != null) {
            int currentSelected = DragonEditorRegistry.getSavedCustomizations().current.getOrDefault(message.type.getTypeNameUpperCase(), new HashMap()).getOrDefault((Object)message.level, 0);
            SkinPreset preset = DragonEditorRegistry.getSavedCustomizations().skinPresets.getOrDefault(message.type.getTypeNameUpperCase(), new HashMap()).getOrDefault(currentSelected, new SkinPreset());
            NetworkHandler.CHANNEL.sendToServer((Object)new SyncPlayerSkinPreset(player.m_19879_(), preset));
        }
    }
}

