/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.handlers;

import by.dragonsurvivalteam.dragonsurvival.client.handlers.Keybind;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRender;
import by.dragonsurvivalteam.dragonsurvival.client.sounds.FastGlideSound;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.mixins.AccessorGameRenderer;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.flight.RequestSpinResync;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncFlightSpeed;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncFlyingStatus;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncSpinStatus;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.ServerFlightHandler;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.blaze3d.platform.Window;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientFlightHandler {
    @ConfigOption(side=ConfigSide.CLIENT, category={"flight"}, key="notifyWingStatus", comment={"Notifies of wing status in chat message"})
    public static Boolean notifyWingStatus = false;
    @ConfigOption(side=ConfigSide.CLIENT, category={"flight"}, key="jumpToFly", comment={"Should flight be activated when jumping in the air"})
    public static Boolean jumpToFly = false;
    @ConfigOption(side=ConfigSide.CLIENT, category={"flight"}, key="lookAtSkyForFlight", comment={"Is it required to look up to start flying while jumping, requires that jumpToFly is on"})
    public static Boolean lookAtSkyForFlight = false;
    @ConfigOption(side=ConfigSide.CLIENT, category={"flight"}, key="flightZoomEffect", comment={"Should the zoom effect while gliding as a dragon be enabled"})
    public static Boolean flightZoomEffect = true;
    @ConfigOption(side=ConfigSide.CLIENT, category={"flight"}, key="flightCameraMovement", comment={"Should the camera movement while gliding as a dragon be enabled"})
    public static Boolean flightCameraMovement = true;
    @ConfigOption(side=ConfigSide.CLIENT, category={"flight"}, key="ownSpinParticles", comment={"Should particles from your own spin attack be displayed for you?"})
    public static Boolean ownSpinParticles = true;
    @ConfigOption(side=ConfigSide.CLIENT, category={"flight"}, key="othersSpinParticles", comment={"Should other players particles from spin attack be shown for you?"})
    public static Boolean othersSpinParticles = true;
    @ConfigRange(min=-1000.0, max=1000.0)
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "spin"}, key="spinCooldownXOffset", comment={"Offset the x position of the spin cooldown indicator in relation to its normal position"})
    public static Integer spinCooldownXOffset = 0;
    @ConfigRange(min=-1000.0, max=1000.0)
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "spin"}, key="spinCooldownYOffset", comment={"Offset the y position of the spin cooldown indicator in relation to its normal position"})
    public static Integer spinCooldownYOffset = 0;
    public static final ResourceLocation SPIN_COOLDOWN = new ResourceLocation("dragonsurvival", "textures/gui/spin_cooldown.png");
    public static int lastSync;
    public static boolean wasGliding;
    public static boolean wasFlying;
    static double ax;
    static double ay;
    static double az;
    static double lastIncrease;
    static float lastZoom;
    private static long lastHungerMessage;
    private static int levitationLeft;

    @SubscribeEvent
    public static void flightCamera(ViewportEvent.ComputeCameraAngles setup) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer currentPlayer = minecraft.f_91074_;
        Camera info = setup.getCamera();
        if (currentPlayer != null && currentPlayer.isAddedToWorld()) {
            DragonStateHandler dragonStateHandler = DragonUtils.getHandler((Entity)currentPlayer);
            AccessorGameRenderer gameRenderer = (AccessorGameRenderer)minecraft.f_91063_;
            if (ServerFlightHandler.isGliding((Player)currentPlayer)) {
                Vec3 lookVec;
                if (setup.getCamera().m_90594_() && flightCameraMovement.booleanValue()) {
                    lookVec = currentPlayer.m_20154_();
                    double increase = Mth.m_14008_((double)(lookVec.f_82480_ * 10.0), (double)0.0, (double)(lookVec.f_82480_ * 5.0));
                    double gradualIncrease = Mth.m_14139_((double)0.25, (double)lastIncrease, (double)increase);
                    info.m_90568_(0.0, gradualIncrease, 0.0);
                    lastIncrease = gradualIncrease;
                }
                if (minecraft.f_91074_ != null && flightZoomEffect.booleanValue() && !minecraft.f_91066_.m_92176_().m_90612_()) {
                    lookVec = currentPlayer.m_20154_();
                    float f = Math.min(Math.max(0.5f, 1.0f - (float)(lookVec.f_82480_ * 5.0 / 2.5 * 0.5)), 3.0f);
                    float newZoom = Mth.m_14179_((float)0.25f, (float)lastZoom, (float)f);
                    gameRenderer.setZoom(newZoom);
                    lastZoom = newZoom;
                }
            } else {
                if (lastIncrease > 0.0 && flightCameraMovement.booleanValue()) {
                    lastIncrease = Mth.m_14139_((double)0.25, (double)lastIncrease, (double)0.0);
                    info.m_90568_(0.0, lastIncrease, 0.0);
                }
                if (lastZoom != 1.0f && flightZoomEffect.booleanValue()) {
                    lastZoom = Mth.m_14179_((float)0.25f, (float)lastZoom, (float)1.0f);
                    gameRenderer.setZoom(lastZoom);
                }
                if (setup.getCamera().m_90594_() && dragonStateHandler.isDragon() && dragonStateHandler.getSize() > ServerConfig.DEFAULT_MAX_GROWTH_SIZE) {
                    double offset = (dragonStateHandler.getSize() - ServerConfig.DEFAULT_MAX_GROWTH_SIZE) / 20.0;
                    info.m_90568_(-offset, 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void renderFlightCooldown(RenderGuiOverlayEvent.Post event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || player.m_5833_()) {
            return;
        }
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        if (!handler.isDragon()) {
            return;
        }
        if (!ServerFlightHandler.isFlying((LivingEntity)player) && !ServerFlightHandler.canSwimSpin((LivingEntity)player)) {
            return;
        }
        if (handler.getMovementData().spinLearned && handler.getMovementData().spinCooldown > 0 && event.getOverlay() == VanillaGuiOverlay.AIR_LEVEL.type()) {
            Window window = Minecraft.m_91087_().m_91268_();
            int cooldown = ServerFlightHandler.flightSpinCooldown * 20;
            float f = ((float)cooldown - (float)handler.getMovementData().spinCooldown) / (float)cooldown;
            int k = window.m_85445_() / 2 - 33;
            int j = window.m_85446_() - 96;
            int l = (int)(f * 62.0f);
            event.getGuiGraphics().m_280163_(SPIN_COOLDOWN, k += spinCooldownXOffset.intValue(), j += spinCooldownYOffset.intValue(), 0.0f, 0.0f, 66, 21, 256, 256);
            event.getGuiGraphics().m_280163_(SPIN_COOLDOWN, k + 4, j + 1, 4.0f, 21.0f, l, 21, 256, 256);
        }
    }

    @SubscribeEvent
    public static void flightParticles(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.phase == TickEvent.Phase.START || playerTickEvent.side == LogicalSide.SERVER) {
            return;
        }
        Player player = playerTickEvent.player;
        DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
            if (handler.isDragon() && handler.getMovementData().spinAttack > 0) {
                if (!ownSpinParticles.booleanValue() && player == Minecraft.m_91087_().f_91074_) {
                    return;
                }
                if (!othersSpinParticles.booleanValue() && player != Minecraft.m_91087_().f_91074_) {
                    return;
                }
                if (player.f_19797_ - lastSync >= 20) {
                    NetworkHandler.CHANNEL.sendToServer((Object)new RequestSpinResync());
                }
                if (ServerFlightHandler.canSwimSpin((LivingEntity)player) && ServerFlightHandler.isSpin(player)) {
                    ClientFlightHandler.spawnSpinParticle(player, (ParticleOptions)(player.m_20069_() ? ParticleTypes.f_123774_ : ParticleTypes.f_123756_));
                }
                if (EnchantmentHelper.m_44914_((LivingEntity)player) > 0) {
                    ClientFlightHandler.spawnSpinParticle(player, (ParticleOptions)ParticleTypes.f_123756_);
                } else if (EnchantmentHelper.m_44894_((LivingEntity)player) > 0) {
                    ClientFlightHandler.spawnSpinParticle(player, (ParticleOptions)ParticleTypes.f_123813_);
                } else if (EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)player) > 0) {
                    ClientFlightHandler.spawnSpinParticle(player, (ParticleOptions)ParticleTypes.f_123766_);
                } else if (EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44977_, (LivingEntity)player) > 0) {
                    ClientFlightHandler.spawnSpinParticle(player, (ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f));
                } else if (EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44978_, (LivingEntity)player) > 0) {
                    ClientFlightHandler.spawnSpinParticle(player, (ParticleOptions)ParticleTypes.f_123809_);
                } else if (EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44979_, (LivingEntity)player) > 0) {
                    ClientFlightHandler.spawnSpinParticle(player, (ParticleOptions)ParticleTypes.f_123786_);
                }
            }
        });
    }

    private static void spawnSpinParticle(Player player, ParticleOptions particleData) {
        for (int i = 0; i < 20; ++i) {
            double d0 = ((double)player.m_217043_().m_188501_() - 0.5) * 2.0;
            double d1 = ((double)player.m_217043_().m_188501_() - 0.5) * 2.0;
            double d2 = ((double)player.m_217043_().m_188501_() - 0.5) * 2.0;
            double posX = player.m_20182_().f_82479_ + player.m_20184_().f_82479_ + d0;
            double posY = player.m_20182_().f_82480_ - 1.5 + player.m_20184_().f_82480_ + d1;
            double posZ = player.m_20182_().f_82481_ + player.m_20184_().f_82481_ + d2;
            player.m_9236_().m_7106_(particleData, posX, posY, posZ, player.m_20184_().f_82479_ * -1.0, player.m_20184_().f_82480_ * -1.0, player.m_20184_().f_82481_ * -1.0);
        }
    }

    @SubscribeEvent
    public static void flightControl(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (player != null && !player.m_20159_() && !Minecraft.m_91087_().m_91104_()) {
            if (player.m_21023_(MobEffects.f_19620_)) {
                levitationLeft = Functions.secondsToTicks(ServerFlightHandler.levitationAfterEffect);
            } else if (levitationLeft > 0) {
                if (event.phase == TickEvent.Phase.END) {
                    --levitationLeft;
                }
            } else {
                DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
                    if (handler.isDragon()) {
                        Input movement;
                        Double flightMult = 1.0;
                        if (DragonUtils.getDragonBody(handler) != null) {
                            flightMult = DragonUtils.getDragonBody(handler).getFlightMult();
                        }
                        Vec3 viewVector = player.m_20154_();
                        double yaw = Math.toRadians(player.m_6080_() + 90.0f);
                        if (ServerFlightHandler.canSwimSpin((LivingEntity)player) && ServerFlightHandler.isSpin((Player)player)) {
                            movement = player.f_108618_;
                            Vec3 deltaMovement = player.m_20184_();
                            double maxFlightSpeed = ServerFlightHandler.maxFlightSpeed;
                            ax = Mth.m_14008_((double)ax, (double)(-0.4 * maxFlightSpeed), (double)(0.4 * maxFlightSpeed));
                            az = Mth.m_14008_((double)az, (double)(-0.4 * maxFlightSpeed), (double)(0.4 * maxFlightSpeed));
                            ay = viewVector.f_82480_ / 8.0;
                            deltaMovement = viewVector.f_82480_ < 0.0 ? deltaMovement.m_82520_(ax, 0.0, az) : deltaMovement.m_82520_(ax += Math.cos(yaw) / 500.0 * 50.0 * 2.0, ay, az += Math.sin(yaw) / 500.0 * 50.0 * 2.0);
                            deltaMovement = deltaMovement.m_82542_((double)0.99f, (double)0.98f, (double)0.99f);
                            player.m_20256_(deltaMovement);
                            ay = player.m_20184_().f_82480_;
                        }
                        if (handler.isWingsSpread()) {
                            boolean hasFood;
                            movement = player.f_108618_;
                            boolean bl = hasFood = player.m_36324_().m_38702_() > ServerFlightHandler.flightHungerThreshold || player.m_7500_() || ServerFlightHandler.allowFlyingWithoutHunger != false;
                            if (!hasFood) {
                                ay = Mth.m_14008_((double)Math.abs(ay * 4.0), (double)(-0.4 * ServerFlightHandler.maxFlightSpeed), (double)(0.4 * ServerFlightHandler.maxFlightSpeed));
                            }
                            if (ServerFlightHandler.isFlying((LivingEntity)player)) {
                                if (!wasFlying) {
                                    wasFlying = true;
                                }
                                Vec3 deltaMovement = player.m_20184_();
                                double horizontalView = viewVector.m_165924_();
                                double horizontalMovement = deltaMovement.m_165924_();
                                double lookMagnitude = viewVector.m_82553_();
                                float pitch = (float)Math.toRadians(player.m_146909_());
                                float verticalDelta = Mth.m_14089_((float)pitch);
                                verticalDelta = (float)((double)verticalDelta * (double)verticalDelta * Math.min(1.0, lookMagnitude / 0.4));
                                double gravity = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22135_();
                                if (ServerFlightHandler.isGliding((Player)player) && !wasGliding) {
                                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new FastGlideSound(player));
                                    wasGliding = true;
                                }
                                if (ServerFlightHandler.isGliding((Player)player) || ax != 0.0 || az != 0.0) {
                                    deltaMovement = player.m_20184_().m_82520_(0.0, gravity * (-1.0 + (double)verticalDelta * 0.75), 0.0);
                                    if (deltaMovement.f_82480_ < 0.0 && horizontalView > 0.0) {
                                        double downwardMomentum = deltaMovement.f_82480_ * -0.1 * (double)verticalDelta * flightMult;
                                        deltaMovement = deltaMovement.m_82520_(viewVector.f_82479_ * downwardMomentum / horizontalView, downwardMomentum, viewVector.f_82481_ * downwardMomentum / horizontalView);
                                    }
                                    if (pitch < 0.0f && horizontalView > 0.0) {
                                        double delta = horizontalMovement * (double)(-Mth.m_14031_((float)pitch)) * 0.04 * flightMult;
                                        deltaMovement = deltaMovement.m_82520_(-viewVector.f_82479_ * delta / horizontalView, delta * 3.2, -viewVector.f_82481_ * delta / horizontalView);
                                    }
                                    if (horizontalView > 0.0) {
                                        deltaMovement = deltaMovement.m_82520_((viewVector.f_82479_ * flightMult / horizontalView * horizontalMovement - deltaMovement.f_82479_) * 0.1, 0.0, (viewVector.f_82481_ * flightMult / horizontalView * horizontalMovement - deltaMovement.f_82481_) * 0.1);
                                    }
                                    if (viewVector.f_82480_ < 0.0) {
                                        ax += Math.cos(yaw) * flightMult * 2.0 / 500.0;
                                        az += Math.sin(yaw) * flightMult * 2.0 / 500.0;
                                    } else {
                                        ay = viewVector.f_82480_ / 4.0;
                                        ax *= 0.98;
                                        az *= 0.98;
                                    }
                                    double speedLimit = ServerFlightHandler.maxFlightSpeed * flightMult;
                                    ax = Mth.m_14008_((double)ax, (double)(-0.4 * speedLimit), (double)(0.4 * speedLimit));
                                    az = Mth.m_14008_((double)az, (double)(-0.4 * speedLimit), (double)(0.4 * speedLimit));
                                    if (ServerFlightHandler.isSpin((Player)player)) {
                                        ax += Math.cos(yaw) * flightMult * 100.0 * 2.0 / 500.0;
                                        az += Math.sin(yaw) * flightMult * 100.0 * 2.0 / 500.0;
                                        ay = viewVector.f_82480_ / 4.0;
                                    }
                                    if (ServerFlightHandler.isGliding((Player)player)) {
                                        deltaMovement = viewVector.f_82480_ < 0.0 ? deltaMovement.m_82520_(ax, 0.0, az) : (Math.abs(horizontalMovement) > 0.4 || ServerFlightHandler.unlimitedFlightAcceleration != false ? deltaMovement.m_82520_(ax, ay, az) : deltaMovement.m_82520_(ax, ay * horizontalMovement, az));
                                        deltaMovement = deltaMovement.m_82542_((double)0.99f, (double)0.98f, (double)0.99f);
                                        player.m_20256_(deltaMovement);
                                        ay = player.m_20184_().f_82480_;
                                    }
                                }
                                if (!ServerFlightHandler.isGliding((Player)player)) {
                                    boolean moving;
                                    wasGliding = false;
                                    double maxForward = 0.5 * flightMult * 2.0;
                                    Vec3 moveVector = ClientDragonRender.getInputVector(new Vec3((double)movement.f_108566_, 0.0, (double)movement.f_108567_), 1.0f, player.f_19857_);
                                    moveVector.m_82542_(1.3 * flightMult * 2.0, 0.0, 1.3 * flightMult * 2.0);
                                    boolean bl2 = moving = movement.f_108568_ || movement.f_108569_ || movement.f_108570_ || movement.f_108571_;
                                    if (ServerFlightHandler.isSpin((Player)player)) {
                                        ax += Math.cos(yaw) * flightMult * 200.0 * 2.0 / 500.0;
                                        az += Math.sin(yaw) * flightMult * 200.0 * 2.0 / 500.0;
                                        ay = viewVector.f_82480_ / 8.0;
                                    }
                                    if (!(!ServerFlightHandler.stableHover || movement.f_108572_ || movement.f_108573_ || ServerFlightHandler.isSpin((Player)player) || ServerFlightHandler.isGliding((Player)player))) {
                                        ay = Math.max(ay, gravity * 1.1);
                                    }
                                    if (moving && !movement.f_108572_ && !movement.f_108573_) {
                                        maxForward = 0.8 * flightMult * 2.0;
                                        moveVector.m_82542_(1.4 * flightMult * 2.0, 0.0, 1.4 * flightMult * 2.0);
                                        deltaMovement = new Vec3(Mth.m_14139_((double)0.14, (double)deltaMovement.f_82479_, (double)moveVector.f_82479_), 0.0, Mth.m_14139_((double)0.14, (double)deltaMovement.f_82481_, (double)moveVector.f_82481_));
                                        deltaMovement = new Vec3(Mth.m_14008_((double)deltaMovement.f_82479_, (double)(-maxForward), (double)maxForward), 0.0, Mth.m_14008_((double)deltaMovement.f_82481_, (double)(-maxForward), (double)maxForward));
                                        deltaMovement = deltaMovement.m_82520_(ax, ay, az);
                                        ax *= (double)0.9f;
                                        ay *= (double)0.9f;
                                        az *= (double)0.9f;
                                        deltaMovement = !ServerFlightHandler.stableHover ? new Vec3(deltaMovement.f_82479_, -(gravity * 2.0) + deltaMovement.f_82480_, deltaMovement.f_82481_) : new Vec3(deltaMovement.f_82479_, -gravity + deltaMovement.f_82480_, deltaMovement.f_82481_);
                                        player.m_20256_(deltaMovement);
                                    } else {
                                        deltaMovement = deltaMovement.m_82542_((double)0.99f, (double)0.98f, (double)0.99f);
                                        deltaMovement = new Vec3(Mth.m_14139_((double)0.14, (double)deltaMovement.f_82479_, (double)moveVector.f_82479_), 0.0, Mth.m_14139_((double)0.14, (double)deltaMovement.f_82481_, (double)moveVector.f_82481_));
                                        deltaMovement = new Vec3(Mth.m_14008_((double)deltaMovement.f_82479_, (double)(-maxForward), (double)maxForward), 0.0, Mth.m_14008_((double)deltaMovement.f_82481_, (double)(-maxForward), (double)maxForward));
                                        deltaMovement = deltaMovement.m_82520_(ax, ay, az);
                                        if (ServerFlightHandler.isSpin((Player)player)) {
                                            deltaMovement.m_82542_(10.0, 10.0, 10.0);
                                        }
                                        ax *= (double)0.9f;
                                        ay *= (double)0.9f;
                                        az *= (double)0.9f;
                                        if (movement.f_108572_) {
                                            deltaMovement = new Vec3(deltaMovement.f_82479_, 0.4 + deltaMovement.f_82480_, deltaMovement.f_82481_);
                                            player.m_20256_(deltaMovement);
                                        } else if (movement.f_108573_) {
                                            deltaMovement = new Vec3(deltaMovement.f_82479_, -0.5 + deltaMovement.f_82480_, deltaMovement.f_82481_);
                                            player.m_20256_(deltaMovement);
                                        } else if (wasFlying) {
                                            double yMotion = hasFood ? -gravity + ay : -(gravity * 4.0) + ay;
                                            deltaMovement = new Vec3(deltaMovement.f_82479_, yMotion, deltaMovement.f_82481_);
                                            player.m_20256_(deltaMovement);
                                        }
                                    }
                                }
                            } else {
                                wasGliding = false;
                                wasFlying = false;
                                ax = 0.0;
                                az = 0.0;
                                ay = 0.0;
                            }
                        } else {
                            ax = 0.0;
                            az = 0.0;
                            ay = 0.0;
                        }
                    }
                });
            }
            if (event.phase == TickEvent.Phase.END && player.f_19797_ % 5 == 0) {
                NetworkHandler.CHANNEL.sendToServer((Object)new SyncFlightSpeed(player.m_19879_(), player.m_20184_()));
            }
        }
    }

    @SubscribeEvent
    public static void spin(InputEvent.MouseButton keyInputEvent) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        if (!handler.isDragon()) {
            return;
        }
        if (Keybind.SPIN_ABILITY.getKey().m_84873_() == keyInputEvent.getButton()) {
            ClientFlightHandler.spinKeybind(player, handler);
        }
    }

    private static void spinKeybind(LocalPlayer player, DragonStateHandler handler) {
        if (!ServerFlightHandler.isSpin((Player)player) && handler.getMovementData().spinCooldown <= 0 && handler.getMovementData().spinLearned && (ServerFlightHandler.isFlying((LivingEntity)player) || ServerFlightHandler.canSwimSpin((LivingEntity)player))) {
            handler.getMovementData().spinAttack = ServerFlightHandler.spinDuration;
            handler.getMovementData().spinCooldown = ServerFlightHandler.flightSpinCooldown * 20;
            NetworkHandler.CHANNEL.sendToServer((Object)new SyncSpinStatus(player.m_19879_(), handler.getMovementData().spinAttack, handler.getMovementData().spinCooldown, handler.getMovementData().spinLearned));
        }
    }

    @SubscribeEvent
    public static void toggleWings(InputEvent.Key keyInputEvent) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        if (handler == null || !handler.isDragon()) {
            return;
        }
        boolean currentState = handler.isWingsSpread();
        Vec3 lookVec = player.m_20154_();
        if (Keybind.SPIN_ABILITY.getKey().m_84873_() == keyInputEvent.getKey()) {
            ClientFlightHandler.spinKeybind(player, handler);
        }
        if (!(!jumpToFly.booleanValue() || player.m_7500_() || player.m_5833_() || !minecraft.f_91066_.f_92089_.m_90857_() || keyInputEvent.getAction() != 1 || !handler.hasFlight() || currentState || !(lookVec.f_82480_ > 0.8) && lookAtSkyForFlight.booleanValue() || player.m_20096_() || player.m_20077_() || player.m_20069_())) {
            if (player.m_36324_().m_38702_() > ServerFlightHandler.flightHungerThreshold || player.m_7500_() || ServerFlightHandler.allowFlyingWithoutHunger.booleanValue()) {
                NetworkHandler.CHANNEL.sendToServer((Object)new SyncFlyingStatus(player.m_19879_(), true));
            } else if (lastHungerMessage == 0L || lastHungerMessage + TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS) < System.currentTimeMillis()) {
                lastHungerMessage = System.currentTimeMillis();
                player.m_213846_((Component)Component.m_237115_((String)"ds.wings.nohunger"));
            }
        }
        if (Keybind.TOGGLE_WINGS.m_90859_()) {
            if (handler.hasFlight()) {
                if (!player.m_21023_(DragonEffects.TRAPPED) && (player.m_36324_().m_38702_() > ServerFlightHandler.flightHungerThreshold || player.m_7500_() || currentState || ServerFlightHandler.allowFlyingWithoutHunger.booleanValue())) {
                    NetworkHandler.CHANNEL.sendToServer((Object)new SyncFlyingStatus(player.m_19879_(), !currentState));
                    if (notifyWingStatus.booleanValue()) {
                        if (!currentState) {
                            player.m_213846_((Component)Component.m_237115_((String)"ds.wings.enabled"));
                        } else {
                            player.m_213846_((Component)Component.m_237115_((String)"ds.wings.disabled"));
                        }
                    }
                } else if (!player.m_21023_(DragonEffects.TRAPPED)) {
                    player.m_213846_((Component)Component.m_237115_((String)"ds.wings.nohunger"));
                }
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"ds.you.have.no.wings"));
            }
        }
    }

    static {
        lastZoom = 1.0f;
    }
}

