/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.handlers;

import by.dragonsurvivalteam.dragonsurvival.client.util.RenderingUtils;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonGrowthHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ClientGrowthHudHandler {
    private static final HashMap<String, ResourceLocation> CACHE = new HashMap();
    private static final Color COLOR = new Color(99, 99, 99);
    private static final Color BRIGHTER_COLOR = COLOR.brighter();
    @ConfigRange(min=-1000.0, max=1000.0)
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "growth"}, key="growthXOffset", comment={"Offset the x position of the item growth icon in relation to its normal position"})
    public static Integer growthXOffset = 0;
    @ConfigRange(min=-1000.0, max=1000.0)
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "growth"}, key="growthYOffset", comment={"Offset the y position of the item growth icon in relation to its normal position"})
    public static Integer growthYOffset = 0;

    public static void renderGrowth(DragonStateHandler handler, @NotNull GuiGraphics guiGraphics, int width, int height) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer == null || localPlayer.m_5833_()) {
            return;
        }
        ItemStack stack = localPlayer.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        int increment = DragonGrowthHandler.getIncrement(stack.m_41720_(), handler.getLevel());
        if (increment != 0 && (handler.getSize() < ServerConfig.maxGrowthSize && increment > 0 || increment < 0 && handler.getSize() >= (double)(DragonLevel.NEWBORN.size + 1))) {
            float curSize = (float)handler.getSize();
            float nextSize = (float)(handler.getSize() + (double)increment);
            float progress = 0.0f;
            float nextProgess = 0.0f;
            if (handler.getLevel() == DragonLevel.NEWBORN) {
                progress = (curSize - (float)DragonLevel.NEWBORN.size) / (float)(DragonLevel.YOUNG.size - DragonLevel.NEWBORN.size);
                nextProgess = (nextSize - (float)DragonLevel.NEWBORN.size) / (float)(DragonLevel.YOUNG.size - DragonLevel.NEWBORN.size);
            } else if (handler.getLevel() == DragonLevel.YOUNG) {
                progress = (curSize - (float)DragonLevel.YOUNG.size) / (float)(DragonLevel.ADULT.size - DragonLevel.YOUNG.size);
                nextProgess = (nextSize - (float)DragonLevel.YOUNG.size) / (float)(DragonLevel.ADULT.size - DragonLevel.YOUNG.size);
            } else if (handler.getLevel() == DragonLevel.ADULT && handler.getSize() < 40.0) {
                progress = (curSize - (float)DragonLevel.ADULT.size) / (float)(40 - DragonLevel.ADULT.size);
                nextProgess = (nextSize - (float)DragonLevel.ADULT.size) / (float)(40 - DragonLevel.ADULT.size);
            } else if (handler.getLevel() == DragonLevel.ADULT && handler.getSize() >= 40.0) {
                progress = (float)((double)(curSize - 40.0f) / (ServerConfig.maxGrowthSize - 40.0));
                nextProgess = (float)((double)(nextSize - 40.0f) / (ServerConfig.maxGrowthSize - 40.0));
            }
            progress = Math.min(1.0f, progress);
            nextProgess = Math.min(1.0f, nextProgess);
            int radius = 17;
            int thickness = 5;
            int circleX = width / 2 - radius;
            int circleY = height - 90;
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.setShaderColor((float)((float)BRIGHTER_COLOR.getRed() / 255.0f), (float)((float)BRIGHTER_COLOR.getBlue() / 255.0f), (float)((float)BRIGHTER_COLOR.getGreen() / 255.0f), (float)1.0f);
            RenderingUtils.drawSmoothCircle(guiGraphics, (circleX += growthXOffset.intValue()) + radius, (circleY += growthYOffset.intValue()) + radius, radius, 6, 1.0, 0.0);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (nextProgess > progress) {
                int num = 1;
                double perSide = 0.16666666666666666;
                if ((double)nextProgess < (double)progress + perSide) {
                    nextProgess = (float)((double)progress + perSide);
                    num = 2;
                }
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ClientGrowthHudHandler.getOrCreate("textures/gui/growth/circle_" + num + ".png"));
                RenderingUtils.drawTexturedCircle(guiGraphics, circleX + radius, circleY + radius, radius, 0.5, 0.5, 0.5, 6, nextProgess, -0.5);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ClientGrowthHudHandler.getOrCreate("textures/gui/growth/circle_" + handler.getTypeNameLowerCase() + ".png"));
                RenderingUtils.drawTexturedCircle(guiGraphics, circleX + radius, circleY + radius, radius, 0.5, 0.5, 0.5, 6, progress, -0.5);
            } else if (increment < 0) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ClientGrowthHudHandler.getOrCreate("textures/gui/growth/circle_3.png"));
                RenderingUtils.drawTexturedCircle(guiGraphics, circleX + radius, circleY + radius, radius, 0.5, 0.5, 0.5, 6, progress, -0.5);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ClientGrowthHudHandler.getOrCreate("textures/gui/growth/circle_" + handler.getTypeNameLowerCase() + ".png"));
                RenderingUtils.drawTexturedCircle(guiGraphics, circleX + radius, circleY + radius, radius, 0.5, 0.5, 0.5, 6, nextProgess, -0.5);
            }
            RenderSystem.setShaderColor((float)((float)COLOR.getRed() / 255.0f), (float)((float)COLOR.getBlue() / 255.0f), (float)((float)COLOR.getGreen() / 255.0f), (float)1.0f);
            RenderingUtils.drawSmoothCircle(guiGraphics, circleX + radius, circleY + radius, radius - thickness, 6, 1.0, 0.0);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280163_(ClientGrowthHudHandler.getOrCreate("textures/gui/growth/growth_" + handler.getTypeNameLowerCase() + "_" + (handler.getLevel().ordinal() + 1) + ".png"), circleX + 6, circleY + 6, 0.0f, 0.0f, 20, 20, 20, 20);
        }
    }

    private static ResourceLocation getOrCreate(String path) {
        return CACHE.computeIfAbsent(path, key -> new ResourceLocation("dragonsurvival", path));
    }
}

