/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.handlers;

import by.dragonsurvivalteam.dragonsurvival.client.gui.AbilityScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.SkillProgressButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HelpButton;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonFoodHandler;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ToolTipHandler {
    private static final ResourceLocation tooltip_1 = new ResourceLocation("dragonsurvival", "textures/gui/magic_tips_0.png");
    private static final ResourceLocation tooltip_2 = new ResourceLocation("dragonsurvival", "textures/gui/magic_tips_1.png");
    @ConfigOption(side=ConfigSide.CLIENT, category={"tooltips"}, key="tooltipChanges", comment={"Should the mod be allowed ot change the color and appearance of tooltips?"})
    public static Boolean tooltipChanges = true;
    @ConfigOption(side=ConfigSide.CLIENT, category={"tooltips"}, key="hideUnsafeFood", comment={"Should the tooltip be hidden for unsafe (negative effects) food?"})
    public static Boolean hideUnsafeFood = true;
    @ConfigOption(side=ConfigSide.CLIENT, category={"tooltips"}, key="dragonFoodTooltips", comment={"Should dragon foods have their tooltip color changed to show which type of dragon can consume it?"})
    public static Boolean dragonFoodTooltips = true;
    @ConfigOption(side=ConfigSide.CLIENT, category={"tooltips"}, key="helpTooltips", comment={"Should the effect of the help tooltips be enabled?"})
    public static Boolean helpTooltips = true;
    @ConfigOption(side=ConfigSide.CLIENT, category={"tooltips"}, key="alwaysShowHelpTooltip", comment={"Always show the help tooltip border"})
    public static Boolean alwaysShowHelpTooltip = false;
    @ConfigOption(side=ConfigSide.CLIENT, category={"tooltips"}, key="hideAppleskinTooltip", comment={"Hide the AppleSkin tooltip if you're a dragon. The tooltip will only show correct food values for humans."})
    public static Boolean hideAppleskinTooltip = true;
    private static final ResourceLocation ICONS = new ResourceLocation("dragonsurvival", "food_tooltip_icon_font");
    private static boolean blink = false;
    private static int tick = 0;

    @SubscribeEvent
    public static void checkIfDragonFood(ItemTooltipEvent tooltipEvent) {
        if (DragonFoodHandler.disableDragonFoodHandling) {
            return;
        }
        if (tooltipEvent.getEntity() != null) {
            Item item = tooltipEvent.getItemStack().m_41720_();
            List toolTip = tooltipEvent.getToolTip();
            if (DragonFoodHandler.getEdibleFoods(DragonTypes.CAVE).contains(item)) {
                toolTip.add(ToolTipHandler.createFoodTooltip(item, DragonTypes.CAVE, ChatFormatting.RED, "\uea02", "\uea05"));
            }
            if (DragonFoodHandler.getEdibleFoods(DragonTypes.FOREST).contains(item)) {
                toolTip.add(ToolTipHandler.createFoodTooltip(item, DragonTypes.FOREST, ChatFormatting.GREEN, "\uea01", "\uea04"));
            }
            if (DragonFoodHandler.getEdibleFoods(DragonTypes.SEA).contains(item)) {
                toolTip.add(ToolTipHandler.createFoodTooltip(item, DragonTypes.SEA, ChatFormatting.DARK_AQUA, "\uea03", "\uea06"));
            }
        }
    }

    private static MutableComponent createFoodTooltip(Item item, AbstractDragonType type, ChatFormatting color, String nutritionIcon, String saturationIcon) {
        MutableComponent component = Component.m_237115_((String)("ds." + type.getTypeName() + ".dragon.food"));
        FoodProperties properties = DragonFoodHandler.getFoodProperties(item.m_7968_(), type);
        String nutrition = "0";
        String saturation = "0";
        if (properties != null) {
            float nutritionValue = properties.m_38744_();
            float saturationValue = (float)properties.m_38744_() * properties.m_38745_() * 2.0f;
            nutrition = String.format("%.1f", Float.valueOf(nutritionValue / 2.0f));
            saturation = String.format("%.1f", Float.valueOf(saturationValue / 2.0f));
        }
        MutableComponent nutritionIconComponent = Component.m_237113_((String)nutritionIcon).m_130948_(Style.f_131099_.m_131150_(ICONS));
        MutableComponent nutritionComponent = Component.m_237113_((String)(": " + nutrition + " ")).m_130940_(color);
        MutableComponent saturationIconComponent = Component.m_237113_((String)saturationIcon).m_130948_(Style.f_131099_.m_131150_(ICONS));
        MutableComponent saturationComponent = Component.m_237113_((String)(" / " + saturation + " ")).m_130940_(color);
        return component.m_7220_((Component)nutritionComponent).m_7220_((Component)nutritionIconComponent).m_7220_((Component)saturationComponent).m_7220_((Component)saturationIconComponent);
    }

    @SubscribeEvent
    public static void itemDescriptions(ItemTooltipEvent event) {
        if (event.getEntity() != null) {
            Item item = event.getItemStack().m_41720_();
            List toolTip = event.getToolTip();
            if (item == DSBlocks.fireDragonBeacon.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.passiveFireBeacon"));
            }
            if (item == DSBlocks.magicDragonBeacon.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.passiveMagicBeacon"));
            }
            if (item == DSBlocks.peaceDragonBeacon.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.passivePeaceBeacon"));
            }
            if (item == DSBlocks.caveDoor.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.caveDoor"));
            }
            if (item == DSBlocks.forestDoor.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.forestDoor"));
            }
            if (item == DSBlocks.seaDoor.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.seaDoor"));
            }
            if (item == DSBlocks.legacyDoor.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.legacyDoor"));
            }
            if (item == DSBlocks.helmet1.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.grayHelmet"));
            }
            if (item == DSBlocks.helmet2.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.goldHelmet"));
            }
            if (item == DSBlocks.helmet3.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.blackHelmet"));
            }
            if (item == DSBlocks.dragonBeacon.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.dragonBeacon"));
            }
            if (item == DSBlocks.dragonMemoryBlock.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.dragonMemoryBlock"));
            }
            if (item == DSBlocks.seaSourceOfMagic.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.sea_source_of_magic"));
            }
            if (item == DSBlocks.forestSourceOfMagic.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.forest_source_of_magic"));
            }
            if (item == DSBlocks.caveSourceOfMagic.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.cave_source_of_magic"));
            }
            if (item == DSBlocks.dragonPressurePlate.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.dragon_pressure_plate"));
            }
            if (item == DSBlocks.humanPressurePlate.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.human_pressure_plate"));
            }
            if (item == DSBlocks.seaPressurePlate.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.sea_dragon_pressure_plate"));
            }
            if (item == DSBlocks.forestPressurePlate.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.forest_dragon_pressure_plate"));
            }
            if (item == DSBlocks.cavePressurePlate.m_5456_()) {
                toolTip.add(Component.m_237115_((String)"ds.description.cave_dragon_pressure_plate"));
            }
        }
    }

    @SubscribeEvent
    public static void postScreenRender(ScreenEvent.Render.Post event) {
        if (Minecraft.m_91087_().f_91080_ != null && Minecraft.m_91087_().f_91080_.f_96540_ != null) {
            for (GuiEventListener button : Minecraft.m_91087_().f_91080_.f_96540_) {
                HelpButton helpButton;
                if (!(button instanceof HelpButton) || !(helpButton = (HelpButton)button).m_198029_()) continue;
                helpButton.renderTooltip(event.getGuiGraphics(), event.getMouseX(), event.getMouseY());
            }
        }
    }

    @SubscribeEvent
    public static void onTooltipEvent(RenderTooltipEvent.Pre event) {
        boolean render = ToolTipHandler.isHelpText();
        if (!render) {
            return;
        }
        if (!blink) {
            if (tick >= Functions.secondsToTicks(30)) {
                blink = true;
                tick = 0;
            }
        } else if (tick >= Functions.secondsToTicks(5)) {
            blink = false;
            tick = 0;
        }
        ++tick;
        Screen screen = Minecraft.m_91087_().f_91080_;
        int width = event.getComponents().stream().map(s -> s.m_142069_(Minecraft.m_91087_().f_91062_)).max(Integer::compareTo).orElse(0);
        int height = event.getComponents().stream().map(ClientTooltipComponent::m_142103_).reduce(Integer::sum).orElse(0);
        int x = event.getX() + 12;
        int y = event.getY() - 12;
        if (x + width > screen.f_96543_) {
            x -= 28 + width;
        }
        if (y + height + 6 > screen.f_96544_) {
            y = screen.f_96544_ - height - 6;
        }
        int texWidth = 128;
        int texHeight = 128;
        event.getGraphics().m_280398_(blink ? tooltip_2 : tooltip_1, x - 8 - 6, y - 8 - 6, 400, 1.0f, (float)(1 % texHeight), 16, 16, texWidth, texHeight);
        event.getGraphics().m_280398_(blink ? tooltip_2 : tooltip_1, x + width - 8 + 6, y - 8 - 6, 400, (float)(texWidth - 16 - 1), (float)(1 % texHeight), 16, 16, texWidth, texHeight);
        event.getGraphics().m_280398_(blink ? tooltip_2 : tooltip_1, x - 8 - 6, y + height - 8 + 6, 400, 1.0f, (float)(1 % texHeight + 16), 16, 16, texWidth, texHeight);
        event.getGraphics().m_280398_(blink ? tooltip_2 : tooltip_1, x + width - 8 + 6, y + height - 8 + 6, 400, (float)(texWidth - 16 - 1), (float)(1 % texHeight + 16), 16, 16, texWidth, texHeight);
        event.getGraphics().m_280398_(blink ? tooltip_2 : tooltip_1, x + width / 2 - 47, y - 16, 400, (float)(16 + 2 * texWidth + 1), (float)(1 % texHeight), 94, 16, texWidth, texHeight);
        event.getGraphics().m_280398_(blink ? tooltip_2 : tooltip_1, x + width / 2 - 47, y + height, 400, (float)(16 + 2 * texWidth + 1), (float)(1 % texHeight + 16), 94, 16, texWidth, texHeight);
    }

    private static boolean isHelpText() {
        if (!tooltipChanges.booleanValue() || !helpTooltips.booleanValue()) {
            return false;
        }
        if (Minecraft.m_91087_().f_91073_ == null) {
            return false;
        }
        if (alwaysShowHelpTooltip.booleanValue()) {
            return true;
        }
        if (Minecraft.m_91087_().f_91080_ == null) {
            return false;
        }
        for (GuiEventListener btn : Minecraft.m_91087_().f_91080_.f_96540_) {
            if (!(btn instanceof HelpButton) || !((HelpButton)btn).m_198029_()) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onTooltipColorEvent(RenderTooltipEvent.Color event) {
        if (!tooltipChanges.booleanValue() || DragonFoodHandler.disableDragonFoodHandling) {
            return;
        }
        boolean render = ToolTipHandler.isHelpText();
        boolean screen = Minecraft.m_91087_().f_91080_ instanceof AbilityScreen;
        ItemStack stack = event.getItemStack();
        boolean isSeaFood = dragonFoodTooltips != false && !stack.m_41619_() && DragonFoodHandler.getEdibleFoods(DragonTypes.SEA).contains(stack.m_41720_());
        boolean isForestFood = dragonFoodTooltips != false && !stack.m_41619_() && DragonFoodHandler.getEdibleFoods(DragonTypes.FOREST).contains(stack.m_41720_());
        boolean isCaveFood = dragonFoodTooltips != false && !stack.m_41619_() && DragonFoodHandler.getEdibleFoods(DragonTypes.CAVE).contains(stack.m_41720_());
        int foodCount = (isSeaFood ? 1 : 0) + (isForestFood ? 1 : 0) + (isCaveFood ? 1 : 0);
        boolean isFood = foodCount == 1;
        boolean button = false;
        if (screen) {
            for (GuiEventListener widget : ((AbilityScreen)Minecraft.m_91087_().f_91080_).widgetList()) {
                if (!(widget instanceof SkillProgressButton) || !((SkillProgressButton)widget).m_198029_()) continue;
                button = true;
                break;
            }
        }
        if (render) {
            int top = new Color(154, 132, 154).getRGB();
            int bottom = new Color(89, 68, 89).getRGB();
            event.setBorderStart(top);
            event.setBorderEnd(bottom);
        } else if (screen || isFood) {
            AbstractDragonType type = DragonUtils.getDragonType((Entity)Minecraft.m_91087_().f_91074_);
            Color topColor = null;
            Color bottomColor = null;
            if (type != null) {
                if (Objects.equals(type, DragonTypes.SEA) && button || isSeaFood) {
                    topColor = new Color(93, 201, 255);
                    bottomColor = new Color(49, 109, 144);
                } else if (Objects.equals(type, DragonTypes.FOREST) && button || isForestFood) {
                    topColor = new Color(0, 255, 148);
                    bottomColor = new Color(4, 130, 82);
                } else if (Objects.equals(type, DragonTypes.CAVE) && button || isCaveFood) {
                    topColor = new Color(255, 118, 133);
                    bottomColor = new Color(139, 66, 74);
                }
            }
            if (topColor != null) {
                event.setBorderStart(topColor.getRGB());
            }
            if (bottomColor != null) {
                event.setBorderEnd(bottomColor.getRGB());
            }
        }
    }
}

