/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.handlers.magic;

import by.dragonsurvivalteam.dragonsurvival.client.handlers.magic.ClientCastingHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.MagicCap;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.magic.ManaHandler;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ActiveDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ChannelingCastAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ChargeCastAbility;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.blaze3d.platform.Window;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class ClientMagicHUDHandler {
    public static final ResourceLocation VANILLA_WIDGETS = new ResourceLocation("textures/gui/widgets.png");
    public static final ResourceLocation widgetTextures = new ResourceLocation("dragonsurvival", "textures/gui/widgets.png");
    public static final ResourceLocation castBars = new ResourceLocation("dragonsurvival", "textures/gui/cast_bars.png");
    public static final Color COLOR = new Color(243, 48, 59);
    @ConfigRange(min=-1000.0, max=1000.0)
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "magic"}, key="casterBarXPos", comment={"Offset the x position of the cast bar in relation to its normal position"})
    public static Integer castbarXOffset = 0;
    @ConfigRange(min=-1000.0, max=1000.0)
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "magic"}, key="casterBarYPos", comment={"Offset the y position of the cast bar in relation to its normal position"})
    public static Integer castbarYOffset = 0;
    @ConfigRange(min=-1000.0, max=1000.0)
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "magic"}, key="skillbarXOffset", comment={"Offset the x position of the magic skill bar in relation to its normal position"})
    public static Integer skillbarXOffset = 0;
    @ConfigRange(min=-1000.0, max=1000.0)
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "magic"}, key="skillbarYOffset", comment={"Offset the y position of the magic skill bar in relation to its normal position"})
    public static Integer skillbarYOffset = 0;
    @ConfigRange(min=-1000.0, max=1000.0)
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "magic"}, key="manabarXOffset", comment={"Offset the x position of the mana bar in relation to its normal position"})
    public static Integer manabarXOffset = 0;
    @ConfigRange(min=-1000.0, max=1000.0)
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "magic"}, key="manabarYOffset", comment={"Offset the y position of the mana bar in relation to its normal position"})
    public static Integer manabarYOffset = 0;
    private static int errorTicks;
    private static MutableComponent errorMessage;

    public static boolean renderExperienceBar(ForgeGui gui, GuiGraphics guiGraphics, int screenWidth) {
        int height;
        Player localPlayer = ClientProxy.getLocalPlayer();
        if (localPlayer == null || !gui.shouldDrawSurvivalElements() || !Minecraft.m_91087_().f_91072_.m_105288_()) {
            return false;
        }
        DragonStateHandler handler = DragonStateProvider.getHandler((Entity)localPlayer);
        if (handler == null || !handler.isDragon()) {
            return false;
        }
        ActiveDragonAbility ability = handler.getMagicData().getAbilityFromSlot(handler.getMagicData().getSelectedAbilitySlot());
        if (ability == null || ability.canConsumeMana(localPlayer)) {
            return false;
        }
        Window window = Minecraft.m_91087_().m_91268_();
        int guiScaledWidth = window.m_85445_();
        int guiScaledHeight = window.m_85446_();
        Minecraft.m_91087_().m_91307_().m_6180_("expLevel");
        if (localPlayer.m_36323_() > 0) {
            int width = screenWidth / 2 - 91;
            int experienceProgress = (int)(localPlayer.f_36080_ * 183.0f);
            height = guiScaledHeight - 32 + 3;
            guiGraphics.m_280398_(widgetTextures, width, height, 0, 0.0f, 164.0f, 182, 5, 256, 256);
            if (experienceProgress > 0) {
                guiGraphics.m_280398_(widgetTextures, width, height, 0, 0.0f, 169.0f, experienceProgress, 5, 256, 256);
            }
        }
        Minecraft.m_91087_().m_91307_().m_7238_();
        if (localPlayer.f_36078_ > 0) {
            Minecraft.m_91087_().m_91307_().m_6180_("expLevel");
            String s = "" + localPlayer.f_36078_;
            int width = (guiScaledWidth - Minecraft.m_91087_().f_91062_.m_92895_(s)) / 2;
            height = guiScaledHeight - 31 - 4;
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, s, width + 1, height, 0, false);
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, s, width - 1, height, 0, false);
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, s, width, height + 1, 0, false);
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, s, width, height - 1, 0, false);
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, s, width, height, COLOR.getRGB(), false);
            Minecraft.m_91087_().m_91307_().m_7238_();
        }
        return true;
    }

    public static void castingError(MutableComponent component) {
        if (ClientCastingHandler.hasCast) {
            return;
        }
        errorTicks = Functions.secondsToTicks(5);
        errorMessage = component;
    }

    public static void renderAbilityHud(DragonStateHandler handler, GuiGraphics guiGraphics, int width, int height) {
        int i1;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer == null || localPlayer.m_5833_()) {
            return;
        }
        int sizeX = 20;
        int sizeY = 20;
        int posX = i1 = width - sizeX * MagicCap.activeAbilitySlots - 20;
        int posY = height - sizeY;
        posX += skillbarXOffset.intValue();
        posY += skillbarYOffset.intValue();
        if (handler.getMagicData().shouldRenderAbilities()) {
            guiGraphics.m_280398_(VANILLA_WIDGETS, posX, posY - 2, 0, 0.0f, 0.0f, 41, 22, 256, 256);
            guiGraphics.m_280398_(VANILLA_WIDGETS, posX + 41, posY - 2, 0, 141.0f, 0.0f, 41, 22, 256, 256);
            for (int x = 0; x < MagicCap.activeAbilitySlots; ++x) {
                ActiveDragonAbility ability = handler.getMagicData().getAbilityFromSlot(x);
                if (ability == null || ability.getIcon() == null) continue;
                guiGraphics.m_280163_(ability.getIcon(), posX + x * sizeX + 3, posY + 1, 0.0f, 0.0f, 16, 16, 16, 16);
                if (ability.getSkillCooldown() <= 0 || ability.getCurrentCooldown() <= 0 || ability.getSkillCooldown() == ability.getCurrentCooldown()) continue;
                float f = Mth.m_14036_((float)((float)ability.getCurrentCooldown() / (float)ability.getSkillCooldown()), (float)0.0f, (float)1.0f);
                int boxX = posX + x * sizeX + 3;
                int boxY = posY + 1;
                int offset = 16 - (16 - (int)(f * 16.0f));
                int color = new Color(0.15f, 0.15f, 0.15f, 0.75f).getRGB();
                int fColor = errorTicks > 0 ? new Color(1.0f, 0.0f, 0.0f, 0.75f).getRGB() : color;
                guiGraphics.m_280509_(boxX, boxY, boxX + 16, boxY + offset, fColor);
            }
            guiGraphics.m_280398_(VANILLA_WIDGETS, posX + sizeX * handler.getMagicData().getSelectedAbilitySlot() - 1, posY - 3, 2, 0.0f, 22.0f, 24, 24, 256, 256);
            int maxMana = ManaHandler.getMaxMana((Player)localPlayer);
            int curMana = ManaHandler.getCurrentMana((Player)localPlayer);
            int manaX = i1;
            int manaY = height - sizeY;
            manaX += manabarXOffset.intValue();
            manaY += manabarYOffset.intValue();
            int i = 0;
            while ((double)i < 1.0 + Math.ceil((double)maxMana / 10.0)) {
                for (int x = 0; x < 10; ++x) {
                    int condiXPos;
                    int manaSlot = i * 10 + x;
                    if (manaSlot >= maxMana) continue;
                    boolean goodCondi = ManaHandler.isPlayerInGoodConditions((Player)localPlayer);
                    int n = DragonUtils.isDragonType(handler, (AbstractDragonType)DragonTypes.SEA) ? 0 : (condiXPos = DragonUtils.isDragonType(handler, (AbstractDragonType)DragonTypes.FOREST) ? 18 : 36);
                    int xPos = curMana <= manaSlot ? (goodCondi ? condiXPos + 72 : 54) : (DragonUtils.isDragonType(handler, (AbstractDragonType)DragonTypes.SEA) ? 0 : (DragonUtils.isDragonType(handler, (AbstractDragonType)DragonTypes.FOREST) ? 18 : 36));
                    float rescale = 2.15f;
                    guiGraphics.m_280163_(widgetTextures, manaX + x * (int)(18.0f / rescale), manaY - 12 - i * ((int)(18.0f / rescale) + 1), (float)xPos / rescale, 204.0f / rescale, (int)(18.0f / rescale), (int)(18.0f / rescale), (int)(256.0f / rescale), (int)(256.0f / rescale));
                }
                ++i;
            }
        }
        ActiveDragonAbility ability = handler.getMagicData().getAbilityFromSlot(handler.getMagicData().getSelectedAbilitySlot());
        int currentCastTime = -1;
        int skillCastTime = -1;
        if (ability instanceof ChargeCastAbility) {
            ChargeCastAbility chargeAbility = (ChargeCastAbility)ability;
            currentCastTime = chargeAbility.getCastTime();
            skillCastTime = chargeAbility.getSkillCastingTime();
        } else if (ability instanceof ChannelingCastAbility) {
            ChannelingCastAbility channelAbility = (ChannelingCastAbility)ability;
            currentCastTime = channelAbility.getChargeTime();
            skillCastTime = channelAbility.getSkillChargeTime();
        }
        if (handler.getMagicData().isCasting && currentCastTime > 0 && skillCastTime != -1) {
            int yPos1;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.0f);
            int n = DragonUtils.isDragonType(handler, (AbstractDragonType)DragonTypes.CAVE) ? 0 : (yPos1 = DragonUtils.isDragonType(handler, (AbstractDragonType)DragonTypes.FOREST) ? 47 : 94);
            int yPos2 = DragonUtils.isDragonType(handler, (AbstractDragonType)DragonTypes.CAVE) ? 142 : (DragonUtils.isDragonType(handler, (AbstractDragonType)DragonTypes.FOREST) ? 147 : 152);
            float perc = Math.min((float)currentCastTime / (float)skillCastTime, 1.0f);
            int startX = width / 2 - 49 + castbarXOffset;
            int startY = height - 96 + castbarYOffset;
            guiGraphics.m_280168_().m_252880_((float)startX, (float)startY, 0.0f);
            guiGraphics.m_280163_(castBars, startX, startY, 0.0f, (float)yPos1, 196, 47, 256, 256);
            guiGraphics.m_280163_(castBars, startX + 2, startY + 41, 0.0f, (float)yPos2, (int)(191.0f * perc), 4, 256, 256);
            guiGraphics.m_280163_(ability.getIcon(), startX + 78, startY + 3, 0.0f, 0.0f, 36, 36, 36, 36);
            guiGraphics.m_280168_().m_85849_();
        }
        if (errorTicks > 0) {
            guiGraphics.m_280648_(Minecraft.m_91087_().f_91062_, errorMessage.m_7532_(), (int)((float)width / 2.0f - (float)Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)errorMessage) / 2.0f), height - 70, 0);
            if (--errorTicks <= 0) {
                errorMessage = Component.m_237119_();
            }
        }
    }
}

