/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.handlers.magic;

import by.dragonsurvivalteam.dragonsurvival.client.particles.CaveDragon.SmallFireParticleData;
import by.dragonsurvivalteam.dragonsurvival.client.particles.ForestDragon.SmallPoisonParticleData;
import by.dragonsurvivalteam.dragonsurvival.client.particles.SeaDragon.LargeLightningParticleData;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ActiveDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ChargeCastAbility;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientMagicHandler {
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="particles_on_dragons", comment={"Particles (from the dragon type effects) will be rendered on dragons if this is enabled"})
    public static Boolean particlesOnDragons = false;

    @SubscribeEvent
    public static void onFovEvent(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
            ChargeCastAbility chargeCastAbility;
            if (Arrays.stream(cap.getEmoteData().currentEmotes).anyMatch(Objects::nonNull) && DragonUtils.isDragon((Entity)player)) {
                event.setNewFovModifier(1.0f);
                return;
            }
            ActiveDragonAbility ability = cap.getMagicData().getCurrentlyCasting();
            if (ability instanceof ChargeCastAbility && (chargeCastAbility = (ChargeCastAbility)ability).getCastTime() > 0) {
                double perc = Math.min((float)chargeCastAbility.getCastTime() / (float)chargeCastAbility.getSkillCastingTime(), 1.0f) / 4.0f;
                double c4 = 2.0943951023931953;
                if (perc != 0.0 && perc != 1.0) {
                    perc = Math.pow(2.0, -10.0 * perc) * Math.sin((perc * 10.0 - 0.75) * c4) + 1.0;
                }
                float newFov = (float)Mth.m_14008_((double)perc, (double)1.0, (double)1.0);
                event.setNewFovModifier(newFov);
            }
        });
    }

    @SubscribeEvent
    public static void livingTick(LivingEvent.LivingTickEvent event) {
        int i;
        Object data;
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().m_5776_()) {
            return;
        }
        if (!particlesOnDragons.booleanValue() && DragonUtils.isDragon((Entity)entity)) {
            return;
        }
        if (entity.m_21023_(DragonEffects.BURN)) {
            data = new SmallFireParticleData(37.0f, false);
            for (i = 0; i < 4; ++i) {
                ClientMagicHandler.renderEffectParticle(entity, data);
            }
        }
        if (entity.m_21023_(DragonEffects.DRAIN)) {
            data = new SmallPoisonParticleData(37.0f, false);
            for (i = 0; i < 4; ++i) {
                ClientMagicHandler.renderEffectParticle(entity, data);
            }
        }
        if (entity.m_21023_(DragonEffects.CHARGED)) {
            data = new LargeLightningParticleData(37.0f, false);
            for (i = 0; i < 4; ++i) {
                ClientMagicHandler.renderEffectParticle(entity, data);
            }
        }
    }

    public static void renderEffectParticle(LivingEntity entity, ParticleOptions particle) {
        Player localPlayer = ClientProxy.getLocalPlayer();
        if (localPlayer != null) {
            double d0 = (double)entity.m_217043_().m_188501_() * (double)entity.m_20205_();
            double d1 = (double)entity.m_217043_().m_188501_() * (double)entity.m_20206_();
            double d2 = (double)entity.m_217043_().m_188501_() * (double)entity.m_20205_();
            double x = entity.m_20185_() + d0 - (double)(entity.m_20205_() / 2.0f);
            double y = entity.m_20186_() + d1;
            double z = entity.m_20189_() + d2 - (double)(entity.m_20205_() / 2.0f);
            localPlayer.m_9236_().m_7106_(particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

