/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.models;

import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRender;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.DragonEditorHandler;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.SkinPreset;
import by.dragonsurvivalteam.dragonsurvival.client.util.FakeClientPlayer;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.objects.DragonMovementData;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonBody;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.util.AnimationUtils;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.molang.MolangParser;
import software.bernie.geckolib.model.GeoModel;

public class DragonModel
extends GeoModel<DragonEntity> {
    private final ResourceLocation defaultTexture = new ResourceLocation("dragonsurvival", "textures/dragon/cave_newborn.png");
    private final ResourceLocation model = new ResourceLocation("dragonsurvival", "geo/dragon_model.geo.json");
    private ResourceLocation currentTexture;
    private static final double DELTA_YAW_PITCH_FACTOR = 0.2;
    private static final double DELTA_MOVEMENT_FACTOR = 10.0;

    public void applyMolangQueries(DragonEntity dragon, double currentTick) {
        double verticalVelocityAvg;
        double headPitchAvg;
        double headYawAvg;
        double bodyYawAvg;
        super.applyMolangQueries((GeoAnimatable)dragon, currentTick);
        Player player = dragon.getPlayer();
        if (player == null) {
            return;
        }
        float deltaTick = AnimationUtils.getRealtimeDeltaTicks();
        float partialTick = Minecraft.m_91087_().getPartialTick();
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        DragonMovementData md = handler.getMovementData();
        MolangParser parser = MolangParser.INSTANCE;
        parser.setValue("query.head_yaw", () -> md.headYaw);
        parser.setValue("query.head_pitch", () -> md.headPitch);
        double gravity = player.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        parser.setValue("query.gravity", () -> gravity);
        if (!ClientDragonRender.isOverridingMovementData) {
            double bodyYawChange = Functions.angleDifference(md.bodyYaw, md.bodyYawLastFrame) / (double)deltaTick * 0.2;
            double headYawChange = Functions.angleDifference(md.headYaw, md.headYawLastFrame) / (double)deltaTick * 0.2;
            double headPitchChange = Functions.angleDifference(md.headPitch, md.headPitchLastFrame) / (double)deltaTick * 0.2;
            double verticalVelocity = Mth.m_14139_((double)partialTick, (double)md.deltaMovementLastFrame.f_82480_, (double)md.deltaMovement.f_82480_) * 10.0;
            verticalVelocity *= (double)(1.0f - Mth.m_14154_((float)Mth.m_184631_((float)md.prevXRot, (float)-90.0f, (float)90.0f, (float)-1.0f, (float)1.0f)));
            float deltaTickFor60FPS = AnimationUtils.getDeltaTickFor60FPS();
            while ((float)dragon.bodyYawHistory.size() > 10.0f / deltaTickFor60FPS) {
                dragon.bodyYawHistory.remove(0);
            }
            dragon.bodyYawHistory.add(bodyYawChange);
            while ((float)dragon.headYawHistory.size() > 10.0f / deltaTickFor60FPS) {
                dragon.headYawHistory.remove(0);
            }
            dragon.headYawHistory.add(headYawChange);
            while ((float)dragon.headPitchHistory.size() > 10.0f / deltaTickFor60FPS) {
                dragon.headPitchHistory.remove(0);
            }
            dragon.headPitchHistory.add(headPitchChange);
            if (dragon.clearVerticalVelocity) {
                dragon.verticalVelocityHistory.clear();
                while ((float)dragon.verticalVelocityHistory.size() < 10.0f / deltaTickFor60FPS) {
                    dragon.verticalVelocityHistory.add(0.0);
                }
            }
            while ((float)dragon.verticalVelocityHistory.size() > 10.0f / deltaTickFor60FPS) {
                dragon.verticalVelocityHistory.remove(0);
            }
            dragon.verticalVelocityHistory.add(verticalVelocity);
            bodyYawAvg = dragon.bodyYawHistory.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
            headYawAvg = dragon.headYawHistory.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
            headPitchAvg = dragon.headPitchHistory.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
            verticalVelocityAvg = dragon.verticalVelocityHistory.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
        } else {
            bodyYawAvg = 0.0;
            headYawAvg = 0.0;
            headPitchAvg = 0.0;
            verticalVelocityAvg = 0.0;
        }
        bodyYawAvg = Double.isNaN(bodyYawAvg) ? 0.0 : bodyYawAvg;
        headYawAvg = Double.isNaN(headYawAvg) ? 0.0 : headYawAvg;
        headPitchAvg = Double.isNaN(headPitchAvg) ? 0.0 : headPitchAvg;
        verticalVelocityAvg = Double.isNaN(verticalVelocityAvg) ? 0.0 : verticalVelocityAvg;
        double lerpRate = Math.min(1.0, (double)deltaTick);
        dragon.currentBodyYawChange = Mth.m_14139_((double)lerpRate, (double)dragon.currentBodyYawChange, (double)bodyYawAvg);
        dragon.currentHeadYawChange = Mth.m_14139_((double)lerpRate, (double)dragon.currentHeadYawChange, (double)headYawAvg);
        dragon.currentHeadPitchChange = Mth.m_14139_((double)lerpRate, (double)dragon.currentHeadPitchChange, (double)headPitchAvg);
        if (dragon.clearVerticalVelocity) {
            dragon.currentTailMotionUp = 0.0;
            dragon.clearVerticalVelocity = false;
        } else {
            dragon.currentTailMotionUp = Mth.m_14139_((double)lerpRate, (double)dragon.currentTailMotionUp, (double)(-verticalVelocityAvg));
        }
        double finalBodyYawAvg = bodyYawAvg;
        double finalHeadYawAvg = headYawAvg;
        double finalHeadPitchAvg = headPitchAvg;
        double finalVerticalVelocityAvg = verticalVelocityAvg;
        parser.setValue("query.body_yaw_change", () -> Mth.m_14139_((double)lerpRate, (double)dragon.currentBodyYawChange, (double)finalBodyYawAvg));
        parser.setValue("query.head_yaw_change", () -> Mth.m_14139_((double)lerpRate, (double)dragon.currentHeadPitchChange, (double)finalHeadYawAvg));
        parser.setValue("query.head_pitch_change", () -> Mth.m_14139_((double)lerpRate, (double)dragon.currentHeadYawChange, (double)finalHeadPitchAvg));
        parser.setValue("query.tail_motion_up", () -> Mth.m_14139_((double)lerpRate, (double)dragon.currentTailMotionUp, (double)(-finalVerticalVelocityAvg)));
    }

    public ResourceLocation getModelResource(DragonEntity dragon) {
        return this.model;
    }

    public ResourceLocation getTextureResource(DragonEntity dragon) {
        LocalPlayer localPlayer;
        if (dragon.playerId != null || dragon.getPlayer() != null) {
            DragonStateHandler handler = DragonUtils.getHandler((Entity)dragon.getPlayer());
            SkinPreset.SkinAgeGroup ageGroup = (SkinPreset.SkinAgeGroup)handler.getSkinData().skinPreset.skinAges.get((Object)handler.getLevel()).get();
            if (handler.getSkinData().recompileSkin) {
                DragonEditorHandler.generateSkinTextures(dragon);
            }
            if (handler.getSkinData().blankSkin) {
                return new ResourceLocation("dragonsurvival", "textures/dragon/blank_skin_" + handler.getTypeNameLowerCase() + ".png");
            }
            if (ageGroup.defaultSkin) {
                if (this.currentTexture != null) {
                    return this.currentTexture;
                }
                return new ResourceLocation("dragonsurvival", "textures/dragon/" + handler.getTypeNameLowerCase() + "_" + handler.getLevel().name.toLowerCase(Locale.ENGLISH) + ".png");
            }
            if (handler.getSkinData().isCompiled && this.currentTexture == null) {
                return new ResourceLocation("dragonsurvival", "dynamic_normal_" + dragon.getPlayer().m_20149_() + "_" + handler.getLevel().name);
            }
        }
        if (this.currentTexture == null && dragon.getPlayer() instanceof FakeClientPlayer && (localPlayer = Minecraft.m_91087_().f_91074_) != null) {
            return new ResourceLocation("dragonsurvival", "dynamic_normal_" + localPlayer.m_20149_() + "_" + DragonUtils.getHandler((Entity)dragon.getPlayer()).getLevel().name);
        }
        return this.currentTexture == null ? this.defaultTexture : this.currentTexture;
    }

    public void setCurrentTexture(ResourceLocation currentTexture) {
        this.currentTexture = currentTexture;
    }

    public ResourceLocation getAnimationResource(DragonEntity dragon) {
        DragonStateHandler handler;
        AbstractDragonBody body;
        if ((dragon.playerId != null || dragon.getPlayer() != null) && (body = (handler = DragonUtils.getHandler((Entity)dragon.getPlayer())).getBody()) != null) {
            return new ResourceLocation("dragonsurvival", String.format("animations/dragon_%s.json", body.getBodyName().toLowerCase(Locale.ENGLISH)));
        }
        return new ResourceLocation("dragonsurvival", "animations/dragon.animations.json");
    }

    public RenderType getRenderType(DragonEntity animatable, ResourceLocation texture) {
        return RenderType.m_110452_((ResourceLocation)texture);
    }
}

