/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.particles.CaveDragon;

import by.dragonsurvivalteam.dragonsurvival.client.particles.DSParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class SmallFireParticleData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<SmallFireParticleData> DESERIALIZER = new ParticleOptions.Deserializer<SmallFireParticleData>(){

        public SmallFireParticleData fromCommand(ParticleType<SmallFireParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float duration = (float)reader.readDouble();
            reader.expect(' ');
            boolean swirls = reader.readBoolean();
            return new SmallFireParticleData(duration, swirls);
        }

        public SmallFireParticleData fromNetwork(ParticleType<SmallFireParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new SmallFireParticleData(buffer.readFloat(), buffer.readBoolean());
        }
    };
    private final float duration;
    private final boolean swirls;

    public static Codec<SmallFireParticleData> CODEC(ParticleType<SmallFireParticleData> particleType) {
        return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("duration").forGetter(SmallFireParticleData::getDuration), (App)Codec.BOOL.fieldOf("swirls").forGetter(SmallFireParticleData::getSwirls)).apply((Applicative)codecBuilder, SmallFireParticleData::new));
    }

    public SmallFireParticleData(float duration, boolean spins) {
        this.duration = duration;
        this.swirls = spins;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getDuration() {
        return this.duration;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean getSwirls() {
        return this.swirls;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.duration);
        buffer.writeBoolean(this.swirls);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %b", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.duration), this.swirls);
    }

    public ParticleType<SmallFireParticleData> m_6012_() {
        return (ParticleType)DSParticles.FIRE.get();
    }
}

