/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.particles.SeaDragon;

import by.dragonsurvivalteam.dragonsurvival.client.particles.DSParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class LargeLightningParticleData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<LargeLightningParticleData> DESERIALIZER = new ParticleOptions.Deserializer<LargeLightningParticleData>(){

        public LargeLightningParticleData fromCommand(ParticleType<LargeLightningParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float duration = (float)reader.readDouble();
            reader.expect(' ');
            boolean swirls = reader.readBoolean();
            return new LargeLightningParticleData(duration, swirls);
        }

        public LargeLightningParticleData fromNetwork(ParticleType<LargeLightningParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new LargeLightningParticleData(buffer.readFloat(), buffer.readBoolean());
        }
    };
    private final float duration;
    private final boolean swirls;

    public static Codec<LargeLightningParticleData> CODEC(ParticleType<LargeLightningParticleData> particleType) {
        return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("duration").forGetter(LargeLightningParticleData::getDuration), (App)Codec.BOOL.fieldOf("swirls").forGetter(LargeLightningParticleData::getSwirls)).apply((Applicative)codecBuilder, LargeLightningParticleData::new));
    }

    public LargeLightningParticleData(float duration, boolean spins) {
        this.duration = duration;
        this.swirls = spins;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getDuration() {
        return this.duration;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean getSwirls() {
        return this.swirls;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.duration);
        buffer.writeBoolean(this.swirls);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %b", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.duration), this.swirls);
    }

    public ParticleType<LargeLightningParticleData> m_6012_() {
        return (ParticleType)DSParticles.LARGE_LIGHTNING.get();
    }
}

