/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvivalMod;
import by.dragonsurvivalteam.dragonsurvival.client.handlers.ClientEvents;
import by.dragonsurvivalteam.dragonsurvival.client.handlers.Keybind;
import by.dragonsurvivalteam.dragonsurvival.client.models.DragonArmorModel;
import by.dragonsurvivalteam.dragonsurvival.client.models.DragonModel;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonArmorRenderLayer;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.skins.DragonSkins;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.capability.objects.DragonMovementData;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonSizeHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ClientConfig;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.magic.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.BreathAbility;
import by.dragonsurvivalteam.dragonsurvival.mixins.AccessorEntityRenderer;
import by.dragonsurvivalteam.dragonsurvival.mixins.AccessorEntityRendererManager;
import by.dragonsurvivalteam.dragonsurvival.mixins.AccessorLivingRenderer;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncDeltaMovement;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncDragonMovement;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.ServerFlightHandler;
import by.dragonsurvivalteam.dragonsurvival.util.AnimationUtils;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ParrotOnShoulderLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import software.bernie.geckolib.core.object.Color;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientDragonRender {
    public static DragonModel dragonModel = new DragonModel();
    public static DragonArmorModel dragonArmorModel = new DragonArmorModel(dragonModel);
    public static boolean isOverridingMovementData = false;
    public static DragonEntity dragonArmor;
    public static DragonEntity dummyDragon;
    public static ConcurrentHashMap<Integer, AtomicReference<DragonEntity>> playerDragonHashMap;
    @ConfigOption(side=ConfigSide.CLIENT, category={"firstperson"}, key="renderFirstPerson", comment={"Render dragon model in first person. If your own tail scares you, write false"})
    public static Boolean renderInFirstPerson;
    @ConfigOption(side=ConfigSide.CLIENT, category={"firstperson"}, key="renderFirstPersonFlight", comment={"Render dragon model in first person while gliding. We don't advise you to turn it on."})
    public static Boolean renderFirstPersonFlight;
    @ConfigOption(side=ConfigSide.CLIENT, category={"firstperson"}, key="firstPersonRotation", comment={"Use rotation of your tail in first person, otherwise the tail is always opposite of your camera. If the tail is constantly climbing in your face, put false."})
    public static Boolean firstPersonRotation;
    @ConfigOption(side=ConfigSide.CLIENT, category={"flight"}, key="renderOtherPlayerRotation", comment={"Should the rotation effect during gliding of other players be shown?"})
    public static Boolean renderOtherPlayerRotation;
    @ConfigOption(side=ConfigSide.CLIENT, category={"inventory"}, key="alternateHeldItem", comment={"Should held items be rendered as if you are in third-person even in first person as a dragon?"})
    public static Boolean alternateHeldItem;
    @ConfigOption(side=ConfigSide.CLIENT, category={"inventory"}, key="thirdPersonItemRender", comment={"Should the third person item render for dragons use the default rotations? Use this if modded items are rendering weird when held."})
    public static Boolean thirdPersonItemRender;
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="renderItemsInMouth", comment={"Should items be rendered near the mouth of dragons rather then hovering by their side?"})
    public static Boolean renderItemsInMouth;
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="renderDragonClaws", comment={"Should the tools on the claws and teeth be rendered for your dragon?"})
    public static Boolean renderDragonClaws;
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="renderNewbornSkin", comment={"Do you want your dragon skin to be rendered as a newborn dragon?"})
    public static Boolean renderNewbornSkin;
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="renderYoungSkin", comment={"Do you want your dragon skin to be rendered as a young dragon?"})
    public static Boolean renderYoungSkin;
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="renderAdultSkin", comment={"Do you want your dragon skin to be rendered as a adult dragon?"})
    public static Boolean renderAdultSkin;
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="renderOtherPlayerSkins", comment={"Should other player skins be rendered?"})
    public static Boolean renderOtherPlayerSkins;
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="armorRenderLayer", comment={"Should the armor be rendered as a layer on the dragon? Some shaders requires this to be off. Can cause some weird effects with armor when turned off."})
    public static Boolean armorRenderLayer;
    @ConfigOption(side=ConfigSide.CLIENT, category={"nametag"}, key="dragonNameTags", comment={"Show name tags for dragons."})
    public static Boolean dragonNameTags;
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="rotateBodyWithCamera", comment={"Should the body rotate with the camera when turning around."})
    public static Boolean rotateBodyWithCamera;
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="rotateCameraWithDragon", comment={"Should the player rotate their view when the dragon they are riding rotates their body?"})
    public static Boolean rotateCameraWithDragon;
    private static boolean wasFreeLook;
    private static final int MAX_DELAY = 10;
    private static int renderDelay;

    @SubscribeEvent
    public static void cancelNameplatesFromDummyEntities(RenderNameTagEvent event) {
        Entity entity = event.getEntity();
        if (entity.m_6095_() == DSEntities.DRAGON.get() || entity.m_6095_() == DSEntities.DRAGON_ARMOR.get()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void renderFirstPerson(RenderHandEvent renderHandEvent) {
        if (renderInFirstPerson.booleanValue()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            DragonStateProvider.getCap((Entity)player).ifPresent(playerStateHandler -> {
                if (playerStateHandler.isDragon() && alternateHeldItem.booleanValue()) {
                    renderHandEvent.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void renderBreathHitBox(RenderLevelStageEvent event) {
        if (ClientConfig.renderBreathRange.booleanValue() && event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS && Minecraft.m_91087_().m_91290_().m_114377_()) {
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            DragonStateHandler handler = DragonUtils.getHandler((Entity)localPlayer);
            if (localPlayer == null || !handler.isDragon()) {
                return;
            }
            VertexConsumer buffer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_);
            Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            poseStack.m_85837_(-camera.m_7096_(), -camera.m_7098_(), -camera.m_7094_());
            int range = BreathAbility.calculateCurrentBreathRange(handler.getSize());
            AbstractDragonType dragonType = handler.getType();
            boolean red = DragonUtils.isDragonType(dragonType, (AbstractDragonType)DragonTypes.CAVE);
            boolean green = DragonUtils.isDragonType(dragonType, (AbstractDragonType)DragonTypes.FOREST);
            boolean blue = DragonUtils.isDragonType(dragonType, (AbstractDragonType)DragonTypes.SEA);
            LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer, (AABB)DragonAbilities.calculateBreathArea((Player)localPlayer, handler, range), (float)((float)red), (float)((float)green), (float)((float)blue), (float)1.0f);
            poseStack.m_85849_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @SubscribeEvent
    public static void thirdPersonPreRender(RenderPlayerEvent.Pre renderPlayerEvent) {
        var2_1 = renderPlayerEvent.getEntity();
        if (!(var2_1 instanceof AbstractClientPlayer)) {
            return;
        }
        player = (AbstractClientPlayer)var2_1;
        minecraft = Minecraft.m_91087_();
        handler = DragonUtils.getHandler((Entity)player);
        if (!ClientDragonRender.playerDragonHashMap.containsKey(player.m_19879_())) {
            dummyDragon = (DragonEntity)((EntityType)DSEntities.DRAGON.get()).m_20615_(player.m_9236_());
            dummyDragon.playerId = player.m_19879_();
            ClientDragonRender.playerDragonHashMap.put(player.m_19879_(), new AtomicReference<DragonEntity>(dummyDragon));
        }
        if (ClientDragonRender.dragonArmor == null) {
            ClientDragonRender.dragonArmor = (DragonEntity)((EntityType)DSEntities.DRAGON_ARMOR.get()).m_20615_(player.m_9236_());
            if (!ClientDragonRender.$assertionsDisabled && ClientDragonRender.dragonArmor == null) {
                throw new AssertionError();
            }
            ClientDragonRender.dragonArmor.playerId = player.m_19879_();
        }
        if (ClientDragonRender.dummyDragon == null) {
            ClientDragonRender.dummyDragon = (DragonEntity)((EntityType)DSEntities.DRAGON.get()).m_20615_(player.m_9236_());
            if (!ClientDragonRender.$assertionsDisabled && ClientDragonRender.dummyDragon == null) {
                throw new AssertionError();
            }
            ClientDragonRender.dummyDragon.playerId = player.m_19879_();
        }
        if (handler.isDragon()) {
            if (player == ClientProxy.getLocalPlayer()) {
                ClientDragonRender.renderDelay = 10;
            }
            renderPlayerEvent.setCanceled(true);
            ClientDragonRender.setDragonMovementData((Player)player, AnimationUtils.getRealtimeDeltaTicks());
            partialRenderTick = renderPlayerEvent.getPartialTick();
            yaw = player.m_5675_(partialRenderTick);
            dragonStage = handler.getLevel();
            texture = DragonSkins.getPlayerSkin((Player)player, handler.getType(), dragonStage);
            poseStack = renderPlayerEvent.getPoseStack();
            try {
                poseStack.m_85836_();
                lookVector = Functions.getDragonCameraOffset((Entity)player);
                poseStack.m_252880_(-lookVector.x(), lookVector.y(), -lookVector.z());
                size = handler.getSize();
                playerModelType = player.m_108564_();
                playerRenderer = ((AccessorEntityRendererManager)minecraft.m_91290_()).getPlayerRenderers().get(playerModelType);
                eventLight = renderPlayerEvent.getPackedLight();
                renderTypeBuffer = renderPlayerEvent.getMultiBufferSource();
                if (ClientDragonRender.dragonNameTags.booleanValue() && player != ClientProxy.getLocalPlayer()) {
                    renderNameplateEvent = new RenderNameTagEvent((Entity)player, player.m_5446_(), playerRenderer, poseStack, renderTypeBuffer, eventLight, partialRenderTick);
                    MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
                    if (renderNameplateEvent.getResult() != Event.Result.DENY && (renderNameplateEvent.getResult() == Event.Result.ALLOW || ((AccessorLivingRenderer)playerRenderer).dragonsurvival$callShouldShowName((LivingEntity)player))) {
                        ((AccessorEntityRenderer)playerRenderer).callRenderNameTag((Entity)player, renderNameplateEvent.getContent(), poseStack, renderTypeBuffer, eventLight);
                    }
                }
                poseStack.m_252781_(Axis.f_252392_.m_252977_((float)handler.getMovementData().bodyYaw));
                scale = (float)Math.max(size / 40.0, 0.4);
                poseStack.m_85841_(scale, scale, scale);
                ((AccessorEntityRenderer)renderPlayerEvent.getRenderer()).setShadowRadius((float)((3.0 * size + 62.0) / 260.0));
                dummyDragon = ClientDragonRender.playerDragonHashMap.get(player.m_19879_()).get();
                dragonRenderer = minecraft.m_91290_().m_114382_((Entity)dummyDragon);
                ClientDragonRender.dragonModel.setCurrentTexture(texture);
                if (player.m_6047_() && handler.isWingsSpread() && !player.m_20096_()) {
                    poseStack.m_85837_(0.0, -0.15, 0.0);
                } else if (player.m_6047_()) {
                    if (size > ServerConfig.DEFAULT_MAX_GROWTH_SIZE) {
                        poseStack.m_85837_(0.0, 0.045, 0.0);
                    } else {
                        poseStack.m_85837_(0.0, 0.325 - size / (double)DragonLevel.ADULT.size * 0.14, 0.0);
                    }
                } else if (player.m_6069_() || player.m_21209_() || handler.isWingsSpread() && !player.m_20096_() && !player.m_20069_() && !player.m_20077_()) {
                    if (size > ServerConfig.DEFAULT_MAX_GROWTH_SIZE) {
                        poseStack.m_85837_(0.0, -0.55, 0.0);
                    } else {
                        poseStack.m_85837_(0.0, -0.15 - size / (double)DragonLevel.ADULT.size * 0.2, 0.0);
                    }
                }
                if (!player.m_20145_()) {
                    if (ServerFlightHandler.isGliding((Player)player) || player.m_20159_() && DragonUtils.isDragon(player.m_20202_()) && ServerFlightHandler.isGliding((Player)player.m_20202_())) {
                        if (ClientDragonRender.renderOtherPlayerRotation.booleanValue() || minecraft.f_91074_ == player) {
                            upRot = 0.0f;
                            upRot = ServerFlightHandler.isGliding((Player)player) != false ? Mth.m_14036_((float)((float)(player.m_20184_().f_82480_ * 20.0)), (float)-80.0f, (float)80.0f) : Mth.m_14036_((float)((float)(player.m_20202_().m_20184_().f_82480_ * 20.0)), (float)-80.0f, (float)80.0f);
                            dummyDragon.prevXRot = Mth.m_14179_((float)0.1f, (float)dummyDragon.prevXRot, (float)upRot);
                            handler.getMovementData().prevXRot = dummyDragon.prevXRot = Mth.m_14036_((float)dummyDragon.prevXRot, (float)-80.0f, (float)80.0f);
                            if (Float.isNaN(dummyDragon.prevXRot)) {
                                dummyDragon.prevXRot = upRot;
                            }
                            if (Float.isNaN(dummyDragon.prevXRot)) {
                                dummyDragon.prevXRot = 0.0f;
                            }
                            poseStack.m_252781_(Axis.f_252495_.m_252977_(dummyDragon.prevXRot));
                            vector3d1 = new Vec3(0.0, 0.0, 0.0);
                            vector3d = new Vec3(0.0, 0.0, 0.0);
                            if (ServerFlightHandler.isGliding((Player)player)) {
                                vector3d1 = player.m_20184_();
                                vector3d = player.m_20252_(1.0f);
                            } else {
                                vector3d1 = player.m_20202_().m_20184_();
                                vector3d = player.m_20202_().m_20252_(1.0f);
                            }
                            d0 = vector3d1.m_165925_();
                            d1 = vector3d.m_165925_();
                            d2 = (vector3d1.f_82479_ * vector3d.f_82479_ + vector3d1.f_82481_ * vector3d.f_82481_) / Math.sqrt(d0 * d1);
                            d3 = vector3d1.f_82479_ * vector3d.f_82481_ - vector3d1.f_82481_ * vector3d.f_82479_;
                            rot = Mth.m_14036_((float)((float)(Math.signum(d3) * Math.acos(d2)) * 2.0f), (float)-1.0f, (float)1.0f);
                            handler.getMovementData().prevZRot = dummyDragon.prevZRot = Mth.m_14179_((float)0.1f, (float)dummyDragon.prevZRot, (float)rot);
                            dummyDragon.prevZRot = Mth.m_14036_((float)dummyDragon.prevZRot, (float)-1.0f, (float)1.0f);
                            if (Float.isNaN(dummyDragon.prevZRot)) {
                                dummyDragon.prevZRot = rot;
                            }
                            if (Float.isNaN(dummyDragon.prevZRot)) {
                                dummyDragon.prevZRot = 0.0f;
                            }
                            handler.getMovementData().prevXRot = dummyDragon.prevXRot;
                            handler.getMovementData().prevZRot = rot;
                            poseStack.m_252781_(Axis.f_252403_.m_252961_(dummyDragon.prevZRot));
                        }
                    } else {
                        handler.getMovementData().prevZRot = 0.0f;
                        handler.getMovementData().prevXRot = 0.0f;
                    }
                    if (player != minecraft.f_91074_ || !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() || !ServerFlightHandler.isGliding((Player)player) || ClientDragonRender.renderFirstPersonFlight.booleanValue()) {
                        dragonRenderer.m_7392_((Entity)dummyDragon, yaw, partialRenderTick, poseStack, renderTypeBuffer, eventLight);
                        if (!ClientDragonRender.armorRenderLayer.booleanValue()) {
                            helmet = player.m_6844_(EquipmentSlot.HEAD);
                            chestPlate = player.m_6844_(EquipmentSlot.CHEST);
                            legs = player.m_6844_(EquipmentSlot.LEGS);
                            boots = player.m_6844_(EquipmentSlot.FEET);
                            helmetTexture = new ResourceLocation("dragonsurvival", DragonArmorRenderLayer.constructArmorTexture((Player)player, EquipmentSlot.HEAD));
                            chestPlateTexture = new ResourceLocation("dragonsurvival", DragonArmorRenderLayer.constructArmorTexture((Player)player, EquipmentSlot.CHEST));
                            legsTexture = new ResourceLocation("dragonsurvival", DragonArmorRenderLayer.constructArmorTexture((Player)player, EquipmentSlot.LEGS));
                            bootsTexture = new ResourceLocation("dragonsurvival", DragonArmorRenderLayer.constructArmorTexture((Player)player, EquipmentSlot.FEET));
                            ClientDragonRender.renderArmorPiece(helmet, poseStack, renderTypeBuffer, yaw, eventLight, dummyDragon, partialRenderTick, helmetTexture);
                            ClientDragonRender.renderArmorPiece(chestPlate, poseStack, renderTypeBuffer, yaw, eventLight, dummyDragon, partialRenderTick, chestPlateTexture);
                            ClientDragonRender.renderArmorPiece(legs, poseStack, renderTypeBuffer, yaw, eventLight, dummyDragon, partialRenderTick, legsTexture);
                            ClientDragonRender.renderArmorPiece(boots, poseStack, renderTypeBuffer, yaw, eventLight, dummyDragon, partialRenderTick, bootsTexture);
                        }
                    }
                }
                if (player.m_5833_()) ** GOTO lbl143
                ((AccessorLivingRenderer)playerRenderer).dragonsurvival$getRenderLayers().stream().filter((Predicate<RenderLayer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lnet/minecraft/client/renderer/entity/layers/RenderLayer;)Z)(ParrotOnShoulderLayer.class)).findAny().ifPresent((Consumer<RenderLayer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$thirdPersonPreRender$1(com.mojang.blaze3d.vertex.PoseStack float by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler net.minecraft.client.renderer.MultiBufferSource int net.minecraft.client.player.AbstractClientPlayer float net.minecraft.client.renderer.entity.layers.RenderLayer ), (Lnet/minecraft/client/renderer/entity/layers/RenderLayer;)V)((PoseStack)poseStack, (float)scale, (DragonStateHandler)handler, (MultiBufferSource)renderTypeBuffer, (int)eventLight, (AbstractClientPlayer)player, (float)partialRenderTick));
                combinedOverlayIn = LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f);
                if (!player.m_21023_(DragonEffects.TRAPPED)) ** GOTO lbl143
                bolasScale = player.m_20192_();
                if (handler.isDragon()) {
                    bolasScale = (float)DragonSizeHandler.calculateDragonEyeHeight(handler.getSize(), ServerConfig.hitboxGrowsPastHuman);
                }
                ClientEvents.renderBolas(eventLight, combinedOverlayIn, renderTypeBuffer, poseStack, bolasScale);
            }
            catch (Throwable throwable) {
                DragonSurvivalMod.LOGGER.error("A problem occurred while rendering a dragon in third person", throwable);
            }
            finally {
                poseStack.m_85849_();
            }
        } else if (ClientDragonRender.renderDelay > 0 && player == ClientProxy.getLocalPlayer()) {
            --ClientDragonRender.renderDelay;
            renderPlayerEvent.setCanceled(true);
        } else {
            ((AccessorEntityRenderer)renderPlayerEvent.getRenderer()).setShadowRadius(0.5f);
        }
lbl143:
        // 6 sources

        ClientDragonRender.dragonModel.setCurrentTexture(null);
    }

    private static void renderArmorPiece(ItemStack stack, PoseStack matrixStackIn, MultiBufferSource bufferIn, float yaw, int packedLightIn, DragonEntity entitylivingbaseIn, float partialTicks, ResourceLocation helmetTexture) {
        Color armorColor = Color.ofRGB((float)1.0f, (float)1.0f, (float)1.0f);
        if (stack == null || stack.m_41619_()) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof DyeableArmorItem) {
            DyeableArmorItem dyeableArmorItem = (DyeableArmorItem)item;
            int colorCode = dyeableArmorItem.m_41121_(stack);
            armorColor = Color.ofOpaque((int)colorCode);
        }
        if (!stack.m_41619_()) {
            EntityRenderer dragonArmorRenderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)dragonArmor);
            dragonArmor.m_20359_((Entity)entitylivingbaseIn);
            dragonArmorModel.setArmorTexture(helmetTexture);
            Color preColor = ((DragonRenderer)dragonArmorRenderer).renderColor;
            ((DragonRenderer)dragonArmorRenderer).shouldRenderLayers = false;
            ((DragonRenderer)dragonArmorRenderer).renderColor = armorColor;
            dragonArmorRenderer.m_7392_((Entity)entitylivingbaseIn, yaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            ((DragonRenderer)dragonArmorRenderer).renderColor = preColor;
            ((DragonRenderer)dragonArmorRenderer).shouldRenderLayers = true;
        }
    }

    @SubscribeEvent
    public static void spin(InputEvent.InteractionKeyMappingTriggered keyInputEvent) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        if (!handler.isDragon()) {
            return;
        }
        if (keyInputEvent.isAttack() && keyInputEvent.shouldSwingHand() && !handler.getMovementData().dig) {
            handler.getMovementData().bite = true;
        }
    }

    public static void setDragonMovementData(Player player, float realtimeDeltaTick) {
        if (player == null) {
            return;
        }
        DragonStateProvider.getCap((Entity)player).ifPresent(playerStateHandler -> {
            if (!playerStateHandler.isDragon()) {
                return;
            }
            Vec3 moveVector = !ServerFlightHandler.isFlying((LivingEntity)player) ? player.m_20184_() : new Vec3(player.m_20185_() - player.f_19854_, player.m_20186_() - player.f_19855_, player.m_20189_() - player.f_19856_);
            BodyAngles newAngles = BodyAngles.calculateNext(player, playerStateHandler, realtimeDeltaTick);
            playerStateHandler.setMovementData(newAngles.bodyYaw, newAngles.headYaw, newAngles.headPitch, moveVector);
        });
    }

    @SubscribeEvent
    public static void updateFirstPersonDataAndSendMovementData(TickEvent.ClientTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            DragonStateProvider.getCap((Entity)player).ifPresent(playerStateHandler -> {
                if (playerStateHandler.isDragon()) {
                    Input input = player.f_108618_;
                    playerStateHandler.setFirstPerson(Minecraft.m_91087_().f_91066_.m_92176_().m_90612_());
                    playerStateHandler.setFreeLook(Keybind.FREE_LOOK.m_90857_());
                    playerStateHandler.setDesiredMoveVec(new Vec2(input.f_108566_, input.f_108567_));
                    if (player.m_20159_()) {
                        NetworkHandler.CHANNEL.sendToServer((Object)new SyncDeltaMovement(player.m_19879_(), 0.0, 0.0, 0.0));
                    } else {
                        NetworkHandler.CHANNEL.sendToServer((Object)new SyncDeltaMovement(player.m_19879_(), player.m_20184_().f_82479_, player.m_20184_().f_82480_, player.m_20184_().f_82481_));
                    }
                    DragonMovementData md = playerStateHandler.getMovementData();
                    NetworkHandler.CHANNEL.sendToServer((Object)new SyncDragonMovement(player.m_19879_(), md.isFirstPerson, md.bite, md.isFreeLook, md.desiredMoveVec.f_82470_, md.desiredMoveVec.f_82471_));
                }
            });
        }
    }

    public static Vec3 getInputVector(Vec3 movement, float fricSpeed, float yRot) {
        double d0 = movement.m_82556_();
        if (d0 < 1.0E-7) {
            return Vec3.f_82478_;
        }
        Vec3 vector3d = (d0 > 1.0 ? movement.m_82541_() : movement).m_82490_((double)fricSpeed);
        float f = Mth.m_14031_((float)(yRot * ((float)Math.PI / 180)));
        float f1 = Mth.m_14089_((float)(yRot * ((float)Math.PI / 180)));
        return new Vec3(vector3d.f_82479_ * (double)f1 - vector3d.f_82481_ * (double)f, vector3d.f_82480_, vector3d.f_82481_ * (double)f1 + vector3d.f_82479_ * (double)f);
    }

    private static /* synthetic */ void lambda$thirdPersonPreRender$1(PoseStack poseStack, float scale, DragonStateHandler handler, MultiBufferSource renderTypeBuffer, int eventLight, AbstractClientPlayer player, float partialRenderTick, RenderLayer renderLayer) {
        poseStack.m_85841_(1.0f / scale, 1.0f / scale, 1.0f / scale);
        poseStack.m_252781_(Axis.f_252495_.m_252977_(180.0f));
        double height = 1.3 * (double)scale;
        double forward = 0.3 * (double)scale;
        float parrotHeadYaw = Mth.m_14036_((float)(-1.0f * ((float)handler.getMovementData().bodyYaw - (float)handler.getMovementData().headYaw)), (float)-75.0f, (float)75.0f);
        poseStack.m_85837_(0.0, -height, -forward);
        renderLayer.m_6494_(poseStack, renderTypeBuffer, eventLight, (Entity)player, 0.0f, 0.0f, partialRenderTick, (float)player.f_19797_ + partialRenderTick, parrotHeadYaw, (float)handler.getMovementData().headPitch);
        poseStack.m_85837_(0.0, height, forward);
        poseStack.m_252781_(Axis.f_252495_.m_252977_(-180.0f));
        poseStack.m_85841_(scale, scale, scale);
    }

    static {
        playerDragonHashMap = new ConcurrentHashMap(20);
        renderInFirstPerson = true;
        renderFirstPersonFlight = false;
        firstPersonRotation = false;
        renderOtherPlayerRotation = true;
        alternateHeldItem = false;
        thirdPersonItemRender = false;
        renderItemsInMouth = false;
        renderDragonClaws = true;
        renderNewbornSkin = true;
        renderYoungSkin = true;
        renderAdultSkin = true;
        renderOtherPlayerSkins = true;
        armorRenderLayer = true;
        dragonNameTags = false;
        rotateBodyWithCamera = true;
        rotateCameraWithDragon = true;
        wasFreeLook = false;
    }

    private record BodyAngles(double bodyYaw, double headPitch, double headYaw) {
        static final double INPUT_EPSILON = 1.0E-7;
        static final double MOVE_DELTA_EPSILON = 1.0E-4;
        static final double MOVE_DELTA_FULL_EFFECT_MIN_MAG = 0.3;
        static final double MOVE_ALIGN_FACTOR = 0.3;
        static final double MOVE_ALIGN_FACTOR_AIR = 0.12;
        static final double MOVE_ALIGN_FACTOR_AIR_PASSIVE_MUL = 0.75;
        static final double BODY_ANGLE_LIMIT_TP = 150.0;
        static final double BODY_ANGLE_LIMIT_TP_SOFTNESS = 0.9;
        static final double BODY_ANGLE_LIMIT_TP_SOFTNESS_AIR_MUL = 0.15;
        static final double BODY_ANGLE_LIMIT_TP_FREE = 180.0;
        static final double BODY_ANGLE_LIMIT_TP_SOFTNESS_FREE = 0.0;
        static final double BODY_ANGLE_LIMIT_TP_SOFTNESS_AIR_MUL_FREE = 0.0;
        static final double BODY_ANGLE_LIMIT_FP = 10.0;
        static final double BODY_ANGLE_LIMIT_FP_SOFTNESS = 0.75;
        static final double BODY_ANGLE_LIMIT_FP_SOFTNESS_AIR_MUL = 0.4;
        static final double BODY_ANGLE_LIMIT_FP_FREE = 60.0;
        static final double BODY_ANGLE_LIMIT_FP_FREE_SOFTNESS = 0.85;
        static final double BODY_ANGLE_LIMIT_FP_FREE_SOFTNESS_AIR_MUL = 0.4;
        static final double HEAD_YAW_FACTOR = 0.3;
        static final double HEAD_PITCH_FACTOR = 0.3;

        public static BodyAngles calculateNext(Player player, DragonStateHandler dragonStateHandler, float realtimeDeltaTick) {
            float viewYRot = player.m_5675_(realtimeDeltaTick);
            float viewXRot = player.m_5686_(realtimeDeltaTick);
            DragonMovementData movementData = dragonStateHandler.getMovementData();
            Vec3 posDelta = new Vec3(player.m_20185_() - player.f_19854_, player.m_20186_() - player.f_19855_, player.m_20189_() - player.f_19856_);
            Tuple<Double, Double> headAngles = BodyAngles.calculateNextHeadAngles(realtimeDeltaTick, movementData, viewXRot, viewYRot);
            return new BodyAngles(BodyAngles.calculateNextBodyYaw(realtimeDeltaTick, player, movementData, posDelta, viewYRot), (Double)headAngles.m_14418_(), (Double)headAngles.m_14419_());
        }

        private static double calculateNextBodyYaw(float realtimeDeltaTick, Player player, DragonMovementData movementData, Vec3 posDelta, float viewYRot) {
            boolean isInputBack;
            double bodyYaw = movementData.bodyYaw;
            boolean isFreeLook = movementData.isFreeLook;
            boolean isFirstPerson = movementData.isFirstPerson;
            boolean hasPosDelta = posDelta.m_165925_() > 1.0E-8;
            Vec2 rawInput = movementData.desiredMoveVec;
            boolean hasMoveInput = (double)rawInput.m_165912_() > 9.999999999999998E-15;
            boolean bl = isInputBack = rawInput.f_82471_ < 0.0f;
            if (hasMoveInput) {
                double factor;
                boolean isFlying;
                double targetAngle = Math.toDegrees(Math.atan2(-rawInput.f_82470_, rawInput.f_82471_)) + (double)viewYRot;
                boolean bl2 = isFlying = ServerFlightHandler.isFlying((LivingEntity)player) || player.m_150110_().f_35935_;
                if (isFirstPerson && !isFreeLook && isInputBack && !isFlying) {
                    targetAngle += 180.0;
                }
                double d = factor = player.m_20096_() ? 0.3 : 0.12;
                bodyYaw = isFirstPerson ? Functions.lerpAngleAwayFrom((double)realtimeDeltaTick * factor, bodyYaw, targetAngle, viewYRot + 180.0f) : Functions.lerpYaw((double)realtimeDeltaTick * factor, bodyYaw, targetAngle);
            } else if (hasPosDelta && !player.m_20096_()) {
                double posDeltaAngle = Math.toDegrees(Math.atan2(-posDelta.f_82479_, posDelta.f_82481_));
                double factor = 0.09;
                double deltaMagFactor = Math.min(1.0, (posDelta.m_165924_() - 1.0E-4) / 0.3);
                bodyYaw = Functions.lerpYaw((double)realtimeDeltaTick * (factor *= deltaMagFactor), bodyYaw, posDeltaAngle);
            }
            double angleLimit = 0.0;
            double factor = 0.0;
            double airMul = 1.0;
            if (isFirstPerson) {
                if (isFreeLook) {
                    angleLimit = 60.0;
                    factor = 0.85;
                    airMul = 0.4;
                } else {
                    angleLimit = 10.0;
                    factor = 0.75;
                    airMul = 0.4;
                }
            } else if (isFreeLook) {
                angleLimit = 180.0;
                factor = 0.0;
                airMul = 0.0;
            } else {
                angleLimit = 150.0;
                factor = 0.9;
                airMul = 0.15;
            }
            if (!player.m_20096_()) {
                factor *= airMul;
            }
            bodyYaw = Functions.limitAngleDeltaSoft(bodyYaw, viewYRot, angleLimit, (double)realtimeDeltaTick * factor);
            return bodyYaw;
        }

        private static Tuple<Double, Double> calculateNextHeadAngles(float realtimeDeltaTick, DragonMovementData movementData, float viewXRot, float viewYRot) {
            double headYawTarget = Functions.angleDifference((double)viewYRot, movementData.bodyYaw);
            double headYaw = Functions.lerpAngleAwayFrom((double)realtimeDeltaTick * 0.3, movementData.headYaw, headYawTarget, 180.0);
            double headPitch = Mth.m_14139_((double)((double)realtimeDeltaTick * 0.3), (double)movementData.headPitch, (double)viewXRot);
            return new Tuple((Object)headPitch, (Object)headYaw);
        }
    }
}

