/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon;

import by.dragonsurvivalteam.dragonsurvival.client.handlers.ClientEvents;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class ClawsAndTeethRenderLayer
extends GeoRenderLayer<DragonEntity> {
    private final GeoEntityRenderer<DragonEntity> renderer;

    public ClawsAndTeethRenderLayer(GeoEntityRenderer<DragonEntity> renderer) {
        super(renderer);
        this.renderer = renderer;
    }

    public void render(PoseStack poseStack, DragonEntity animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        String teethTexture;
        if (!((DragonRenderer)this.renderer).shouldRenderLayers) {
            return;
        }
        if (animatable.m_21023_(MobEffects.f_19609_)) {
            return;
        }
        Player player = animatable.getPlayer();
        if (player == null) {
            return;
        }
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        if (!handler.getClawToolData().shouldRenderClaws) {
            return;
        }
        String clawTexture = this.constructClaws(player);
        if (clawTexture != null) {
            ResourceLocation texture = new ResourceLocation("dragonsurvival", clawTexture);
            ((DragonRenderer)this.renderer).isRenderLayers = true;
            this.renderToolLayer(poseStack, animatable, bakedModel, bufferSource, texture, partialTick, packedLight);
            ((DragonRenderer)this.renderer).isRenderLayers = false;
        }
        if ((teethTexture = this.constructTeethTexture(player)) != null) {
            ResourceLocation texture = new ResourceLocation("dragonsurvival", teethTexture);
            ((DragonRenderer)this.renderer).isRenderLayers = true;
            this.renderToolLayer(poseStack, animatable, bakedModel, bufferSource, texture, partialTick, packedLight);
            ((DragonRenderer)this.renderer).isRenderLayers = false;
        }
    }

    private void renderToolLayer(PoseStack poseStack, DragonEntity animatable, BakedGeoModel bakedModel, MultiBufferSource bufferSource, ResourceLocation texture, float partialTick, int packedLight) {
        RenderType type = this.renderer.getRenderType((GeoAnimatable)animatable, texture, bufferSource, partialTick);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(type);
        this.renderer.actuallyRender(poseStack, (Entity)animatable, bakedModel, type, bufferSource, vertexConsumer, true, partialTick, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public String constructClaws(Player player) {
        String texturePath = "textures/armor/";
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        ItemStack clawItem = handler.getClawToolData().getClawsInventory().m_8020_(handler.getType().slotForBonus);
        if (clawItem.m_41619_()) {
            return null;
        }
        texturePath = ClientEvents.getMaterial(texturePath, clawItem);
        return texturePath + "dragon_claws.png";
    }

    public String constructTeethTexture(Player player) {
        String texturePath = "textures/armor/";
        ItemStack swordItem = DragonUtils.getHandler((Entity)player).getClawToolData().getClawsInventory().m_8020_(0);
        if (swordItem.m_41619_()) {
            return null;
        }
        texturePath = ClientEvents.getMaterial(texturePath, swordItem);
        return texturePath + "dragon_teeth.png";
    }
}

