/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon;

import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRender;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class DragonArmorRenderLayer
extends GeoRenderLayer<DragonEntity> {
    private final GeoEntityRenderer<DragonEntity> renderer;

    public DragonArmorRenderLayer(GeoEntityRenderer<DragonEntity> renderer) {
        super(renderer);
        this.renderer = renderer;
    }

    public void render(PoseStack poseStack, DragonEntity animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!ClientDragonRender.armorRenderLayer.booleanValue()) {
            return;
        }
        Player player = animatable.getPlayer();
        if (player == null || player.m_5833_()) {
            return;
        }
        CoreGeoBone neck = ClientDragonRender.dragonArmorModel.getAnimationProcessor().getBone("Neck");
        if (neck != null) {
            neck.setHidden(false);
        }
        ResourceLocation helmetTexture = new ResourceLocation("dragonsurvival", DragonArmorRenderLayer.constructArmorTexture(player, EquipmentSlot.HEAD));
        ResourceLocation chestPlateTexture = new ResourceLocation("dragonsurvival", DragonArmorRenderLayer.constructArmorTexture(player, EquipmentSlot.CHEST));
        ResourceLocation legsTexture = new ResourceLocation("dragonsurvival", DragonArmorRenderLayer.constructArmorTexture(player, EquipmentSlot.LEGS));
        ResourceLocation bootsTexture = new ResourceLocation("dragonsurvival", DragonArmorRenderLayer.constructArmorTexture(player, EquipmentSlot.FEET));
        ((DragonRenderer)this.renderer).isRenderLayers = true;
        this.renderArmorPiece(poseStack, animatable, bakedModel, bufferSource, partialTick, packedLight, player.m_6844_(EquipmentSlot.HEAD), helmetTexture);
        this.renderArmorPiece(poseStack, animatable, bakedModel, bufferSource, partialTick, packedLight, player.m_6844_(EquipmentSlot.CHEST), chestPlateTexture);
        this.renderArmorPiece(poseStack, animatable, bakedModel, bufferSource, partialTick, packedLight, player.m_6844_(EquipmentSlot.LEGS), legsTexture);
        this.renderArmorPiece(poseStack, animatable, bakedModel, bufferSource, partialTick, packedLight, player.m_6844_(EquipmentSlot.FEET), bootsTexture);
        ((DragonRenderer)this.renderer).isRenderLayers = false;
    }

    private void renderArmorPiece(PoseStack poseStack, DragonEntity animatable, BakedGeoModel bakedModel, MultiBufferSource bufferSource, float partialTick, int packedLight, ItemStack stack, ResourceLocation texture) {
        if (animatable == null) {
            return;
        }
        if (stack == null || stack.m_41619_()) {
            return;
        }
        Color armorColor = new Color(1.0f, 1.0f, 1.0f);
        if (stack.m_41720_() instanceof DyeableArmorItem) {
            int colorCode = ((DyeableArmorItem)stack.m_41720_()).m_41121_(stack);
            armorColor = new Color(colorCode);
        }
        ClientDragonRender.dragonModel.setCurrentTexture(texture);
        ClientDragonRender.dragonArmor.m_20359_((Entity)animatable);
        RenderType type = this.renderer.getRenderType((GeoAnimatable)animatable, texture, bufferSource, partialTick);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(type);
        this.renderer.actuallyRender(poseStack, (Entity)animatable, bakedModel, type, bufferSource, vertexConsumer, true, partialTick, packedLight, OverlayTexture.f_118083_, (float)armorColor.getRed() / 255.0f, (float)armorColor.getGreen() / 255.0f, (float)armorColor.getBlue() / 255.0f, 1.0f);
    }

    public static String constructArmorTexture(Player playerEntity, EquipmentSlot equipmentSlot) {
        Object texture = "textures/armor/";
        Item item = playerEntity.m_6844_(equipmentSlot).m_41720_();
        Object texture2 = DragonArmorRenderLayer.itemToResLoc(item);
        if (texture2 != null) {
            texture2 = (String)texture + (String)texture2;
            if (Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation("dragonsurvival", (String)texture2)).isPresent()) {
                return texture2;
            }
        }
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            ArmorMaterial armorMaterial = armorItem.m_40401_();
            if (armorMaterial instanceof ArmorMaterials) {
                if (armorMaterial == ArmorMaterials.NETHERITE) {
                    texture = (String)texture + "netherite_";
                } else if (armorMaterial == ArmorMaterials.DIAMOND) {
                    texture = (String)texture + "diamond_";
                } else if (armorMaterial == ArmorMaterials.IRON) {
                    texture = (String)texture + "iron_";
                } else if (armorMaterial == ArmorMaterials.LEATHER) {
                    texture = (String)texture + "leather_";
                } else if (armorMaterial == ArmorMaterials.GOLD) {
                    texture = (String)texture + "gold_";
                } else if (armorMaterial == ArmorMaterials.CHAIN) {
                    texture = (String)texture + "chainmail_";
                } else if (armorMaterial == ArmorMaterials.TURTLE) {
                    texture = (String)texture + "turtle_";
                } else {
                    return (String)texture + "empty_armor.png";
                }
                texture = (String)texture + "dragon_";
                switch (equipmentSlot) {
                    case HEAD: {
                        texture = (String)texture + "helmet";
                        break;
                    }
                    case CHEST: {
                        texture = (String)texture + "chestplate";
                        break;
                    }
                    case LEGS: {
                        texture = (String)texture + "leggings";
                        break;
                    }
                    case FEET: {
                        texture = (String)texture + "boots";
                    }
                }
                texture = (String)texture + ".png";
                return DragonArmorRenderLayer.stripInvalidPathChars((String)texture);
            }
            int defense = armorItem.m_40404_();
            switch (equipmentSlot) {
                case FEET: {
                    texture = (String)texture + Mth.m_14045_((int)defense, (int)1, (int)4) + "_dragon_boots";
                    break;
                }
                case CHEST: {
                    texture = (String)texture + Mth.m_14045_((int)(defense / 2), (int)1, (int)4) + "_dragon_chestplate";
                    break;
                }
                case HEAD: {
                    texture = (String)texture + Mth.m_14045_((int)defense, (int)1, (int)4) + "_dragon_helmet";
                    break;
                }
                case LEGS: {
                    texture = (String)texture + Mth.m_14045_((int)((int)((double)defense / 1.5)), (int)1, (int)4) + "_dragon_leggings";
                }
            }
            texture = (String)texture + ".png";
            return DragonArmorRenderLayer.stripInvalidPathChars((String)texture);
        }
        return (String)texture + "empty_armor.png";
    }

    public static String itemToResLoc(Item item) {
        if (item == Items.f_41852_) {
            return null;
        }
        ResourceLocation registryName = ResourceHelper.getKey(item);
        if (registryName != null) {
            String[] reg = registryName.toString().split(":");
            String loc = reg[0] + "/" + reg[1] + ".png";
            return DragonArmorRenderLayer.stripInvalidPathChars(loc);
        }
        return null;
    }

    public static String stripInvalidPathChars(String loc) {
        loc = loc.chars().filter(ch -> ResourceLocation.m_135828_((char)((char)ch))).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        return loc;
    }
}

