/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon;

import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRender;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonArmorRenderLayer;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class DragonCuriosRenderLayer
extends GeoRenderLayer<DragonEntity> {
    private final GeoEntityRenderer<DragonEntity> renderer;

    public DragonCuriosRenderLayer(GeoEntityRenderer<DragonEntity> entityRendererIn) {
        super(entityRendererIn);
        this.renderer = entityRendererIn;
    }

    public void render(PoseStack poseStack, DragonEntity animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        ArrayList<ResourceLocation> curioTextures;
        Player player = animatable.getPlayer();
        if (player == null || player.m_5833_()) {
            return;
        }
        CoreGeoBone neck = ClientDragonRender.dragonArmorModel.getAnimationProcessor().getBone("Neck");
        if (neck != null) {
            neck.setHidden(false);
        }
        if (!(curioTextures = this.getCurioTextures(player)).isEmpty()) {
            ((DragonRenderer)this.renderer).isRenderLayers = true;
            for (ResourceLocation texture : curioTextures) {
                this.renderCurioPiece(poseStack, animatable, bakedModel, bufferSource, partialTick, packedLight, texture);
            }
            ((DragonRenderer)this.renderer).isRenderLayers = false;
        }
    }

    private void renderCurioPiece(PoseStack poseStack, DragonEntity animatable, BakedGeoModel bakedModel, MultiBufferSource bufferSource, float partialTick, int packedLight, ResourceLocation texture) {
        ClientDragonRender.dragonModel.setCurrentTexture(texture);
        ClientDragonRender.dragonArmor.m_20359_((Entity)animatable);
        RenderType type = this.renderer.getRenderType((GeoAnimatable)animatable, texture, bufferSource, partialTick);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(type);
        this.renderer.actuallyRender(poseStack, (Entity)animatable, bakedModel, type, bufferSource, vertexConsumer, true, partialTick, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private ArrayList<ResourceLocation> getCurioTextures(Player player) {
        ArrayList<ResourceLocation> resources = new ArrayList<ResourceLocation>();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.getCurios().forEach((id, stacksHandler) -> {
            IDynamicStackHandler stackHandler = stacksHandler.getStacks();
            IDynamicStackHandler cosmeticStacksHandler = stacksHandler.getCosmeticStacks();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                Object resId;
                NonNullList renderStates;
                boolean renderable;
                ItemStack stack = cosmeticStacksHandler.getStackInSlot(i);
                if (stack.m_41619_()) {
                    stack = stackHandler.getStackInSlot(i);
                }
                boolean bl = renderable = (renderStates = stacksHandler.getRenders()).size() > i && (Boolean)renderStates.get(i) != false;
                if (!renderable || (resId = DragonArmorRenderLayer.itemToResLoc(stack.m_41720_())) == null) continue;
                resId = "textures/armor/" + (String)resId;
                if (!Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation("dragonsurvival", (String)resId)).isPresent()) continue;
                resources.add(new ResourceLocation("dragonsurvival", (String)resId));
            }
        }));
        return resources;
    }
}

