/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon;

import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRender;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.LayerSettings;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.SkinPreset;
import by.dragonsurvivalteam.dragonsurvival.client.skins.DragonSkins;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class DragonGlowLayerRenderer
extends GeoRenderLayer<DragonEntity> {
    private final GeoEntityRenderer<DragonEntity> renderer;

    public DragonGlowLayerRenderer(GeoEntityRenderer<DragonEntity> renderer) {
        super(renderer);
        this.renderer = renderer;
    }

    public void render(PoseStack poseStack, DragonEntity animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        GeoEntityRenderer<DragonEntity> geoEntityRenderer = this.renderer;
        if (!(geoEntityRenderer instanceof DragonRenderer)) {
            return;
        }
        DragonRenderer dragonRenderer = (DragonRenderer)geoEntityRenderer;
        if (!dragonRenderer.shouldRenderLayers) {
            return;
        }
        if (animatable == ClientDragonRender.dragonArmor) {
            return;
        }
        Player player = animatable.getPlayer();
        if (player == null) {
            return;
        }
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        SkinPreset preset = handler.getSkinData().skinPreset;
        SkinPreset.SkinAgeGroup ageGroup = (SkinPreset.SkinAgeGroup)preset.skinAges.get((Object)handler.getLevel()).get();
        ResourceLocation glowTexture = DragonSkins.getGlowTexture(player, handler.getType(), handler.getLevel());
        if ((glowTexture == null || glowTexture.m_135815_().contains("/" + handler.getTypeNameLowerCase() + "_")) && dragonRenderer.glowTexture != null) {
            glowTexture = dragonRenderer.glowTexture;
        }
        if (glowTexture == null && ((SkinPreset.SkinAgeGroup)handler.getSkinData().skinPreset.skinAges.get((Object)((Object)handler.getLevel())).get()).defaultSkin) {
            ResourceLocation location = new ResourceLocation("dragonsurvival", "textures/dragon/" + handler.getTypeNameLowerCase() + "_" + handler.getLevel().name.toLowerCase(Locale.ENGLISH) + "_glow.png");
            if (Minecraft.m_91087_().m_91098_().m_213713_(location).isPresent()) {
                glowTexture = location;
            }
        }
        if (glowTexture != null) {
            RenderType type = RenderType.m_110488_((ResourceLocation)glowTexture);
            VertexConsumer vertexConsumer = bufferSource.m_6299_(type);
            dragonRenderer.isRenderLayers = true;
            dragonRenderer.actuallyRender(poseStack, animatable, bakedModel, type, bufferSource, vertexConsumer, true, partialTick, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            ResourceLocation dynamicGlowKey = new ResourceLocation("dragonsurvival", "dynamic_glow_" + animatable.getPlayer().m_20149_() + "_" + handler.getLevel().name);
            dragonRenderer.isRenderLayers = true;
            if (ageGroup.layerSettings.values().stream().anyMatch(layerSettings -> ((LayerSettings)layerSettings.get()).glowing)) {
                RenderType type = RenderType.m_110488_((ResourceLocation)dynamicGlowKey);
                VertexConsumer vertexConsumer = bufferSource.m_6299_(type);
                dragonRenderer.actuallyRender(poseStack, animatable, bakedModel, type, bufferSource, vertexConsumer, true, partialTick, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        dragonRenderer.isRenderLayers = false;
    }
}

