/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon;

import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRender;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.ClawsAndTeethRenderLayer;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonArmorRenderLayer;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonCuriosRenderLayer;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonGlowLayerRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.SkinPreset;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class DragonRenderer
extends GeoEntityRenderer<DragonEntity> {
    @ConfigOption(side=ConfigSide.CLIENT, key="renderHeldItem", comment={"Should items be rendered in third person for dragon players?"}, category={"rendering"})
    public static boolean renderHeldItem = true;
    public ResourceLocation glowTexture = null;
    public boolean shouldRenderLayers = true;
    public boolean isRenderLayers = false;
    public Color renderColor = Color.ofRGB((int)255, (int)255, (int)255);

    public DragonRenderer(EntityRendererProvider.Context context, GeoModel<DragonEntity> model) {
        super(context, model);
        this.getRenderLayers().add(new DragonGlowLayerRenderer(this));
        this.getRenderLayers().add(new ClawsAndTeethRenderLayer(this));
        this.getRenderLayers().add(new DragonArmorRenderLayer(this));
        if (ModList.get().isLoaded("curios")) {
            this.getRenderLayers().add(new DragonCuriosRenderLayer(this));
        }
    }

    public void preRender(PoseStack poseStack, DragonEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Minecraft.m_91087_().m_91307_().m_6180_("player_dragon");
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void postRender(PoseStack poseStack, DragonEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.postRender(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    public void actuallyRender(PoseStack poseStack, DragonEntity animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Player player = animatable.getPlayer();
        if (player == null || player.m_21023_(MobEffects.f_19609_)) {
            return;
        }
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        boolean hasWings = ((SkinPreset.SkinAgeGroup)handler.getSkinData().skinPreset.skinAges.get((Object)((Object)handler.getLevel())).get()).wings;
        if (handler.getBody() != null) {
            hasWings = hasWings || handler.getBody().canHideWings() == false;
        }
        CoreGeoBone leftWing = ClientDragonRender.dragonModel.getAnimationProcessor().getBone("WingLeft");
        CoreGeoBone rightWing = ClientDragonRender.dragonModel.getAnimationProcessor().getBone("WingRight");
        CoreGeoBone smallLeftWing = ClientDragonRender.dragonModel.getAnimationProcessor().getBone("SmallWingLeft");
        CoreGeoBone smallRightWing = ClientDragonRender.dragonModel.getAnimationProcessor().getBone("SmallWingRight");
        if (leftWing != null) {
            leftWing.setHidden(!hasWings);
        }
        if (rightWing != null) {
            rightWing.setHidden(!hasWings);
        }
        if (smallLeftWing != null) {
            smallLeftWing.setHidden(!hasWings);
        }
        if (smallRightWing != null) {
            smallRightWing.setHidden(!hasWings);
        }
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderRecursively(PoseStack poseStack, DragonEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (isReRender) {
            super.renderRecursively(poseStack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            return;
        }
        if (!this.isRenderLayers) {
            Player player = animatable.getPlayer();
            ResourceLocation currentTexture = this.m_5478_((Entity)animatable);
            VertexConsumer customBuffer = buffer;
            if (renderHeldItem && (player != Minecraft.m_91087_().f_91074_ || ClientDragonRender.alternateHeldItem.booleanValue() || !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_())) {
                if (bone.getName().equals(ClientDragonRender.renderItemsInMouth != false ? "LeftItem_jaw" : "LeftItem") && !((ItemStack)player.m_150109_().f_35976_.get(0)).m_41619_()) {
                    poseStack.m_85836_();
                    RenderUtils.prepMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
                    RenderUtils.translateAndRotateMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
                    Minecraft.m_91087_().m_91291_().m_269128_((ItemStack)player.m_150109_().f_35976_.get(0), ClientDragonRender.thirdPersonItemRender != false ? ItemDisplayContext.THIRD_PERSON_LEFT_HAND : ItemDisplayContext.GROUND, packedLight, packedOverlay, poseStack, bufferSource, player.m_9236_(), 0);
                    customBuffer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)currentTexture));
                    poseStack.m_85849_();
                }
                if (bone.getName().equals(ClientDragonRender.renderItemsInMouth != false ? "RightItem_jaw" : "RightItem") && !player.m_150109_().m_36056_().m_41619_()) {
                    poseStack.m_85836_();
                    RenderUtils.prepMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
                    RenderUtils.translateAndRotateMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
                    Minecraft.m_91087_().m_91291_().m_269128_(player.m_150109_().m_36056_(), ClientDragonRender.thirdPersonItemRender != false ? ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : ItemDisplayContext.GROUND, packedLight, packedOverlay, poseStack, bufferSource, player.m_9236_(), 0);
                    customBuffer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)currentTexture));
                    poseStack.m_85849_();
                }
            }
            poseStack.m_85836_();
            RenderUtils.prepMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
            super.renderCubesOfBone(poseStack, bone, customBuffer, packedLight, packedOverlay, red, green, blue, alpha);
            super.renderChildBones(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, customBuffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85849_();
        }
    }

    public Color getRenderColor(DragonEntity animatable, float partialTick, int packedLight) {
        return this.renderColor;
    }
}

