/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AnimationTimer {
    public static CopyOnWriteArrayList<AnimationTimer> timers = new CopyOnWriteArrayList();
    protected ConcurrentHashMap<String, Double> animationTimes = new ConcurrentHashMap();

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        for (AnimationTimer timer : timers) {
            ((ConcurrentHashMap.KeySetView)timer.animationTimes.keySet()).forEach(key -> {
                timer.animationTimes.computeIfPresent((String)key, (animation, tick) -> tick - 1.0);
                if (timer.animationTimes.get(key) <= 0.0) {
                    timer.animationTimes.remove(key);
                }
            });
            if (!timer.animationTimes.isEmpty()) continue;
            timers.remove(timer);
        }
    }

    public double getDuration(String animation) {
        return this.animationTimes.getOrDefault(animation, 0.0);
    }

    public void putAnimation(String animation, Double ticks) {
        this.putDuration(animation, ticks);
        if (!timers.contains(this)) {
            timers.add(this);
        }
    }

    protected void putDuration(String animation, Double ticks) {
        this.animationTimes.put(animation, ticks);
    }
}

