/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvivalMod;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.DragonEditorRegistry;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.EnumSkinLayer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonEditorObject;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.LayerSettings;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.SkinPreset;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class DragonEditorHandler {
    public static ResourceLocation getSkinTexture(Player player, EnumSkinLayer layer, String key, AbstractDragonType type) {
        DragonEditorObject.Texture[] texts;
        if (Objects.equals(layer.name, "Extra") && layer != EnumSkinLayer.EXTRA) {
            return DragonEditorHandler.getSkinTexture(player, EnumSkinLayer.EXTRA, key, type);
        }
        if (layer == EnumSkinLayer.BASE && (key.equalsIgnoreCase("Skin") || key.equalsIgnoreCase("None"))) {
            DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
            return DragonEditorHandler.getSkinTexture(player, layer, type.getTypeNameLowerCase() + "_base_" + handler.getLevel().ordinal(), type);
        }
        for (DragonEditorObject.Texture texture : texts = DragonEditorRegistry.CUSTOMIZATIONS.getOrDefault(type.getTypeNameUpperCase(), new HashMap()).getOrDefault((Object)layer, new DragonEditorObject.Texture[0])) {
            if (!Objects.equals(texture.key, key)) continue;
            return new ResourceLocation(texture.texture);
        }
        return null;
    }

    public static DragonEditorObject.Texture getSkin(Player player, EnumSkinLayer layer, String key, AbstractDragonType type) {
        DragonEditorObject.Texture[] texts;
        if (Objects.equals(layer.name, "Extra") && layer != EnumSkinLayer.EXTRA) {
            return DragonEditorHandler.getSkin(player, EnumSkinLayer.EXTRA, key, type);
        }
        if (layer == EnumSkinLayer.BASE && (key.equalsIgnoreCase("Skin") || key.equalsIgnoreCase("None"))) {
            return DragonEditorHandler.getSkin(player, layer, type.getTypeNameLowerCase() + "_base_" + DragonUtils.getDragonLevel((Entity)player).ordinal(), type);
        }
        for (DragonEditorObject.Texture texture : texts = DragonEditorRegistry.CUSTOMIZATIONS.getOrDefault(type.getTypeNameUpperCase(), new HashMap()).getOrDefault((Object)layer, new DragonEditorObject.Texture[0])) {
            if (!Objects.equals(texture.key, key)) continue;
            return texture;
        }
        return null;
    }

    public static ArrayList<String> getKeys(AbstractDragonType type, EnumSkinLayer layers) {
        DragonEditorObject.Texture[] texts;
        if (Objects.equals(layers.name, "Extra") && layers != EnumSkinLayer.EXTRA) {
            return DragonEditorHandler.getKeys(type, EnumSkinLayer.EXTRA);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (DragonEditorObject.Texture texture : texts = DragonEditorRegistry.CUSTOMIZATIONS.getOrDefault(type.getTypeNameUpperCase(), new HashMap()).getOrDefault((Object)layers, new DragonEditorObject.Texture[0])) {
            list.add(texture.key);
        }
        return list;
    }

    public static ArrayList<String> getKeys(Player player, EnumSkinLayer layers) {
        return DragonEditorHandler.getKeys(DragonUtils.getDragonType((Entity)player), layers);
    }

    public static void generateSkinTextures(DragonEntity dragon) {
        Player player = dragon.getPlayer();
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> DragonEditorHandler.genTextures(player, handler));
        } else {
            DragonEditorHandler.genTextures(player, handler);
        }
    }

    private static void genTextures(Player player, DragonStateHandler handler) {
        Set<DragonLevel> dragonLevels = handler.getSkinData().skinPreset.skinAges.keySet();
        for (DragonLevel dragonLevel : dragonLevels) {
            SkinPreset.SkinAgeGroup skinAgeGroup = (SkinPreset.SkinAgeGroup)handler.getSkinData().skinPreset.skinAges.get((Object)dragonLevel).get();
            NativeImage normal = new NativeImage(512, 512, true);
            NativeImage glow = new NativeImage(512, 512, true);
            for (EnumSkinLayer layer : EnumSkinLayer.values()) {
                DragonEditorObject.Texture skinTexture;
                LayerSettings settings = (LayerSettings)skinAgeGroup.layerSettings.get((Object)layer).get();
                String selectedSkin = settings.selectedSkin;
                if (selectedSkin == null || (skinTexture = DragonEditorHandler.getSkin(player, layer, selectedSkin, handler.getType())) == null) continue;
                float hueVal = settings.hue - skinTexture.average_hue.floatValue();
                float satVal = settings.saturation;
                float brightVal = settings.brightness;
                try {
                    ResourceLocation textureLocation = DragonEditorHandler.getSkinTexture(player, layer, selectedSkin, handler.getType());
                    Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(textureLocation);
                    if (resource.isEmpty()) {
                        throw new IOException(String.format("Resource %s not found!", textureLocation.m_135815_()));
                    }
                    InputStream textureStream = ((Resource)resource.get()).m_215507_();
                    NativeImage tempColorPicker = NativeImage.m_85058_((InputStream)textureStream);
                    textureStream.close();
                    for (int x = 0; x < tempColorPicker.m_84982_(); ++x) {
                        for (int y = 0; y < tempColorPicker.m_85084_(); ++y) {
                            Color color = DragonEditorHandler.getColor(settings, skinTexture, hueVal, satVal, brightVal, tempColorPicker, x, y);
                            if (color == null || color.getAlpha() == 0) continue;
                            Supplier<NativeImage> g2 = settings.glowing ? () -> glow : () -> normal;
                            g2.get().m_84988_(x, y, color.getRGB());
                            if (!settings.glowing || layer != EnumSkinLayer.BASE) continue;
                            normal.m_84988_(x, y, color.getRGB());
                        }
                    }
                    tempColorPicker.close();
                }
                catch (IOException e) {
                    DragonSurvivalMod.LOGGER.error("An error occured while compiling the dragon skin texture", (Throwable)e);
                }
            }
            String uuid = player.m_20149_();
            ResourceLocation dynamicNormalKey = new ResourceLocation("dragonsurvival", "dynamic_normal_" + uuid + "_" + dragonLevel.name);
            ResourceLocation dynamicGlowKey = new ResourceLocation("dragonsurvival", "dynamic_glow_" + uuid + "_" + dragonLevel.name);
            DragonEditorHandler.registerCompiledTexture(normal, dynamicNormalKey);
            DragonEditorHandler.registerCompiledTexture(glow, dynamicGlowKey);
        }
        handler.getSkinData().recompileSkin = false;
        handler.getSkinData().isCompiled = true;
    }

    @Nullable
    private static Color getColor(LayerSettings settings, DragonEditorObject.Texture text, float hueVal, float satVal, float brightVal, NativeImage img, int x, int y) {
        float[] hsb = new float[3];
        Color color = new Color(img.m_84985_(x, y), true);
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        if (text.colorable) {
            if (settings.glowing && hsb[0] == 0.5f && hsb[1] == 0.5f) {
                return null;
            }
            hsb[0] = hsb[0] - hueVal;
            hsb[1] = (float)Mth.m_14139_((double)(Math.abs(satVal - 0.5f) * 2.0f), (double)hsb[1], (double)(satVal > 0.5f ? 1.0 : 0.0));
            hsb[2] = (float)Mth.m_14139_((double)(Math.abs(brightVal - 0.5f) * 2.0f), (double)hsb[2], (double)(brightVal > 0.5f ? 1.0 : 0.0));
        }
        Color c = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), color.getAlpha());
    }

    private static void registerCompiledTexture(NativeImage image, ResourceLocation key) {
        try (NativeImage nativeImage = image;){
            AbstractTexture abstractTexture = Minecraft.m_91087_().m_91097_().m_174786_(key, null);
            if (abstractTexture instanceof DynamicTexture) {
                DynamicTexture texture = (DynamicTexture)abstractTexture;
                texture.m_117988_(image);
                texture.m_117985_();
            } else {
                DynamicTexture layer = new DynamicTexture(image);
                Minecraft.m_91087_().m_91097_().m_118495_(key, (AbstractTexture)layer);
            }
        }
        catch (Exception e) {
            DragonSurvivalMod.LOGGER.error((Object)e);
        }
    }
}

