/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvivalMod;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.EnumSkinLayer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.SkinPortingSystem;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonEditorObject;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.SavedSkinPresets;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.SkinPreset;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import by.dragonsurvivalteam.dragonsurvival.util.GsonFactory;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DragonEditorRegistry {
    public static final String SAVED_FILE_NAME = "saved_customizations.json";
    public static final ResourceLocation CUSTOMIZATION = new ResourceLocation("dragonsurvival", "customization.json");
    public static final HashMap<String, HashMap<EnumSkinLayer, DragonEditorObject.Texture[]>> CUSTOMIZATIONS = new HashMap();
    private static boolean init = false;
    private static SavedSkinPresets savedCustomizations = null;
    public static HashMap<String, HashMap<DragonLevel, HashMap<EnumSkinLayer, String>>> defaultSkinValues = new HashMap();
    public static File folder;
    public static File savedFile;

    public static String getDefaultPart(AbstractDragonType type, DragonLevel level, EnumSkinLayer layer) {
        return defaultSkinValues.getOrDefault(type.getTypeNameUpperCase(), new HashMap()).getOrDefault((Object)level, new HashMap()).getOrDefault((Object)layer, "None");
    }

    public static SavedSkinPresets getSavedCustomizations() {
        if (!init) {
            DragonEditorRegistry.genDefaults();
        }
        return savedCustomizations;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientStart(FMLClientSetupEvent event) {
        DragonEditorRegistry.genDefaults();
        if (Minecraft.m_91087_().m_91098_() instanceof ReloadableResourceManager) {
            ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)((ResourceManagerReloadListener)manager -> {
                CUSTOMIZATIONS.clear();
                DragonEditorRegistry.reload(Minecraft.m_91087_().m_91098_(), CUSTOMIZATION);
            }));
        }
    }

    private static void genDefaults() {
        File oldFile;
        if (init) {
            return;
        }
        DragonEditorRegistry.reload(Minecraft.m_91087_().m_91098_(), CUSTOMIZATION);
        folder = new File(FMLPaths.GAMEDIR.get().toFile(), "dragon-survival");
        savedFile = new File(folder, SAVED_FILE_NAME);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if ((oldFile = new File(FMLPaths.CONFIGDIR.get().toFile(), "/dragon-survival/saved_customizations.json")).exists()) {
            oldFile.renameTo(savedFile);
            oldFile.getParentFile().delete();
            savedFile = new File(folder, SAVED_FILE_NAME);
        }
        if (!savedFile.exists()) {
            try {
                savedFile.createNewFile();
                Gson gson = GsonFactory.newBuilder().setPrettyPrinting().create();
                savedCustomizations = new SavedSkinPresets();
                for (String t : DragonTypes.getTypes()) {
                    String type = t.toUpperCase(Locale.ENGLISH);
                    DragonEditorRegistry.savedCustomizations.skinPresets.computeIfAbsent(type, b -> new HashMap());
                    DragonEditorRegistry.savedCustomizations.current.computeIfAbsent(type, b -> new HashMap());
                    for (int i = 0; i < 9; ++i) {
                        DragonEditorRegistry.savedCustomizations.skinPresets.get(type).computeIfAbsent(i, b -> {
                            SkinPreset preset = new SkinPreset();
                            preset.initDefaults(DragonTypes.getStatic(type));
                            return preset;
                        });
                    }
                    for (DragonLevel level : DragonLevel.values()) {
                        DragonEditorRegistry.savedCustomizations.current.get(type).put(level, 0);
                    }
                }
                FileWriter writer = new FileWriter(savedFile);
                gson.toJson((Object)savedCustomizations, (Appendable)writer);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Gson gson = GsonFactory.getDefault();
                FileInputStream in = new FileInputStream(savedFile);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                    savedCustomizations = (SavedSkinPresets)gson.fromJson((Reader)reader, SavedSkinPresets.class);
                    savedCustomizations = SkinPortingSystem.upgrade(savedCustomizations);
                }
                catch (IOException exception) {
                    DragonSurvivalMod.LOGGER.warn("Reader could not be closed", (Throwable)exception);
                }
            }
            catch (FileNotFoundException exception) {
                DragonSurvivalMod.LOGGER.error("Saved customization [" + savedFile.getName() + "] could not be found", (Throwable)exception);
            }
        }
        init = true;
    }

    protected static void reload(ResourceManager manager, ResourceLocation location) {
        try {
            Gson gson = GsonFactory.getDefault();
            Optional resource = manager.m_213713_(location);
            if (resource.isEmpty()) {
                throw new IOException(String.format("Resource %s not found!", location.m_135815_()));
            }
            InputStream in = ((Resource)resource.get()).m_215507_();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                DragonEditorObject je = (DragonEditorObject)gson.fromJson((Reader)reader, DragonEditorObject.class);
                CUSTOMIZATIONS.computeIfAbsent(DragonTypes.SEA.getTypeNameUpperCase(), type -> new HashMap());
                CUSTOMIZATIONS.computeIfAbsent(DragonTypes.CAVE.getTypeNameUpperCase(), type -> new HashMap());
                CUSTOMIZATIONS.computeIfAbsent(DragonTypes.FOREST.getTypeNameUpperCase(), type -> new HashMap());
                DragonEditorRegistry.dragonType(DragonTypes.SEA, je.sea_dragon);
                DragonEditorRegistry.dragonType(DragonTypes.CAVE, je.cave_dragon);
                DragonEditorRegistry.dragonType(DragonTypes.FOREST, je.forest_dragon);
                defaultSkinValues = je.defaults;
            }
            catch (IOException exception) {
                DragonSurvivalMod.LOGGER.warn("Reader could not be closed", (Throwable)exception);
            }
        }
        catch (IOException exception) {
            DragonSurvivalMod.LOGGER.error("Resource [" + location + "] could not be opened", (Throwable)exception);
        }
    }

    private static void dragonType(AbstractDragonType type, DragonEditorObject.Dragon je) {
        if (je != null && je.layers != null) {
            je.layers.forEach((layer, keys) -> {
                for (DragonEditorObject.Texture key : keys) {
                    if (key.key != null) continue;
                    key.key = key.texture.substring(key.texture.lastIndexOf("/") + 1);
                    key.key = key.key.substring(0, key.key.lastIndexOf("."));
                }
                CUSTOMIZATIONS.get(type.getTypeNameUpperCase()).put((EnumSkinLayer)((Object)layer), (DragonEditorObject.Texture[])keys);
            });
        }
    }
}

