/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects;

import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.DragonEditorRegistry;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.EnumSkinLayer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonEditorObject;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.LayerSettings;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.NBTInterface;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.Lazy;

public class SkinPreset
implements NBTInterface {
    public HashMap<DragonLevel, Lazy<SkinAgeGroup>> skinAges = new HashMap();

    public SkinPreset() {
        for (DragonLevel level : DragonLevel.values()) {
            this.skinAges.computeIfAbsent(level, _level -> Lazy.of(() -> new SkinAgeGroup((DragonLevel)((Object)_level))));
        }
    }

    public void initDefaults(DragonStateHandler handler) {
        this.initDefaults(handler.getType());
    }

    public void initDefaults(AbstractDragonType type) {
        for (DragonLevel level : DragonLevel.values()) {
            this.skinAges.put(level, (Lazy<SkinAgeGroup>)Lazy.of(() -> new SkinAgeGroup(level, type)));
        }
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        for (DragonLevel level : DragonLevel.values()) {
            nbt.m_128365_(level.name, (Tag)((SkinAgeGroup)this.skinAges.getOrDefault((Object)level, (Lazy<SkinAgeGroup>)Lazy.of(() -> new SkinAgeGroup(level))).get()).writeNBT());
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag base) {
        for (DragonLevel level : DragonLevel.values()) {
            this.skinAges.put(level, (Lazy<SkinAgeGroup>)Lazy.of(() -> {
                SkinAgeGroup ageGroup = new SkinAgeGroup(level);
                CompoundTag nbt = base.m_128469_(level.name);
                ageGroup.readNBT(nbt);
                return ageGroup;
            }));
        }
    }

    public static class SkinAgeGroup
    implements NBTInterface {
        public DragonLevel level;
        public HashMap<EnumSkinLayer, Lazy<LayerSettings>> layerSettings = new HashMap();
        public boolean wings = true;
        public boolean defaultSkin = false;

        public SkinAgeGroup(DragonLevel level, AbstractDragonType type) {
            this(level);
            block0: for (EnumSkinLayer layer : EnumSkinLayer.values()) {
                String part = DragonEditorRegistry.getDefaultPart(type, level, layer);
                EnumSkinLayer trueLayer = EnumSkinLayer.valueOf(layer.getNameUpperCase());
                HashMap<EnumSkinLayer, DragonEditorObject.Texture[]> hm = DragonEditorRegistry.CUSTOMIZATIONS.get(type.getTypeNameUpperCase());
                if (hm != null) {
                    DragonEditorObject.Texture[] texts = hm.get((Object)trueLayer);
                    if (texts != null) {
                        for (DragonEditorObject.Texture text : texts) {
                            if (!text.key.equals(part)) continue;
                            this.layerSettings.put(layer, (Lazy<LayerSettings>)Lazy.of(() -> new LayerSettings(part, text.average_hue != null ? text.average_hue.floatValue() : 0.5f)));
                            continue block0;
                        }
                        continue;
                    }
                    this.layerSettings.put(layer, (Lazy<LayerSettings>)Lazy.of(() -> new LayerSettings(part, 0.5f)));
                    continue;
                }
                this.layerSettings.put(layer, (Lazy<LayerSettings>)Lazy.of(() -> new LayerSettings(part, 0.5f)));
            }
        }

        public SkinAgeGroup(DragonLevel level) {
            this.level = level;
            for (EnumSkinLayer layer : EnumSkinLayer.values()) {
                this.layerSettings.computeIfAbsent(layer, s -> Lazy.of(LayerSettings::new));
            }
        }

        @Override
        public CompoundTag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("wings", this.wings);
            nbt.m_128379_("defaultSkin", this.defaultSkin);
            for (EnumSkinLayer layer : EnumSkinLayer.values()) {
                nbt.m_128365_(layer.name(), (Tag)((LayerSettings)this.layerSettings.getOrDefault((Object)layer, (Lazy<LayerSettings>)Lazy.of(LayerSettings::new)).get()).writeNBT());
            }
            return nbt;
        }

        @Override
        public void readNBT(CompoundTag base) {
            this.wings = base.m_128471_("wings");
            this.defaultSkin = base.m_128471_("defaultSkin");
            for (EnumSkinLayer layer : EnumSkinLayer.values()) {
                this.layerSettings.put(layer, (Lazy<LayerSettings>)Lazy.of(() -> {
                    LayerSettings ageGroup = new LayerSettings();
                    CompoundTag nbt = base.m_128469_(layer.name());
                    ageGroup.readNBT(nbt);
                    return ageGroup;
                }));
            }
        }
    }
}

