/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.skins;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvivalMod;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRender;
import by.dragonsurvivalteam.dragonsurvival.client.skins.GitcodeSkinLoader;
import by.dragonsurvivalteam.dragonsurvival.client.skins.GithubSkinLoader;
import by.dragonsurvivalteam.dragonsurvival.client.skins.GithubSkinLoaderAPI;
import by.dragonsurvivalteam.dragonsurvival.client.skins.NetSkinLoader;
import by.dragonsurvivalteam.dragonsurvival.client.skins.SkinObject;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DragonSkins {
    protected static boolean initialized = false;
    public static NetSkinLoader skinLoader = new GithubSkinLoaderAPI();
    private static final ArrayList<String> hasFailedFetch = new ArrayList();
    public static HashMap<DragonLevel, HashMap<String, SkinObject>> SKIN_USERS = new HashMap();
    public static HashMap<String, ResourceLocation> playerSkinCache = new HashMap();
    public static HashMap<String, ResourceLocation> playerGlowCache = new HashMap();

    public static ResourceLocation getPlayerSkin(String playerName, DragonLevel level) {
        ResourceLocation texture;
        String skinKey = playerName + "_" + level.name;
        if (playerSkinCache.containsKey(skinKey) && playerSkinCache.get(skinKey) != null) {
            return playerSkinCache.get(skinKey);
        }
        if (!hasFailedFetch.contains(skinKey) && !playerSkinCache.containsKey(skinKey) && (texture = DragonSkins.fetchSkinFile(playerName, level, new String[0])) != null) {
            playerSkinCache.put(skinKey, texture);
            return texture;
        }
        return null;
    }

    public static ResourceLocation getPlayerGlow(String playerName, DragonLevel level) {
        String skinKey = playerName + "_" + level.name;
        if (playerGlowCache.containsKey(skinKey)) {
            return playerGlowCache.get(skinKey);
        }
        ResourceLocation texture = DragonSkins.fetchSkinFile(playerName, level, "glow");
        playerGlowCache.put(skinKey, texture);
        return texture;
    }

    public static ResourceLocation getPlayerSkin(Player player, AbstractDragonType type, DragonLevel dragonStage) {
        ResourceLocation texture = null;
        String playerKey = player.m_36316_().getName() + "_" + dragonStage.name;
        boolean renderStage = DragonSkins.renderStage(player, dragonStage);
        if ((ClientDragonRender.renderOtherPlayerSkins.booleanValue() || player == Minecraft.m_91087_().f_91074_) && renderStage) {
            if (playerSkinCache.containsKey(playerKey) && playerSkinCache.get(playerKey) != null) {
                return playerSkinCache.get(playerKey);
            }
            if (!hasFailedFetch.contains(playerKey) && !playerSkinCache.containsKey(playerKey) && (texture = DragonSkins.fetchSkinFile(player, dragonStage, new String[0])) != null) {
                playerSkinCache.put(playerKey, texture);
            }
        }
        return texture;
    }

    public static ResourceLocation fetchSkinFile(String playerName, DragonLevel level, String ... extra) {
        ResourceLocation exception2;
        block29: {
            NetSkinLoader netSkinLoader;
            String playerKey = playerName + "_" + level.name;
            Object[] text = (String[])ArrayUtils.addAll((Object[])new String[]{playerKey}, (Object[])extra);
            String resourceName = StringUtils.join((Object[])text, (String)"_");
            ResourceLocation resourceLocation = new ResourceLocation("dragonsurvival", resourceName.toLowerCase(Locale.ENGLISH));
            try (SimpleTexture simpleTexture = new SimpleTexture(resourceLocation);){
                if (Minecraft.m_91087_().m_91097_().m_174786_(resourceLocation, (AbstractTexture)simpleTexture) != simpleTexture) {
                    ResourceLocation resourceLocation2 = resourceLocation;
                    return resourceLocation2;
                }
            }
            HashMap playerSkinMap = SKIN_USERS.getOrDefault((Object)level, null);
            if (playerSkinMap == null) {
                DragonSurvivalMod.LOGGER.warn("Customs skins are not yet fetched, re-fetching...");
                DragonSkins.init();
                playerSkinMap = SKIN_USERS.getOrDefault((Object)level, null);
                if (playerSkinMap == null) {
                    DragonSurvivalMod.LOGGER.error("Custom skins could not be fetched");
                }
            }
            String skinName = StringUtils.join((Object[])ArrayUtils.addAll((Object[])new String[]{playerName}, (Object[])extra), (String)"_");
            SkinObject skin = null;
            if (playerSkinMap != null) {
                skin = playerSkinMap.getOrDefault(skinName, null);
            }
            if ((netSkinLoader = skinLoader) instanceof GithubSkinLoader) {
                ResourceLocation resourceLocation3;
                block28: {
                    GithubSkinLoader gitHubOld = (GithubSkinLoader)netSkinLoader;
                    InputStream imageStream = gitHubOld.querySkinImage(skinName, level);
                    try {
                        resourceLocation3 = DragonSkins.readSkin(imageStream, resourceLocation);
                        if (imageStream == null) break block28;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (imageStream != null) {
                                try {
                                    imageStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException exception2) {
                            boolean isNormalSkin = extra == null || extra.length == 0;
                            DragonSkins.handleSkinFetchError(playerKey, isNormalSkin);
                            return null;
                        }
                    }
                    imageStream.close();
                }
                return resourceLocation3;
            }
            if (skin == null) {
                return null;
            }
            InputStream imageStream = skinLoader.querySkinImage(skin);
            try {
                exception2 = DragonSkins.readSkin(imageStream, resourceLocation);
                if (imageStream == null) break block29;
            }
            catch (Throwable exception2) {
                try {
                    if (imageStream != null) {
                        try {
                            imageStream.close();
                        }
                        catch (Throwable throwable) {
                            exception2.addSuppressed(throwable);
                        }
                    }
                    throw exception2;
                }
                catch (IOException exception3) {
                    boolean isNormalSkin = extra == null || extra.length == 0;
                    DragonSkins.handleSkinFetchError(playerKey, isNormalSkin);
                    return null;
                }
            }
            imageStream.close();
        }
        return exception2;
    }

    private static ResourceLocation readSkin(InputStream imageStream, ResourceLocation location) throws IOException {
        if (imageStream == null) {
            throw new IOException("Skin was not successfully fetched for [" + location + "]");
        }
        NativeImage customTexture = NativeImage.m_85058_((InputStream)imageStream);
        Minecraft.m_91087_().m_91097_().m_118495_(location, (AbstractTexture)new DynamicTexture(customTexture));
        return location;
    }

    private static void handleSkinFetchError(String playerKey, boolean isNormalSkin) {
        if (isNormalSkin && !hasFailedFetch.contains(playerKey)) {
            DragonSurvivalMod.LOGGER.info("Custom skin for user {} doesn't exist", (Object)playerKey);
            hasFailedFetch.add(playerKey);
        }
    }

    public static ResourceLocation fetchSkinFile(Player playerEntity, DragonLevel dragonStage, String ... extra) {
        return DragonSkins.fetchSkinFile(playerEntity.m_36316_().getName(), dragonStage, extra);
    }

    public static boolean renderStage(Player player, DragonLevel level) {
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case DragonLevel.NEWBORN -> handler.getSkinData().renderNewborn;
            case DragonLevel.YOUNG -> handler.getSkinData().renderYoung;
            case DragonLevel.ADULT -> handler.getSkinData().renderAdult;
        };
    }

    public static ResourceLocation getGlowTexture(Player player, AbstractDragonType type, DragonLevel dragonStage) {
        ResourceLocation texture = null;
        String playerKey = player.m_36316_().getName() + "_" + dragonStage.name;
        boolean renderStage = DragonSkins.renderStage(player, dragonStage);
        if ((ClientDragonRender.renderOtherPlayerSkins.booleanValue() || player == Minecraft.m_91087_().f_91074_) && playerSkinCache.containsKey(playerKey) && renderStage) {
            if (playerGlowCache.containsKey(playerKey)) {
                return playerGlowCache.get(playerKey);
            }
            texture = DragonSkins.fetchSkinFile(player, dragonStage, "glow");
            playerGlowCache.put(playerKey, texture);
            if (texture == null) {
                DragonSurvivalMod.LOGGER.info("Custom glow for user {} doesn't exist", (Object)player.m_36316_().getName());
            }
        }
        return texture;
    }

    public static void init() {
        DragonSkins.init(false);
    }

    public static void init(boolean force) {
        Collection<SkinObject> skins;
        NetSkinLoader second;
        NetSkinLoader first;
        if (initialized && !force) {
            return;
        }
        initialized = true;
        DragonSkins.invalidateSkins();
        String currentLanguage = Minecraft.m_91087_().m_91102_().m_264236_();
        if (currentLanguage.equals("zh_cn")) {
            first = new GitcodeSkinLoader();
            second = new GithubSkinLoader();
        } else {
            first = new GithubSkinLoader();
            second = new GitcodeSkinLoader();
        }
        if (!first.ping()) {
            if (!second.ping()) {
                DragonSurvivalMod.LOGGER.warn("Unable to connect to skin database.");
                return;
            }
            first = second;
        }
        if ((skins = (skinLoader = first).querySkinList()) != null) {
            DragonSkins.parseSkinObjects(skins);
        }
    }

    public static void parseSkinObjects(Collection<SkinObject> skinObjects) {
        for (SkinObject skin : skinObjects) {
            String level;
            DragonLevel size;
            boolean isGlow = false;
            String skinName = skin.name;
            if ((skinName = skin.name.substring(0, skinName.indexOf("."))).endsWith("_glow")) {
                isGlow = true;
                skinName = skin.name.substring(0, skinName.lastIndexOf("_"));
            }
            if (!skinName.contains("_")) continue;
            Object name = skinName.substring(0, skinName.lastIndexOf("_"));
            if (isGlow) {
                name = (String)name + "_glow";
            }
            if ((size = (level = skinName.substring(skinName.lastIndexOf("_") + 1)).equalsIgnoreCase("adult") ? DragonLevel.ADULT : (level.equalsIgnoreCase("young") ? DragonLevel.YOUNG : (level.equalsIgnoreCase("newborn") ? DragonLevel.NEWBORN : null))) == null) continue;
            if (!SKIN_USERS.containsKey((Object)size)) {
                SKIN_USERS.put(size, new HashMap());
            }
            skin.short_name = name;
            skin.glow = isGlow;
            SKIN_USERS.get((Object)size).putIfAbsent((String)name, skin);
        }
    }

    private static void invalidateSkins() {
        SKIN_USERS.clear();
        playerSkinCache.clear();
        playerGlowCache.clear();
        hasFailedFetch.clear();
    }
}

