/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.skins;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvivalMod;
import by.dragonsurvivalteam.dragonsurvival.client.skins.NetSkinLoader;
import by.dragonsurvivalteam.dragonsurvival.client.skins.SkinObject;
import by.dragonsurvivalteam.dragonsurvival.util.GsonFactory;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.logging.log4j.Level;

public class GitcodeSkinLoader
extends NetSkinLoader {
    private static final String SKINS_LIST_LINK = "https://web-api.gitcode.com/api/v1/projects/mirrors%2FDragonSurvivalTeam%2FDragonSurvival/repository/tree?ref=master&path=src/test/resources&per_page=100&page=";
    private static final String SKINS_DOWNLOAD_LINK = "https://web-api.gitcode.com/api/v1/projects/mirrors%%2FDragonSurvivalTeam%%2FDragonSurvival/repository/blobs/%s/raw?ref=master&file_name=%s";
    private static final String SKINS_PING = "https://web-api.gitcode.com/api/v1/projects/mirrors%2FDragonSurvivalTeam%2FDragonSurvival/repository/tree?ref=master&path=src/test&per_page=100&page=1";
    private static final HashMap<String, String> GITCODE_HEADER = new HashMap<String, String>(){
        {
            this.put("referer", "https://gitcode.com/");
        }
    };

    @Override
    public Collection<SkinObject> querySkinList() {
        ArrayList<SkinObject> result = new ArrayList<SkinObject>();
        int page = 1;
        try {
            while (true) {
                Gson gson = GsonFactory.getDefault();
                URL url = new URL(SKINS_LIST_LINK + page);
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.internetGetStream(url, GITCODE_HEADER, 2000)));
                SkinListApiResponse skinListResponse = (SkinListApiResponse)gson.fromJson((Reader)reader, SkinListApiResponse.class);
                reader.close();
                if (skinListResponse.content.length == 0) break;
                result.addAll(Arrays.asList(skinListResponse.content));
                ++page;
            }
            return result;
        }
        catch (IOException e) {
            DragonSurvivalMod.LOGGER.log(Level.WARN, "Failed to get skin information in Gitcode.");
            return null;
        }
    }

    @Override
    public InputStream querySkinImage(SkinObject skin) throws IOException {
        return this.internetGetStream(new URL(String.format(SKINS_DOWNLOAD_LINK, skin.id, skin.name)), GITCODE_HEADER, 15000);
    }

    @Override
    public boolean ping() {
        boolean bl;
        block8: {
            InputStream ignore = this.internetGetStream(new URL(SKINS_PING), GITCODE_HEADER, 3000);
            try {
                bl = true;
                if (ignore == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            ignore.close();
        }
        return bl;
    }

    private static class SkinListApiResponse {
        int page_num;
        int page_size;
        int total;
        int page_count;
        SkinObject[] content;

        private SkinListApiResponse() {
        }
    }
}

