/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.skins;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvivalMod;
import by.dragonsurvivalteam.dragonsurvival.client.skins.NetSkinLoader;
import by.dragonsurvivalteam.dragonsurvival.client.skins.SkinObject;
import by.dragonsurvivalteam.dragonsurvival.util.GsonFactory;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import org.apache.logging.log4j.Level;

public class GithubSkinLoaderAPI
extends NetSkinLoader {
    public static final String SKINS_LIST_LINK = "https://api.github.com/repositories/280658566/git/trees/6597d654e16568d2d9e2cdf0dc372041cb081c35?ref=master";
    private static final String SKINS_PING = "https://raw.githubusercontent.com/DragonSurvivalTeam/DragonSurvival/master/README.md";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<SkinObject> querySkinList() {
        ArrayList<SkinObject> result = new ArrayList<SkinObject>();
        try {
            Gson gson = GsonFactory.getDefault();
            URL url = new URL(SKINS_LIST_LINK);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.internetGetStream(url, 2000)));){
                SkinListApiResponse skinListResponse = (SkinListApiResponse)gson.fromJson((Reader)reader, SkinListApiResponse.class);
                for (SkinResponseItem skinResponse : skinListResponse.tree) {
                    SkinObject skinObject = new SkinObject();
                    skinObject.name = skinResponse.path;
                    skinObject.id = skinResponse.sha;
                    skinObject.user_extra = skinResponse;
                    result.add(skinObject);
                }
                ArrayList<SkinObject> throwable2 = result;
                return throwable2;
            }
            catch (IOException exception) {
                DragonSurvivalMod.LOGGER.warn("Reader could not be closed", (Throwable)exception);
                return null;
            }
        }
        catch (IOException e) {
            DragonSurvivalMod.LOGGER.log(Level.WARN, "Failed to get skin information in Github.");
        }
        return null;
    }

    @Override
    public InputStream querySkinImage(SkinObject skin) throws IOException {
        Gson gson = GsonFactory.getDefault();
        SkinResponseItem skinExtra = (SkinResponseItem)skin.user_extra;
        try (InputStream skinMetadataStream = this.internetGetStream(new URL(skinExtra.url), 15000);){
            SkinFileMetaInfo skinMetaInfo = (SkinFileMetaInfo)gson.fromJson((Reader)new BufferedReader(new InputStreamReader(skinMetadataStream)), SkinFileMetaInfo.class);
            String base64Content = skinMetaInfo.content.replace("\n", "");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.getDecoder().decode(base64Content));
            return byteArrayInputStream;
        }
    }

    @Override
    public boolean ping() {
        boolean bl;
        block8: {
            InputStream ignore = this.internetGetStream(new URL(SKINS_PING), 3000);
            try {
                bl = true;
                if (ignore == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            ignore.close();
        }
        return bl;
    }

    private static class SkinListApiResponse {
        SkinResponseItem[] tree;

        private SkinListApiResponse() {
        }
    }

    private static class SkinResponseItem {
        String path;
        String sha;
        String url;

        private SkinResponseItem() {
        }
    }

    private static class SkinFileMetaInfo {
        String content;
        String encoding;

        private SkinFileMetaInfo() {
        }
    }
}

