/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.sounds;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SoundRegistry {
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"dragonsurvival");
    public static SoundEvent activateBeacon;
    public static SoundEvent deactivateBeacon;
    public static SoundEvent upgradeBeacon;
    public static SoundEvent applyEffect;
    public static SoundEvent fireBreathStart;
    public static SoundEvent fireBreathLoop;
    public static SoundEvent fireBreathEnd;
    public static SoundEvent forestBreathStart;
    public static SoundEvent forestBreathLoop;
    public static SoundEvent forestBreathEnd;
    public static SoundEvent stormBreathStart;
    public static SoundEvent stormBreathLoop;
    public static SoundEvent stormBreathEnd;
    public static RegistryObject<SoundEvent> treasureGemBreak;
    public static RegistryObject<SoundEvent> treasureGemHit;
    public static ForgeSoundType treasureGem;
    public static RegistryObject<SoundEvent> treasureMetalBreak;
    public static RegistryObject<SoundEvent> treasureMetalHit;
    public static ForgeSoundType treasureMetal;

    public static void register() {
        activateBeacon = SoundRegistry.register("activate_beacon");
        deactivateBeacon = SoundRegistry.register("deactivate_beacon");
        upgradeBeacon = SoundRegistry.register("upgrade_beacon");
        applyEffect = SoundRegistry.register("apply_effect");
        fireBreathStart = SoundRegistry.register("fire_breath_start");
        fireBreathLoop = SoundRegistry.register("fire_breath_loop");
        fireBreathEnd = SoundRegistry.register("fire_breath_end");
        forestBreathStart = SoundRegistry.register("forest_breath_start");
        forestBreathLoop = SoundRegistry.register("forest_breath_loop");
        forestBreathEnd = SoundRegistry.register("forest_breath_end");
        stormBreathStart = SoundRegistry.register("storm_breath_start");
        stormBreathLoop = SoundRegistry.register("storm_breath_loop");
        stormBreathEnd = SoundRegistry.register("storm_breath_end");
    }

    private static SoundEvent register(String name) {
        SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("dragonsurvival", name));
        SOUNDS.register(name, () -> soundEvent);
        return soundEvent;
    }

    static {
        treasureGemBreak = SOUNDS.register("treasure_gem_break", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("dragonsurvival", "treasure_gem_break")));
        treasureGemHit = SOUNDS.register("treasure_gem_hit", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("dragonsurvival", "treasure_gem_hit")));
        treasureGem = new ForgeSoundType(1.0f, 1.0f, treasureGemBreak, treasureGemHit, treasureGemHit, treasureGemHit, treasureGemHit);
        treasureMetalBreak = SOUNDS.register("treasure_metal_break", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("dragonsurvival", "treasure_metal_break")));
        treasureMetalHit = SOUNDS.register("treasure_metal_hit", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("dragonsurvival", "treasure_metal_hit")));
        treasureMetal = new ForgeSoundType(1.0f, 1.0f, treasureMetalBreak, treasureMetalHit, treasureMetalHit, treasureMetalHit, treasureMetalHit);
    }
}

