/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.util;

import by.dragonsurvivalteam.dragonsurvival.client.util.FakeClientPlayer;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class FakeClientPlayerUtils {
    private static final ConcurrentHashMap<Integer, FakeClientPlayer> FAKE_PLAYERS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, DragonEntity> FAKE_DRAGONS = new ConcurrentHashMap();

    public static DragonEntity getFakeDragon(int index, DragonStateHandler handler) {
        final FakeClientPlayer fakePlayer = FakeClientPlayerUtils.getFakePlayer(index, handler);
        return FAKE_DRAGONS.computeIfAbsent(index, key -> new DragonEntity((EntityType)DSEntities.DRAGON.get(), fakePlayer.m_9236_()){

            @Override
            public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
                AnimationController controller;
                fakePlayer.animationController = controller = new AnimationController((GeoAnimatable)this, "fake_player_controller", 2, state -> {
                    if (fakePlayer2.handler.refreshBody) {
                        fakePlayer2.animationController.forceAnimationReset();
                        fakePlayer2.handler.refreshBody = false;
                        return PlayState.STOP;
                    }
                    if (fakePlayer2.animationSupplier != null) {
                        return state.setAndContinue(RawAnimation.begin().thenLoop(fakePlayer2.animationSupplier.get()));
                    }
                    return PlayState.STOP;
                });
                controllers.add(new AnimationController[]{controller});
            }

            @Override
            public Player getPlayer() {
                return fakePlayer;
            }
        });
    }

    public static FakeClientPlayer getFakePlayer(int index, DragonStateHandler handler) {
        FAKE_PLAYERS.computeIfAbsent(index, FakeClientPlayer::new);
        FakeClientPlayerUtils.FAKE_PLAYERS.get((Object)Integer.valueOf((int)index)).handler = handler;
        FakeClientPlayerUtils.FAKE_PLAYERS.get((Object)Integer.valueOf((int)index)).lastAccessed = System.currentTimeMillis();
        return FAKE_PLAYERS.get(index);
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        FAKE_PLAYERS.forEach((index, player) -> {
            if (System.currentTimeMillis() - player.lastAccessed >= TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES)) {
                player.m_142687_(Entity.RemovalReason.DISCARDED);
                DragonEntity dragon = FAKE_DRAGONS.get(index);
                if (dragon != null) {
                    dragon.m_142687_(Entity.RemovalReason.DISCARDED);
                    FAKE_DRAGONS.remove(index);
                }
                FAKE_PLAYERS.remove(index);
            }
        });
    }
}

